package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainOriginTrafficData invokes the scdn.DescribeScdnDomainOriginTrafficData API synchronously
func (client *Client) DescribeScdnDomainOriginTrafficData(request *DescribeScdnDomainOriginTrafficDataRequest) (response *DescribeScdnDomainOriginTrafficDataResponse, err error) {
	response = CreateDescribeScdnDomainOriginTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainOriginTrafficDataWithChan invokes the scdn.DescribeScdnDomainOriginTrafficData API asynchronously
func (client *Client) DescribeScdnDomainOriginTrafficDataWithChan(request *DescribeScdnDomainOriginTrafficDataRequest) (<-chan *DescribeScdnDomainOriginTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainOriginTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainOriginTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainOriginTrafficDataWithCallback invokes the scdn.DescribeScdnDomainOriginTrafficData API asynchronously
func (client *Client) DescribeScdnDomainOriginTrafficDataWithCallback(request *DescribeScdnDomainOriginTrafficDataRequest, callback func(response *DescribeScdnDomainOriginTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainOriginTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainOriginTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainOriginTrafficDataRequest is the request struct for api DescribeScdnDomainOriginTrafficData
type DescribeScdnDomainOriginTrafficDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	Interval   string `position:"Query" name:"Interval"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeScdnDomainOriginTrafficDataResponse is the response struct for api DescribeScdnDomainOriginTrafficData
type DescribeScdnDomainOriginTrafficDataResponse struct {
	*responses.BaseResponse
	EndTime                      string                       `json:"EndTime" xml:"EndTime"`
	StartTime                    string                       `json:"StartTime" xml:"StartTime"`
	RequestId                    string                       `json:"RequestId" xml:"RequestId"`
	DomainName                   string                       `json:"DomainName" xml:"DomainName"`
	DataInterval                 string                       `json:"DataInterval" xml:"DataInterval"`
	OriginTrafficDataPerInterval OriginTrafficDataPerInterval `json:"OriginTrafficDataPerInterval" xml:"OriginTrafficDataPerInterval"`
}

// CreateDescribeScdnDomainOriginTrafficDataRequest creates a request to invoke DescribeScdnDomainOriginTrafficData API
func CreateDescribeScdnDomainOriginTrafficDataRequest() (request *DescribeScdnDomainOriginTrafficDataRequest) {
	request = &DescribeScdnDomainOriginTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainOriginTrafficData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScdnDomainOriginTrafficDataResponse creates a response to parse from DescribeScdnDomainOriginTrafficData response
func CreateDescribeScdnDomainOriginTrafficDataResponse() (response *DescribeScdnDomainOriginTrafficDataResponse) {
	response = &DescribeScdnDomainOriginTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
