package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScheduleEvent invokes the schedulerx3.ListScheduleEvent API synchronously
func (client *Client) ListScheduleEvent(request *ListScheduleEventRequest) (response *ListScheduleEventResponse, err error) {
	response = CreateListScheduleEventResponse()
	err = client.DoAction(request, response)
	return
}

// ListScheduleEventWithChan invokes the schedulerx3.ListScheduleEvent API asynchronously
func (client *Client) ListScheduleEventWithChan(request *ListScheduleEventRequest) (<-chan *ListScheduleEventResponse, <-chan error) {
	responseChan := make(chan *ListScheduleEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScheduleEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScheduleEventWithCallback invokes the schedulerx3.ListScheduleEvent API asynchronously
func (client *Client) ListScheduleEventWithCallback(request *ListScheduleEventRequest, callback func(response *ListScheduleEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScheduleEventResponse
		var err error
		defer close(result)
		response, err = client.ListScheduleEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScheduleEventRequest is the request struct for api ListScheduleEvent
type ListScheduleEventRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	StartTime      requests.Integer `position:"Query" name:"StartTime"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	AppName        string           `position:"Query" name:"AppName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Event          string           `position:"Query" name:"Event"`
	Keyword        string           `position:"Query" name:"Keyword"`
	JobName        string           `position:"Query" name:"JobName"`
	JobExecutionId string           `position:"Query" name:"JobExecutionId"`
	EndTime        requests.Integer `position:"Query" name:"EndTime"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	Reverse        requests.Boolean `position:"Query" name:"Reverse"`
}

// ListScheduleEventResponse is the response struct for api ListScheduleEvent
type ListScheduleEventResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListScheduleEventRequest creates a request to invoke ListScheduleEvent API
func CreateListScheduleEventRequest() (request *ListScheduleEventRequest) {
	request = &ListScheduleEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ListScheduleEvent", "", "")
	request.Method = requests.GET
	return
}

// CreateListScheduleEventResponse creates a response to parse from ListScheduleEvent response
func CreateListScheduleEventResponse() (response *ListScheduleEventResponse) {
	response = &ListScheduleEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
