package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataLimitSet invokes the sddp.DescribeDataLimitSet API synchronously
func (client *Client) DescribeDataLimitSet(request *DescribeDataLimitSetRequest) (response *DescribeDataLimitSetResponse, err error) {
	response = CreateDescribeDataLimitSetResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataLimitSetWithChan invokes the sddp.DescribeDataLimitSet API asynchronously
func (client *Client) DescribeDataLimitSetWithChan(request *DescribeDataLimitSetRequest) (<-chan *DescribeDataLimitSetResponse, <-chan error) {
	responseChan := make(chan *DescribeDataLimitSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataLimitSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataLimitSetWithCallback invokes the sddp.DescribeDataLimitSet API asynchronously
func (client *Client) DescribeDataLimitSetWithCallback(request *DescribeDataLimitSetRequest, callback func(response *DescribeDataLimitSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataLimitSetResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataLimitSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataLimitSetRequest is the request struct for api DescribeDataLimitSet
type DescribeDataLimitSetRequest struct {
	*requests.RpcRequest
	FeatureType  requests.Integer `position:"Query" name:"FeatureType"`
	ResourceType requests.Integer `position:"Query" name:"ResourceType"`
	ParentId     string           `position:"Query" name:"ParentId"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	Lang         string           `position:"Query" name:"Lang"`
}

// DescribeDataLimitSetResponse is the response struct for api DescribeDataLimitSet
type DescribeDataLimitSetResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DataLimitSet DataLimitSet `json:"DataLimitSet" xml:"DataLimitSet"`
}

// CreateDescribeDataLimitSetRequest creates a request to invoke DescribeDataLimitSet API
func CreateDescribeDataLimitSetRequest() (request *DescribeDataLimitSetRequest) {
	request = &DescribeDataLimitSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeDataLimitSet", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDataLimitSetResponse creates a response to parse from DescribeDataLimitSet response
func CreateDescribeDataLimitSetResponse() (response *DescribeDataLimitSetResponse) {
	response = &DescribeDataLimitSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
