package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssObjectDetailV2 invokes the sddp.DescribeOssObjectDetailV2 API synchronously
func (client *Client) DescribeOssObjectDetailV2(request *DescribeOssObjectDetailV2Request) (response *DescribeOssObjectDetailV2Response, err error) {
	response = CreateDescribeOssObjectDetailV2Response()
	err = client.DoAction(request, response)
	return
}

// DescribeOssObjectDetailV2WithChan invokes the sddp.DescribeOssObjectDetailV2 API asynchronously
func (client *Client) DescribeOssObjectDetailV2WithChan(request *DescribeOssObjectDetailV2Request) (<-chan *DescribeOssObjectDetailV2Response, <-chan error) {
	responseChan := make(chan *DescribeOssObjectDetailV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssObjectDetailV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssObjectDetailV2WithCallback invokes the sddp.DescribeOssObjectDetailV2 API asynchronously
func (client *Client) DescribeOssObjectDetailV2WithCallback(request *DescribeOssObjectDetailV2Request, callback func(response *DescribeOssObjectDetailV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssObjectDetailV2Response
		var err error
		defer close(result)
		response, err = client.DescribeOssObjectDetailV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssObjectDetailV2Request is the request struct for api DescribeOssObjectDetailV2
type DescribeOssObjectDetailV2Request struct {
	*requests.RpcRequest
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Id          string           `position:"Query" name:"Id"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeOssObjectDetailV2Response is the response struct for api DescribeOssObjectDetailV2
type DescribeOssObjectDetailV2Response struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	OssObjectDetail OssObjectDetail `json:"OssObjectDetail" xml:"OssObjectDetail"`
}

// CreateDescribeOssObjectDetailV2Request creates a request to invoke DescribeOssObjectDetailV2 API
func CreateDescribeOssObjectDetailV2Request() (request *DescribeOssObjectDetailV2Request) {
	request = &DescribeOssObjectDetailV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeOssObjectDetailV2", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOssObjectDetailV2Response creates a response to parse from DescribeOssObjectDetailV2 response
func CreateDescribeOssObjectDetailV2Response() (response *DescribeOssObjectDetailV2Response) {
	response = &DescribeOssObjectDetailV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
