package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPlaybook invokes the sophonsoar.ModifyPlaybook API synchronously
func (client *Client) ModifyPlaybook(request *ModifyPlaybookRequest) (response *ModifyPlaybookResponse, err error) {
	response = CreateModifyPlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPlaybookWithChan invokes the sophonsoar.ModifyPlaybook API asynchronously
func (client *Client) ModifyPlaybookWithChan(request *ModifyPlaybookRequest) (<-chan *ModifyPlaybookResponse, <-chan error) {
	responseChan := make(chan *ModifyPlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPlaybookWithCallback invokes the sophonsoar.ModifyPlaybook API asynchronously
func (client *Client) ModifyPlaybookWithCallback(request *ModifyPlaybookRequest, callback func(response *ModifyPlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPlaybookResponse
		var err error
		defer close(result)
		response, err = client.ModifyPlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPlaybookRequest is the request struct for api ModifyPlaybook
type ModifyPlaybookRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	Taskflow     string `position:"Body" name:"Taskflow"`
	Description  string `position:"Body" name:"Description"`
	PlaybookUuid string `position:"Body" name:"PlaybookUuid"`
	DisplayName  string `position:"Body" name:"DisplayName"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Body" name:"Lang"`
}

// ModifyPlaybookResponse is the response struct for api ModifyPlaybook
type ModifyPlaybookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPlaybookRequest creates a request to invoke ModifyPlaybook API
func CreateModifyPlaybookRequest() (request *ModifyPlaybookRequest) {
	request = &ModifyPlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "ModifyPlaybook", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyPlaybookResponse creates a response to parse from ModifyPlaybook response
func CreateModifyPlaybookResponse() (response *ModifyPlaybookResponse) {
	response = &ModifyPlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
