package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFirewallTemplateRules invokes the swas_open.DeleteFirewallTemplateRules API synchronously
func (client *Client) DeleteFirewallTemplateRules(request *DeleteFirewallTemplateRulesRequest) (response *DeleteFirewallTemplateRulesResponse, err error) {
	response = CreateDeleteFirewallTemplateRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFirewallTemplateRulesWithChan invokes the swas_open.DeleteFirewallTemplateRules API asynchronously
func (client *Client) DeleteFirewallTemplateRulesWithChan(request *DeleteFirewallTemplateRulesRequest) (<-chan *DeleteFirewallTemplateRulesResponse, <-chan error) {
	responseChan := make(chan *DeleteFirewallTemplateRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFirewallTemplateRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFirewallTemplateRulesWithCallback invokes the swas_open.DeleteFirewallTemplateRules API asynchronously
func (client *Client) DeleteFirewallTemplateRulesWithCallback(request *DeleteFirewallTemplateRulesRequest, callback func(response *DeleteFirewallTemplateRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFirewallTemplateRulesResponse
		var err error
		defer close(result)
		response, err = client.DeleteFirewallTemplateRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFirewallTemplateRulesRequest is the request struct for api DeleteFirewallTemplateRules
type DeleteFirewallTemplateRulesRequest struct {
	*requests.RpcRequest
	FirewallTemplateId     string    `position:"Query" name:"FirewallTemplateId"`
	ClientToken            string    `position:"Query" name:"ClientToken"`
	InstanceId             string    `position:"Query" name:"InstanceId"`
	FirewallTemplateRuleId *[]string `position:"Query" name:"FirewallTemplateRuleId"  type:"Repeated"`
}

// DeleteFirewallTemplateRulesResponse is the response struct for api DeleteFirewallTemplateRules
type DeleteFirewallTemplateRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFirewallTemplateRulesRequest creates a request to invoke DeleteFirewallTemplateRules API
func CreateDeleteFirewallTemplateRulesRequest() (request *DeleteFirewallTemplateRulesRequest) {
	request = &DeleteFirewallTemplateRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DeleteFirewallTemplateRules", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFirewallTemplateRulesResponse creates a response to parse from DeleteFirewallTemplateRules response
func CreateDeleteFirewallTemplateRulesResponse() (response *DeleteFirewallTemplateRulesResponse) {
	response = &DeleteFirewallTemplateRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
