package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSnapshots invokes the swas_open.DeleteSnapshots API synchronously
func (client *Client) DeleteSnapshots(request *DeleteSnapshotsRequest) (response *DeleteSnapshotsResponse, err error) {
	response = CreateDeleteSnapshotsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSnapshotsWithChan invokes the swas_open.DeleteSnapshots API asynchronously
func (client *Client) DeleteSnapshotsWithChan(request *DeleteSnapshotsRequest) (<-chan *DeleteSnapshotsResponse, <-chan error) {
	responseChan := make(chan *DeleteSnapshotsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSnapshots(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSnapshotsWithCallback invokes the swas_open.DeleteSnapshots API asynchronously
func (client *Client) DeleteSnapshotsWithCallback(request *DeleteSnapshotsRequest, callback func(response *DeleteSnapshotsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSnapshotsResponse
		var err error
		defer close(result)
		response, err = client.DeleteSnapshots(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSnapshotsRequest is the request struct for api DeleteSnapshots
type DeleteSnapshotsRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	SnapshotIds string `position:"Query" name:"SnapshotIds"`
}

// DeleteSnapshotsResponse is the response struct for api DeleteSnapshots
type DeleteSnapshotsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSnapshotsRequest creates a request to invoke DeleteSnapshots API
func CreateDeleteSnapshotsRequest() (request *DeleteSnapshotsRequest) {
	request = &DeleteSnapshotsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DeleteSnapshots", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSnapshotsResponse creates a response to parse from DeleteSnapshots response
func CreateDeleteSnapshotsResponse() (response *DeleteSnapshotsResponse) {
	response = &DeleteSnapshotsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
