package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstancesTrafficPackages invokes the swas_open.ListInstancesTrafficPackages API synchronously
func (client *Client) ListInstancesTrafficPackages(request *ListInstancesTrafficPackagesRequest) (response *ListInstancesTrafficPackagesResponse, err error) {
	response = CreateListInstancesTrafficPackagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstancesTrafficPackagesWithChan invokes the swas_open.ListInstancesTrafficPackages API asynchronously
func (client *Client) ListInstancesTrafficPackagesWithChan(request *ListInstancesTrafficPackagesRequest) (<-chan *ListInstancesTrafficPackagesResponse, <-chan error) {
	responseChan := make(chan *ListInstancesTrafficPackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstancesTrafficPackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstancesTrafficPackagesWithCallback invokes the swas_open.ListInstancesTrafficPackages API asynchronously
func (client *Client) ListInstancesTrafficPackagesWithCallback(request *ListInstancesTrafficPackagesRequest, callback func(response *ListInstancesTrafficPackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstancesTrafficPackagesResponse
		var err error
		defer close(result)
		response, err = client.ListInstancesTrafficPackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstancesTrafficPackagesRequest is the request struct for api ListInstancesTrafficPackages
type ListInstancesTrafficPackagesRequest struct {
	*requests.RpcRequest
	InstanceIds string `position:"Query" name:"InstanceIds"`
}

// ListInstancesTrafficPackagesResponse is the response struct for api ListInstancesTrafficPackages
type ListInstancesTrafficPackagesResponse struct {
	*responses.BaseResponse
	RequestId                    string                        `json:"RequestId" xml:"RequestId"`
	InstanceTrafficPackageUsages []InstanceTrafficPackageUsage `json:"InstanceTrafficPackageUsages" xml:"InstanceTrafficPackageUsages"`
}

// CreateListInstancesTrafficPackagesRequest creates a request to invoke ListInstancesTrafficPackages API
func CreateListInstancesTrafficPackagesRequest() (request *ListInstancesTrafficPackagesRequest) {
	request = &ListInstancesTrafficPackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ListInstancesTrafficPackages", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInstancesTrafficPackagesResponse creates a response to parse from ListInstancesTrafficPackages response
func CreateListInstancesTrafficPackagesResponse() (response *ListInstancesTrafficPackagesResponse) {
	response = &ListInstancesTrafficPackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
