package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateInstanceAttribute invokes the swas_open.UpdateInstanceAttribute API synchronously
func (client *Client) UpdateInstanceAttribute(request *UpdateInstanceAttributeRequest) (response *UpdateInstanceAttributeResponse, err error) {
	response = CreateUpdateInstanceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateInstanceAttributeWithChan invokes the swas_open.UpdateInstanceAttribute API asynchronously
func (client *Client) UpdateInstanceAttributeWithChan(request *UpdateInstanceAttributeRequest) (<-chan *UpdateInstanceAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateInstanceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateInstanceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateInstanceAttributeWithCallback invokes the swas_open.UpdateInstanceAttribute API asynchronously
func (client *Client) UpdateInstanceAttributeWithCallback(request *UpdateInstanceAttributeRequest, callback func(response *UpdateInstanceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateInstanceAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateInstanceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateInstanceAttributeRequest is the request struct for api UpdateInstanceAttribute
type UpdateInstanceAttributeRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	Password     string `position:"Query" name:"Password"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	InstanceName string `position:"Query" name:"InstanceName"`
}

// UpdateInstanceAttributeResponse is the response struct for api UpdateInstanceAttribute
type UpdateInstanceAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateInstanceAttributeRequest creates a request to invoke UpdateInstanceAttribute API
func CreateUpdateInstanceAttributeRequest() (request *UpdateInstanceAttributeRequest) {
	request = &UpdateInstanceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "UpdateInstanceAttribute", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateInstanceAttributeResponse creates a response to parse from UpdateInstanceAttribute response
func CreateUpdateInstanceAttributeResponse() (response *UpdateInstanceAttributeResponse) {
	response = &UpdateInstanceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
