package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIncomeData invokes the unimkt.QueryIncomeData API synchronously
func (client *Client) QueryIncomeData(request *QueryIncomeDataRequest) (response *QueryIncomeDataResponse, err error) {
	response = CreateQueryIncomeDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIncomeDataWithChan invokes the unimkt.QueryIncomeData API asynchronously
func (client *Client) QueryIncomeDataWithChan(request *QueryIncomeDataRequest) (<-chan *QueryIncomeDataResponse, <-chan error) {
	responseChan := make(chan *QueryIncomeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIncomeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIncomeDataWithCallback invokes the unimkt.QueryIncomeData API asynchronously
func (client *Client) QueryIncomeDataWithCallback(request *QueryIncomeDataRequest, callback func(response *QueryIncomeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIncomeDataResponse
		var err error
		defer close(result)
		response, err = client.QueryIncomeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIncomeDataRequest is the request struct for api QueryIncomeData
type QueryIncomeDataRequest struct {
	*requests.RpcRequest
	AdSlotType       string           `position:"Query" name:"AdSlotType"`
	Business         string           `position:"Query" name:"Business"`
	EndTime          requests.Integer `position:"Query" name:"EndTime"`
	StartTime        requests.Integer `position:"Query" name:"StartTime"`
	MediaId          string           `position:"Query" name:"MediaId"`
	UserId           string           `position:"Query" name:"UserId"`
	OriginSiteUserId string           `position:"Query" name:"OriginSiteUserId"`
	MediaName        string           `position:"Query" name:"MediaName"`
	Environment      string           `position:"Query" name:"Environment"`
	AppName          string           `position:"Query" name:"AppName"`
	TenantId         string           `position:"Query" name:"TenantId"`
	AdSlotId         string           `position:"Query" name:"AdSlotId"`
	UserSite         string           `position:"Query" name:"UserSite"`
	AdSlotName       string           `position:"Query" name:"AdSlotName"`
	Dimension        string           `position:"Query" name:"Dimension"`
	QueryType        string           `position:"Query" name:"QueryType"`
}

// QueryIncomeDataResponse is the response struct for api QueryIncomeData
type QueryIncomeDataResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"Code" xml:"Code"`
	Success   bool                   `json:"Success" xml:"Success"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Model     ModelInQueryIncomeData `json:"Model" xml:"Model"`
}

// CreateQueryIncomeDataRequest creates a request to invoke QueryIncomeData API
func CreateQueryIncomeDataRequest() (request *QueryIncomeDataRequest) {
	request = &QueryIncomeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryIncomeData", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryIncomeDataResponse creates a response to parse from QueryIncomeData response
func CreateQueryIncomeDataResponse() (response *QueryIncomeDataResponse) {
	response = &QueryIncomeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
