package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSecretValue invokes the ververica.DeleteSecretValue API synchronously
func (client *Client) DeleteSecretValue(request *DeleteSecretValueRequest) (response *DeleteSecretValueResponse, err error) {
	response = CreateDeleteSecretValueResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSecretValueWithChan invokes the ververica.DeleteSecretValue API asynchronously
func (client *Client) DeleteSecretValueWithChan(request *DeleteSecretValueRequest) (<-chan *DeleteSecretValueResponse, <-chan error) {
	responseChan := make(chan *DeleteSecretValueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSecretValue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSecretValueWithCallback invokes the ververica.DeleteSecretValue API asynchronously
func (client *Client) DeleteSecretValueWithCallback(request *DeleteSecretValueRequest, callback func(response *DeleteSecretValueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSecretValueResponse
		var err error
		defer close(result)
		response, err = client.DeleteSecretValue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSecretValueRequest is the request struct for api DeleteSecretValue
type DeleteSecretValueRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Namespace string `position:"Path" name:"namespace"`
	Name      string `position:"Path" name:"name"`
}

// DeleteSecretValueResponse is the response struct for api DeleteSecretValue
type DeleteSecretValueResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateDeleteSecretValueRequest creates a request to invoke DeleteSecretValue API
func CreateDeleteSecretValueRequest() (request *DeleteSecretValueRequest) {
	request = &DeleteSecretValueRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "DeleteSecretValue", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/secret-values/[name]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteSecretValueResponse creates a response to parse from DeleteSecretValue response
func CreateDeleteSecretValueResponse() (response *DeleteSecretValueResponse) {
	response = &DeleteSecretValueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
