package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDiffCountLabelsetAndDataset invokes the viapi_regen.GetDiffCountLabelsetAndDataset API synchronously
func (client *Client) GetDiffCountLabelsetAndDataset(request *GetDiffCountLabelsetAndDatasetRequest) (response *GetDiffCountLabelsetAndDatasetResponse, err error) {
	response = CreateGetDiffCountLabelsetAndDatasetResponse()
	err = client.DoAction(request, response)
	return
}

// GetDiffCountLabelsetAndDatasetWithChan invokes the viapi_regen.GetDiffCountLabelsetAndDataset API asynchronously
func (client *Client) GetDiffCountLabelsetAndDatasetWithChan(request *GetDiffCountLabelsetAndDatasetRequest) (<-chan *GetDiffCountLabelsetAndDatasetResponse, <-chan error) {
	responseChan := make(chan *GetDiffCountLabelsetAndDatasetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDiffCountLabelsetAndDataset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDiffCountLabelsetAndDatasetWithCallback invokes the viapi_regen.GetDiffCountLabelsetAndDataset API asynchronously
func (client *Client) GetDiffCountLabelsetAndDatasetWithCallback(request *GetDiffCountLabelsetAndDatasetRequest, callback func(response *GetDiffCountLabelsetAndDatasetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDiffCountLabelsetAndDatasetResponse
		var err error
		defer close(result)
		response, err = client.GetDiffCountLabelsetAndDataset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDiffCountLabelsetAndDatasetRequest is the request struct for api GetDiffCountLabelsetAndDataset
type GetDiffCountLabelsetAndDatasetRequest struct {
	*requests.RpcRequest
	LabelsetId requests.Integer `position:"Body" name:"LabelsetId"`
}

// GetDiffCountLabelsetAndDatasetResponse is the response struct for api GetDiffCountLabelsetAndDataset
type GetDiffCountLabelsetAndDatasetResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDiffCountLabelsetAndDatasetRequest creates a request to invoke GetDiffCountLabelsetAndDataset API
func CreateGetDiffCountLabelsetAndDatasetRequest() (request *GetDiffCountLabelsetAndDatasetRequest) {
	request = &GetDiffCountLabelsetAndDatasetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "GetDiffCountLabelsetAndDataset", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDiffCountLabelsetAndDatasetResponse creates a response to parse from GetDiffCountLabelsetAndDataset response
func CreateGetDiffCountLabelsetAndDatasetResponse() (response *GetDiffCountLabelsetAndDatasetResponse) {
	response = &GetDiffCountLabelsetAndDatasetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
