package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodRangeDataByLocateAndIspService invokes the vod.DescribeVodRangeDataByLocateAndIspService API synchronously
func (client *Client) DescribeVodRangeDataByLocateAndIspService(request *DescribeVodRangeDataByLocateAndIspServiceRequest) (response *DescribeVodRangeDataByLocateAndIspServiceResponse, err error) {
	response = CreateDescribeVodRangeDataByLocateAndIspServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodRangeDataByLocateAndIspServiceWithChan invokes the vod.DescribeVodRangeDataByLocateAndIspService API asynchronously
func (client *Client) DescribeVodRangeDataByLocateAndIspServiceWithChan(request *DescribeVodRangeDataByLocateAndIspServiceRequest) (<-chan *DescribeVodRangeDataByLocateAndIspServiceResponse, <-chan error) {
	responseChan := make(chan *DescribeVodRangeDataByLocateAndIspServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodRangeDataByLocateAndIspService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodRangeDataByLocateAndIspServiceWithCallback invokes the vod.DescribeVodRangeDataByLocateAndIspService API asynchronously
func (client *Client) DescribeVodRangeDataByLocateAndIspServiceWithCallback(request *DescribeVodRangeDataByLocateAndIspServiceRequest, callback func(response *DescribeVodRangeDataByLocateAndIspServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodRangeDataByLocateAndIspServiceResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodRangeDataByLocateAndIspService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodRangeDataByLocateAndIspServiceRequest is the request struct for api DescribeVodRangeDataByLocateAndIspService
type DescribeVodRangeDataByLocateAndIspServiceRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVodRangeDataByLocateAndIspServiceResponse is the response struct for api DescribeVodRangeDataByLocateAndIspService
type DescribeVodRangeDataByLocateAndIspServiceResponse struct {
	*responses.BaseResponse
	JsonResult string `json:"JsonResult" xml:"JsonResult"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeVodRangeDataByLocateAndIspServiceRequest creates a request to invoke DescribeVodRangeDataByLocateAndIspService API
func CreateDescribeVodRangeDataByLocateAndIspServiceRequest() (request *DescribeVodRangeDataByLocateAndIspServiceRequest) {
	request = &DescribeVodRangeDataByLocateAndIspServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodRangeDataByLocateAndIspService", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodRangeDataByLocateAndIspServiceResponse creates a response to parse from DescribeVodRangeDataByLocateAndIspService response
func CreateDescribeVodRangeDataByLocateAndIspServiceResponse() (response *DescribeVodRangeDataByLocateAndIspServiceResponse) {
	response = &DescribeVodRangeDataByLocateAndIspServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
