package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterMedia invokes the vod.RegisterMedia API synchronously
func (client *Client) RegisterMedia(request *RegisterMediaRequest) (response *RegisterMediaResponse, err error) {
	response = CreateRegisterMediaResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterMediaWithChan invokes the vod.RegisterMedia API asynchronously
func (client *Client) RegisterMediaWithChan(request *RegisterMediaRequest) (<-chan *RegisterMediaResponse, <-chan error) {
	responseChan := make(chan *RegisterMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterMediaWithCallback invokes the vod.RegisterMedia API asynchronously
func (client *Client) RegisterMediaWithCallback(request *RegisterMediaRequest, callback func(response *RegisterMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterMediaResponse
		var err error
		defer close(result)
		response, err = client.RegisterMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterMediaRequest is the request struct for api RegisterMedia
type RegisterMediaRequest struct {
	*requests.RpcRequest
	UserData          string `position:"Query" name:"UserData"`
	TemplateGroupId   string `position:"Query" name:"TemplateGroupId"`
	RegisterMetadatas string `position:"Query" name:"RegisterMetadatas"`
	WorkflowId        string `position:"Query" name:"WorkflowId"`
}

// RegisterMediaResponse is the response struct for api RegisterMedia
type RegisterMediaResponse struct {
	*responses.BaseResponse
	RequestId           string            `json:"RequestId" xml:"RequestId"`
	FailedFileURLs      []string          `json:"FailedFileURLs" xml:"FailedFileURLs"`
	RegisteredMediaList []RegisteredMedia `json:"RegisteredMediaList" xml:"RegisteredMediaList"`
}

// CreateRegisterMediaRequest creates a request to invoke RegisterMedia API
func CreateRegisterMediaRequest() (request *RegisterMediaRequest) {
	request = &RegisterMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "RegisterMedia", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRegisterMediaResponse creates a response to parse from RegisterMedia response
func CreateRegisterMediaResponse() (response *RegisterMediaResponse) {
	response = &RegisterMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
