package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRealTimeConcurrency invokes the voicenavigator.GetRealTimeConcurrency API synchronously
func (client *Client) GetRealTimeConcurrency(request *GetRealTimeConcurrencyRequest) (response *GetRealTimeConcurrencyResponse, err error) {
	response = CreateGetRealTimeConcurrencyResponse()
	err = client.DoAction(request, response)
	return
}

// GetRealTimeConcurrencyWithChan invokes the voicenavigator.GetRealTimeConcurrency API asynchronously
func (client *Client) GetRealTimeConcurrencyWithChan(request *GetRealTimeConcurrencyRequest) (<-chan *GetRealTimeConcurrencyResponse, <-chan error) {
	responseChan := make(chan *GetRealTimeConcurrencyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRealTimeConcurrency(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRealTimeConcurrencyWithCallback invokes the voicenavigator.GetRealTimeConcurrency API asynchronously
func (client *Client) GetRealTimeConcurrencyWithCallback(request *GetRealTimeConcurrencyRequest, callback func(response *GetRealTimeConcurrencyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRealTimeConcurrencyResponse
		var err error
		defer close(result)
		response, err = client.GetRealTimeConcurrency(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRealTimeConcurrencyRequest is the request struct for api GetRealTimeConcurrency
type GetRealTimeConcurrencyRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetRealTimeConcurrencyResponse is the response struct for api GetRealTimeConcurrency
type GetRealTimeConcurrencyResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	Timestamp           int64  `json:"Timestamp" xml:"Timestamp"`
	RealTimeConcurrency int64  `json:"RealTimeConcurrency" xml:"RealTimeConcurrency"`
	MaxConcurrency      int64  `json:"MaxConcurrency" xml:"MaxConcurrency"`
}

// CreateGetRealTimeConcurrencyRequest creates a request to invoke GetRealTimeConcurrency API
func CreateGetRealTimeConcurrencyRequest() (request *GetRealTimeConcurrencyRequest) {
	request = &GetRealTimeConcurrencyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "GetRealTimeConcurrency", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRealTimeConcurrencyResponse creates a response to parse from GetRealTimeConcurrency response
func CreateGetRealTimeConcurrencyResponse() (response *GetRealTimeConcurrencyResponse) {
	response = &GetRealTimeConcurrencyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
