package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRouteEntries invokes the vpc.CreateRouteEntries API synchronously
func (client *Client) CreateRouteEntries(request *CreateRouteEntriesRequest) (response *CreateRouteEntriesResponse, err error) {
	response = CreateCreateRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRouteEntriesWithChan invokes the vpc.CreateRouteEntries API asynchronously
func (client *Client) CreateRouteEntriesWithChan(request *CreateRouteEntriesRequest) (<-chan *CreateRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *CreateRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRouteEntriesWithCallback invokes the vpc.CreateRouteEntries API asynchronously
func (client *Client) CreateRouteEntriesWithCallback(request *CreateRouteEntriesRequest, callback func(response *CreateRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.CreateRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRouteEntriesRequest is the request struct for api CreateRouteEntries
type CreateRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                  `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string                            `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                            `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                  `position:"Query" name:"OwnerId"`
	RouteEntries         *[]CreateRouteEntriesRouteEntries `position:"Query" name:"RouteEntries"  type:"Repeated"`
}

// CreateRouteEntriesRouteEntries is a repeated param struct in CreateRouteEntriesRequest
type CreateRouteEntriesRouteEntries struct {
	DstCidrBlock string `name:"DstCidrBlock"`
	RouteTableId string `name:"RouteTableId"`
	IpVersion    string `name:"IpVersion"`
	NextHop      string `name:"NextHop"`
	NextHopType  string `name:"NextHopType"`
	Name         string `name:"Name"`
	Describption string `name:"Describption"`
	Description  string `name:"Description"`
}

// CreateRouteEntriesResponse is the response struct for api CreateRouteEntries
type CreateRouteEntriesResponse struct {
	*responses.BaseResponse
	SuccessCount       int                      `json:"SuccessCount" xml:"SuccessCount"`
	FailedCount        int                      `json:"FailedCount" xml:"FailedCount"`
	RequestId          string                   `json:"RequestId" xml:"RequestId"`
	RouteEntryIds      []string                 `json:"RouteEntryIds" xml:"RouteEntryIds"`
	FailedRouteEntries []FailedRouteEntriesItem `json:"FailedRouteEntries" xml:"FailedRouteEntries"`
}

// CreateCreateRouteEntriesRequest creates a request to invoke CreateRouteEntries API
func CreateCreateRouteEntriesRequest() (request *CreateRouteEntriesRequest) {
	request = &CreateRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateRouteEntries", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRouteEntriesResponse creates a response to parse from CreateRouteEntries response
func CreateCreateRouteEntriesResponse() (response *CreateRouteEntriesResponse) {
	response = &CreateRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
