package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFailoverTestJob invokes the vpc.DeleteFailoverTestJob API synchronously
func (client *Client) DeleteFailoverTestJob(request *DeleteFailoverTestJobRequest) (response *DeleteFailoverTestJobResponse, err error) {
	response = CreateDeleteFailoverTestJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFailoverTestJobWithChan invokes the vpc.DeleteFailoverTestJob API asynchronously
func (client *Client) DeleteFailoverTestJobWithChan(request *DeleteFailoverTestJobRequest) (<-chan *DeleteFailoverTestJobResponse, <-chan error) {
	responseChan := make(chan *DeleteFailoverTestJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFailoverTestJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFailoverTestJobWithCallback invokes the vpc.DeleteFailoverTestJob API asynchronously
func (client *Client) DeleteFailoverTestJobWithCallback(request *DeleteFailoverTestJobRequest, callback func(response *DeleteFailoverTestJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFailoverTestJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteFailoverTestJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFailoverTestJobRequest is the request struct for api DeleteFailoverTestJob
type DeleteFailoverTestJobRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	JobId                string           `position:"Query" name:"JobId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteFailoverTestJobResponse is the response struct for api DeleteFailoverTestJob
type DeleteFailoverTestJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFailoverTestJobRequest creates a request to invoke DeleteFailoverTestJob API
func CreateDeleteFailoverTestJobRequest() (request *DeleteFailoverTestJobRequest) {
	request = &DeleteFailoverTestJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteFailoverTestJob", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFailoverTestJobResponse creates a response to parse from DeleteFailoverTestJob response
func CreateDeleteFailoverTestJobResponse() (response *DeleteFailoverTestJobResponse) {
	response = &DeleteFailoverTestJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
