package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpnAttachment invokes the vpc.DeleteVpnAttachment API synchronously
func (client *Client) DeleteVpnAttachment(request *DeleteVpnAttachmentRequest) (response *DeleteVpnAttachmentResponse, err error) {
	response = CreateDeleteVpnAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpnAttachmentWithChan invokes the vpc.DeleteVpnAttachment API asynchronously
func (client *Client) DeleteVpnAttachmentWithChan(request *DeleteVpnAttachmentRequest) (<-chan *DeleteVpnAttachmentResponse, <-chan error) {
	responseChan := make(chan *DeleteVpnAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpnAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpnAttachmentWithCallback invokes the vpc.DeleteVpnAttachment API asynchronously
func (client *Client) DeleteVpnAttachmentWithCallback(request *DeleteVpnAttachmentRequest, callback func(response *DeleteVpnAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpnAttachmentResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpnAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpnAttachmentRequest is the request struct for api DeleteVpnAttachment
type DeleteVpnAttachmentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	VpnConnectionId      string           `position:"Query" name:"VpnConnectionId"`
}

// DeleteVpnAttachmentResponse is the response struct for api DeleteVpnAttachment
type DeleteVpnAttachmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteVpnAttachmentRequest creates a request to invoke DeleteVpnAttachment API
func CreateDeleteVpnAttachmentRequest() (request *DeleteVpnAttachmentRequest) {
	request = &DeleteVpnAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteVpnAttachment", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpnAttachmentResponse creates a response to parse from DeleteVpnAttachment response
func CreateDeleteVpnAttachmentResponse() (response *DeleteVpnAttachmentResponse) {
	response = &DeleteVpnAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
