package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Describe95Traffic invokes the vpc.Describe95Traffic API synchronously
func (client *Client) Describe95Traffic(request *Describe95TrafficRequest) (response *Describe95TrafficResponse, err error) {
	response = CreateDescribe95TrafficResponse()
	err = client.DoAction(request, response)
	return
}

// Describe95TrafficWithChan invokes the vpc.Describe95Traffic API asynchronously
func (client *Client) Describe95TrafficWithChan(request *Describe95TrafficRequest) (<-chan *Describe95TrafficResponse, <-chan error) {
	responseChan := make(chan *Describe95TrafficResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Describe95Traffic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Describe95TrafficWithCallback invokes the vpc.Describe95Traffic API asynchronously
func (client *Client) Describe95TrafficWithCallback(request *Describe95TrafficRequest, callback func(response *Describe95TrafficResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Describe95TrafficResponse
		var err error
		defer close(result)
		response, err = client.Describe95Traffic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Describe95TrafficRequest is the request struct for api Describe95Traffic
type Describe95TrafficRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Day                  string           `position:"Query" name:"Day"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// Describe95TrafficResponse is the response struct for api Describe95Traffic
type Describe95TrafficResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Traffic95Summary Traffic95Summary `json:"Traffic95Summary" xml:"Traffic95Summary"`
}

// CreateDescribe95TrafficRequest creates a request to invoke Describe95Traffic API
func CreateDescribe95TrafficRequest() (request *Describe95TrafficRequest) {
	request = &Describe95TrafficRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "Describe95Traffic", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribe95TrafficResponse creates a response to parse from Describe95Traffic response
func CreateDescribe95TrafficResponse() (response *Describe95TrafficResponse) {
	response = &Describe95TrafficResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
