package vpcpeer

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVpcPeerConnection invokes the vpcpeer.CreateVpcPeerConnection API synchronously
func (client *Client) CreateVpcPeerConnection(request *CreateVpcPeerConnectionRequest) (response *CreateVpcPeerConnectionResponse, err error) {
	response = CreateCreateVpcPeerConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVpcPeerConnectionWithChan invokes the vpcpeer.CreateVpcPeerConnection API asynchronously
func (client *Client) CreateVpcPeerConnectionWithChan(request *CreateVpcPeerConnectionRequest) (<-chan *CreateVpcPeerConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateVpcPeerConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVpcPeerConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVpcPeerConnectionWithCallback invokes the vpcpeer.CreateVpcPeerConnection API asynchronously
func (client *Client) CreateVpcPeerConnectionWithCallback(request *CreateVpcPeerConnectionRequest, callback func(response *CreateVpcPeerConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVpcPeerConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateVpcPeerConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVpcPeerConnectionRequest is the request struct for api CreateVpcPeerConnection
type CreateVpcPeerConnectionRequest struct {
	*requests.RpcRequest
	ClientToken       string           `position:"Body" name:"ClientToken"`
	Channel           string           `position:"Body" name:"Channel"`
	Description       string           `position:"Body" name:"Description"`
	AcceptingAliUid   requests.Integer `position:"Body" name:"AcceptingAliUid"`
	ResourceGroupId   string           `position:"Body" name:"ResourceGroupId"`
	AcceptingRegionId string           `position:"Body" name:"AcceptingRegionId"`
	DryRun            requests.Boolean `position:"Body" name:"DryRun"`
	AcceptingVpcId    string           `position:"Body" name:"AcceptingVpcId"`
	VpcId             string           `position:"Body" name:"VpcId"`
	Name              string           `position:"Body" name:"Name"`
}

// CreateVpcPeerConnectionResponse is the response struct for api CreateVpcPeerConnection
type CreateVpcPeerConnectionResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
}

// CreateCreateVpcPeerConnectionRequest creates a request to invoke CreateVpcPeerConnection API
func CreateCreateVpcPeerConnectionRequest() (request *CreateVpcPeerConnectionRequest) {
	request = &CreateVpcPeerConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VpcPeer", "2022-01-01", "CreateVpcPeerConnection", "vpcpeer", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVpcPeerConnectionResponse creates a response to parse from CreateVpcPeerConnection response
func CreateCreateVpcPeerConnectionResponse() (response *CreateVpcPeerConnectionResponse) {
	response = &CreateVpcPeerConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
