package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeParentPlatforms invokes the vs.DescribeParentPlatforms API synchronously
func (client *Client) DescribeParentPlatforms(request *DescribeParentPlatformsRequest) (response *DescribeParentPlatformsResponse, err error) {
	response = CreateDescribeParentPlatformsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeParentPlatformsWithChan invokes the vs.DescribeParentPlatforms API asynchronously
func (client *Client) DescribeParentPlatformsWithChan(request *DescribeParentPlatformsRequest) (<-chan *DescribeParentPlatformsResponse, <-chan error) {
	responseChan := make(chan *DescribeParentPlatformsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeParentPlatforms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeParentPlatformsWithCallback invokes the vs.DescribeParentPlatforms API asynchronously
func (client *Client) DescribeParentPlatformsWithCallback(request *DescribeParentPlatformsRequest, callback func(response *DescribeParentPlatformsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeParentPlatformsResponse
		var err error
		defer close(result)
		response, err = client.DescribeParentPlatforms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeParentPlatformsRequest is the request struct for api DescribeParentPlatforms
type DescribeParentPlatformsRequest struct {
	*requests.RpcRequest
	SortDirection string           `position:"Query" name:"SortDirection"`
	GbId          string           `position:"Query" name:"GbId"`
	PageNum       requests.Integer `position:"Query" name:"PageNum"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SortBy        string           `position:"Query" name:"SortBy"`
	Status        string           `position:"Query" name:"Status"`
}

// DescribeParentPlatformsResponse is the response struct for api DescribeParentPlatforms
type DescribeParentPlatformsResponse struct {
	*responses.BaseResponse
	PageNum    int64      `json:"PageNum" xml:"PageNum"`
	PageSize   int64      `json:"PageSize" xml:"PageSize"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TotalCount int64      `json:"TotalCount" xml:"TotalCount"`
	PageCount  int64      `json:"PageCount" xml:"PageCount"`
	Platforms  []Platform `json:"Platforms" xml:"Platforms"`
}

// CreateDescribeParentPlatformsRequest creates a request to invoke DescribeParentPlatforms API
func CreateDescribeParentPlatformsRequest() (request *DescribeParentPlatformsRequest) {
	request = &DescribeParentPlatformsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeParentPlatforms", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeParentPlatformsResponse creates a response to parse from DescribeParentPlatforms response
func CreateDescribeParentPlatformsResponse() (response *DescribeParentPlatformsResponse) {
	response = &DescribeParentPlatformsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
