// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a scheduled query that runs CloudWatch Logs Insights queries at regular
// intervals. Scheduled queries enable proactive monitoring by automatically
// executing queries to detect patterns and anomalies in your log data. Query
// results can be delivered to Amazon S3 for analysis or further processing.
func (c *Client) CreateScheduledQuery(ctx context.Context, params *CreateScheduledQueryInput, optFns ...func(*Options)) (*CreateScheduledQueryOutput, error) {
	if params == nil {
		params = &CreateScheduledQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateScheduledQuery", params, optFns, c.addOperationCreateScheduledQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateScheduledQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateScheduledQueryInput struct {

	// The ARN of the IAM role that grants permissions to execute the query and
	// deliver results to the specified destination. The role must have permissions to
	// read from the specified log groups and write to the destination.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The name of the scheduled query. The name must be unique within your account
	// and region. Valid characters are alphanumeric characters, hyphens, underscores,
	// and periods. Length must be between 1 and 255 characters.
	//
	// This member is required.
	Name *string

	// The query language to use for the scheduled query. Valid values are LogsQL , PPL
	// , and SQL .
	//
	// This member is required.
	QueryLanguage types.QueryLanguage

	// The query string to execute. This is the same query syntax used in CloudWatch
	// Logs Insights. Maximum length is 10,000 characters.
	//
	// This member is required.
	QueryString *string

	// A cron expression that defines when the scheduled query runs. The expression
	// uses standard cron syntax and supports minute-level precision. Maximum length is
	// 256 characters.
	//
	// This member is required.
	ScheduleExpression *string

	// An optional description for the scheduled query to help identify its purpose
	// and functionality.
	Description *string

	// Configuration for where to deliver query results. Currently supports Amazon S3
	// destinations for storing query output.
	DestinationConfiguration *types.DestinationConfiguration

	// An array of log group names or ARNs to query. You can specify between 1 and 50
	// log groups. Log groups can be identified by name or full ARN.
	LogGroupIdentifiers []string

	// The end time for the scheduled query in Unix epoch format. The query will stop
	// executing after this time.
	ScheduleEndTime *int64

	// The start time for the scheduled query in Unix epoch format. The query will not
	// execute before this time.
	ScheduleStartTime *int64

	// The time offset in seconds that defines the lookback period for the query. This
	// determines how far back in time the query searches from the execution time.
	StartTimeOffset *int64

	// The initial state of the scheduled query. Valid values are ENABLED and DISABLED
	// . Default is ENABLED .
	State types.ScheduledQueryState

	// Key-value pairs to associate with the scheduled query for resource management
	// and cost allocation.
	Tags map[string]string

	// The timezone for evaluating the schedule expression. This determines when the
	// scheduled query executes relative to the specified timezone.
	Timezone *string

	noSmithyDocumentSerde
}

type CreateScheduledQueryOutput struct {

	// The ARN of the created scheduled query.
	ScheduledQueryArn *string

	// The current state of the scheduled query.
	State types.ScheduledQueryState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateScheduledQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateScheduledQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateScheduledQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateScheduledQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateScheduledQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateScheduledQuery",
	}
}
