// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes a tree-based hierarchy that represents the physical host placement of
// your pending or active Capacity Reservations within an Availability Zone or
// Local Zone. You can use this information to determine the relative proximity of
// your capacity within the Amazon Web Services network before it is launched and
// use this information to allocate capacity together to support your tightly
// coupled workloads.
//
// Capacity Reservation topology is supported for specific instance types only.
// For more information, see [Prerequisites for Amazon EC2 instance topology]in the Amazon EC2 User Guide.
//
// The Amazon EC2 API follows an eventual consistency model due to the distributed
// nature of the system supporting it. As a result, when you call the
// DescribeCapacityReservationTopology API command immediately after launching
// instances, the response might return a null value for capacityBlockId because
// the data might not have fully propagated across all subsystems. For more
// information, see [Eventual consistency in the Amazon EC2 API]in the Amazon EC2 Developer Guide.
//
// For more information, see [Amazon EC2 topology] in the Amazon EC2 User Guide.
//
// [Prerequisites for Amazon EC2 instance topology]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-topology-prerequisites.html
// [Amazon EC2 topology]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-topology.html
// [Eventual consistency in the Amazon EC2 API]: https://docs.aws.amazon.com/ec2/latest/devguide/eventual-consistency.html
func (c *Client) DescribeCapacityReservationTopology(ctx context.Context, params *DescribeCapacityReservationTopologyInput, optFns ...func(*Options)) (*DescribeCapacityReservationTopologyOutput, error) {
	if params == nil {
		params = &DescribeCapacityReservationTopologyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCapacityReservationTopology", params, optFns, c.addOperationDescribeCapacityReservationTopologyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCapacityReservationTopologyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCapacityReservationTopologyInput struct {

	// The Capacity Reservation IDs.
	//
	// Default: Describes all your Capacity Reservations.
	//
	// Constraints: Maximum 100 explicitly specified Capacity Reservation IDs.
	CapacityReservationIds []string

	// Checks whether you have the required permissions for the operation, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - availability-zone - The name of the Availability Zone (for example,
	//   us-west-2a ) or Local Zone (for example, us-west-2-lax-1b ) that the Capacity
	//   Reservation is in.
	//
	//   - instance-type - The instance type (for example, p4d.24xlarge ) or instance
	//   family (for example, p4d* ). You can use the * wildcard to match zero or more
	//   characters, or the ? wildcard to match zero or one character.
	Filters []types.Filter

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// You can't specify this parameter and the Capacity Reservation IDs parameter in
	// the same request.
	//
	// Default: 10
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token returned from a previous paginated request. Pagination continues from
	// the end of the items returned by the previous request.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeCapacityReservationTopologyOutput struct {

	// Information about the topology of each Capacity Reservation.
	CapacityReservations []types.CapacityReservationTopology

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCapacityReservationTopologyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeCapacityReservationTopology{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeCapacityReservationTopology{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCapacityReservationTopology"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCapacityReservationTopology(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeCapacityReservationTopology(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCapacityReservationTopology",
	}
}
