/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the DataStreamingResponseWithResults type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DataStreamingResponseWithResults{}

// DataStreamingResponseWithResults struct for DataStreamingResponseWithResults
type DataStreamingResponseWithResults struct {
	Results []DataStreamingResponseWithResultsResultsInner `json:"results,omitempty"`
	SchemaVersion *float32 `json:"schema_version,omitempty"`
}

// NewDataStreamingResponseWithResults instantiates a new DataStreamingResponseWithResults object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDataStreamingResponseWithResults() *DataStreamingResponseWithResults {
	this := DataStreamingResponseWithResults{}
	return &this
}

// NewDataStreamingResponseWithResultsWithDefaults instantiates a new DataStreamingResponseWithResults object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDataStreamingResponseWithResultsWithDefaults() *DataStreamingResponseWithResults {
	this := DataStreamingResponseWithResults{}
	return &this
}

// GetResults returns the Results field value if set, zero value otherwise.
func (o *DataStreamingResponseWithResults) GetResults() []DataStreamingResponseWithResultsResultsInner {
	if o == nil || IsNil(o.Results) {
		var ret []DataStreamingResponseWithResultsResultsInner
		return ret
	}
	return o.Results
}

// GetResultsOk returns a tuple with the Results field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingResponseWithResults) GetResultsOk() ([]DataStreamingResponseWithResultsResultsInner, bool) {
	if o == nil || IsNil(o.Results) {
		return nil, false
	}
	return o.Results, true
}

// HasResults returns a boolean if a field has been set.
func (o *DataStreamingResponseWithResults) HasResults() bool {
	if o != nil && !IsNil(o.Results) {
		return true
	}

	return false
}

// SetResults gets a reference to the given []DataStreamingResponseWithResultsResultsInner and assigns it to the Results field.
func (o *DataStreamingResponseWithResults) SetResults(v []DataStreamingResponseWithResultsResultsInner) {
	o.Results = v
}

// GetSchemaVersion returns the SchemaVersion field value if set, zero value otherwise.
func (o *DataStreamingResponseWithResults) GetSchemaVersion() float32 {
	if o == nil || IsNil(o.SchemaVersion) {
		var ret float32
		return ret
	}
	return *o.SchemaVersion
}

// GetSchemaVersionOk returns a tuple with the SchemaVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingResponseWithResults) GetSchemaVersionOk() (*float32, bool) {
	if o == nil || IsNil(o.SchemaVersion) {
		return nil, false
	}
	return o.SchemaVersion, true
}

// HasSchemaVersion returns a boolean if a field has been set.
func (o *DataStreamingResponseWithResults) HasSchemaVersion() bool {
	if o != nil && !IsNil(o.SchemaVersion) {
		return true
	}

	return false
}

// SetSchemaVersion gets a reference to the given float32 and assigns it to the SchemaVersion field.
func (o *DataStreamingResponseWithResults) SetSchemaVersion(v float32) {
	o.SchemaVersion = &v
}

func (o DataStreamingResponseWithResults) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DataStreamingResponseWithResults) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Results) {
		toSerialize["results"] = o.Results
	}
	if !IsNil(o.SchemaVersion) {
		toSerialize["schema_version"] = o.SchemaVersion
	}
	return toSerialize, nil
}

type NullableDataStreamingResponseWithResults struct {
	value *DataStreamingResponseWithResults
	isSet bool
}

func (v NullableDataStreamingResponseWithResults) Get() *DataStreamingResponseWithResults {
	return v.value
}

func (v *NullableDataStreamingResponseWithResults) Set(val *DataStreamingResponseWithResults) {
	v.value = val
	v.isSet = true
}

func (v NullableDataStreamingResponseWithResults) IsSet() bool {
	return v.isSet
}

func (v *NullableDataStreamingResponseWithResults) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDataStreamingResponseWithResults(val *DataStreamingResponseWithResults) *NullableDataStreamingResponseWithResults {
	return &NullableDataStreamingResponseWithResults{value: val, isSet: true}
}

func (v NullableDataStreamingResponseWithResults) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDataStreamingResponseWithResults) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


