//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

type GPS_INPUT_IGNORE_FLAGS uint64

const (
	// ignore altitude field
	GPS_INPUT_IGNORE_FLAG_ALT GPS_INPUT_IGNORE_FLAGS = 1
	// ignore hdop field
	GPS_INPUT_IGNORE_FLAG_HDOP GPS_INPUT_IGNORE_FLAGS = 2
	// ignore vdop field
	GPS_INPUT_IGNORE_FLAG_VDOP GPS_INPUT_IGNORE_FLAGS = 4
	// ignore horizontal velocity field (vn and ve)
	GPS_INPUT_IGNORE_FLAG_VEL_HORIZ GPS_INPUT_IGNORE_FLAGS = 8
	// ignore vertical velocity field (vd)
	GPS_INPUT_IGNORE_FLAG_VEL_VERT GPS_INPUT_IGNORE_FLAGS = 16
	// ignore speed accuracy field
	GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY GPS_INPUT_IGNORE_FLAGS = 32
	// ignore horizontal accuracy field
	GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY GPS_INPUT_IGNORE_FLAGS = 64
	// ignore vertical accuracy field
	GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY GPS_INPUT_IGNORE_FLAGS = 128
)

var values_GPS_INPUT_IGNORE_FLAGS = []GPS_INPUT_IGNORE_FLAGS{
	GPS_INPUT_IGNORE_FLAG_ALT,
	GPS_INPUT_IGNORE_FLAG_HDOP,
	GPS_INPUT_IGNORE_FLAG_VDOP,
	GPS_INPUT_IGNORE_FLAG_VEL_HORIZ,
	GPS_INPUT_IGNORE_FLAG_VEL_VERT,
	GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY,
	GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY,
	GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY,
}

var value_to_label_GPS_INPUT_IGNORE_FLAGS = map[GPS_INPUT_IGNORE_FLAGS]string{
	GPS_INPUT_IGNORE_FLAG_ALT:                 "GPS_INPUT_IGNORE_FLAG_ALT",
	GPS_INPUT_IGNORE_FLAG_HDOP:                "GPS_INPUT_IGNORE_FLAG_HDOP",
	GPS_INPUT_IGNORE_FLAG_VDOP:                "GPS_INPUT_IGNORE_FLAG_VDOP",
	GPS_INPUT_IGNORE_FLAG_VEL_HORIZ:           "GPS_INPUT_IGNORE_FLAG_VEL_HORIZ",
	GPS_INPUT_IGNORE_FLAG_VEL_VERT:            "GPS_INPUT_IGNORE_FLAG_VEL_VERT",
	GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY:      "GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY",
	GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY: "GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY",
	GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY:   "GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY",
}

var label_to_value_GPS_INPUT_IGNORE_FLAGS = map[string]GPS_INPUT_IGNORE_FLAGS{
	"GPS_INPUT_IGNORE_FLAG_ALT":                 GPS_INPUT_IGNORE_FLAG_ALT,
	"GPS_INPUT_IGNORE_FLAG_HDOP":                GPS_INPUT_IGNORE_FLAG_HDOP,
	"GPS_INPUT_IGNORE_FLAG_VDOP":                GPS_INPUT_IGNORE_FLAG_VDOP,
	"GPS_INPUT_IGNORE_FLAG_VEL_HORIZ":           GPS_INPUT_IGNORE_FLAG_VEL_HORIZ,
	"GPS_INPUT_IGNORE_FLAG_VEL_VERT":            GPS_INPUT_IGNORE_FLAG_VEL_VERT,
	"GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY":      GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY,
	"GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY": GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY,
	"GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY":   GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GPS_INPUT_IGNORE_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_GPS_INPUT_IGNORE_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_GPS_INPUT_IGNORE_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GPS_INPUT_IGNORE_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask GPS_INPUT_IGNORE_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_GPS_INPUT_IGNORE_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= GPS_INPUT_IGNORE_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e GPS_INPUT_IGNORE_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
