// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.graph.getRelationships

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/bluesky-social/indigo/lex/util"
)

// GraphGetRelationships_Output is the output of a app.bsky.graph.getRelationships call.
type GraphGetRelationships_Output struct {
	Actor         *string                                            `json:"actor,omitempty" cborgen:"actor,omitempty"`
	Relationships []*GraphGetRelationships_Output_Relationships_Elem `json:"relationships" cborgen:"relationships"`
}

type GraphGetRelationships_Output_Relationships_Elem struct {
	GraphDefs_Relationship  *GraphDefs_Relationship
	GraphDefs_NotFoundActor *GraphDefs_NotFoundActor
}

func (t *GraphGetRelationships_Output_Relationships_Elem) MarshalJSON() ([]byte, error) {
	if t.GraphDefs_Relationship != nil {
		t.GraphDefs_Relationship.LexiconTypeID = "app.bsky.graph.defs#relationship"
		return json.Marshal(t.GraphDefs_Relationship)
	}
	if t.GraphDefs_NotFoundActor != nil {
		t.GraphDefs_NotFoundActor.LexiconTypeID = "app.bsky.graph.defs#notFoundActor"
		return json.Marshal(t.GraphDefs_NotFoundActor)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *GraphGetRelationships_Output_Relationships_Elem) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.graph.defs#relationship":
		t.GraphDefs_Relationship = new(GraphDefs_Relationship)
		return json.Unmarshal(b, t.GraphDefs_Relationship)
	case "app.bsky.graph.defs#notFoundActor":
		t.GraphDefs_NotFoundActor = new(GraphDefs_NotFoundActor)
		return json.Unmarshal(b, t.GraphDefs_NotFoundActor)

	default:
		return nil
	}
}

// GraphGetRelationships calls the XRPC method "app.bsky.graph.getRelationships".
//
// actor: Primary account requesting relationships for.
// others: List of 'other' accounts to be related back to the primary.
func GraphGetRelationships(ctx context.Context, c util.LexClient, actor string, others []string) (*GraphGetRelationships_Output, error) {
	var out GraphGetRelationships_Output

	params := map[string]interface{}{}
	params["actor"] = actor
	if len(others) != 0 {
		params["others"] = others
	}
	if err := c.LexDo(ctx, util.Query, "", "app.bsky.graph.getRelationships", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
