// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package ozone

// schema: tools.ozone.moderation.queryStatuses

import (
	"context"

	"github.com/bluesky-social/indigo/lex/util"
)

// ModerationQueryStatuses_Output is the output of a tools.ozone.moderation.queryStatuses call.
type ModerationQueryStatuses_Output struct {
	Cursor          *string                             `json:"cursor,omitempty" cborgen:"cursor,omitempty"`
	SubjectStatuses []*ModerationDefs_SubjectStatusView `json:"subjectStatuses" cborgen:"subjectStatuses"`
}

// ModerationQueryStatuses calls the XRPC method "tools.ozone.moderation.queryStatuses".
//
// ageAssuranceState: If specified, only subjects with the given age assurance state will be returned.
// appealed: Get subjects in unresolved appealed status
// collections: If specified, subjects belonging to the given collections will be returned. When subjectType is set to 'account', this will be ignored.
// comment: Search subjects by keyword from comments
// hostingDeletedAfter: Search subjects where the associated record/account was deleted after a given timestamp
// hostingDeletedBefore: Search subjects where the associated record/account was deleted before a given timestamp
// hostingStatuses: Search subjects by the status of the associated record/account
// hostingUpdatedAfter: Search subjects where the associated record/account was updated after a given timestamp
// hostingUpdatedBefore: Search subjects where the associated record/account was updated before a given timestamp
// includeAllUserRecords: All subjects, or subjects from given 'collections' param, belonging to the account specified in the 'subject' param will be returned.
// includeMuted: By default, we don't include muted subjects in the results. Set this to true to include them.
// lastReviewedBy: Get all subject statuses that were reviewed by a specific moderator
// minAccountSuspendCount: If specified, only subjects that belong to an account that has at least this many suspensions will be returned.
// minPriorityScore: If specified, only subjects that have priority score value above the given value will be returned.
// minReportedRecordsCount: If specified, only subjects that belong to an account that has at least this many reported records will be returned.
// minTakendownRecordsCount: If specified, only subjects that belong to an account that has at least this many taken down records will be returned.
// onlyMuted: When set to true, only muted subjects and reporters will be returned.
// queueCount: Number of queues being used by moderators. Subjects will be split among all queues.
// queueIndex: Index of the queue to fetch subjects from. Works only when queueCount value is specified.
// queueSeed: A seeder to shuffle/balance the queue items.
// reportedAfter: Search subjects reported after a given timestamp
// reportedBefore: Search subjects reported before a given timestamp
// reviewState: Specify when fetching subjects in a certain state
// reviewedAfter: Search subjects reviewed after a given timestamp
// reviewedBefore: Search subjects reviewed before a given timestamp
// subject: The subject to get the status for.
// subjectType: If specified, subjects of the given type (account or record) will be returned. When this is set to 'account' the 'collections' parameter will be ignored. When includeAllUserRecords or subject is set, this will be ignored.
// takendown: Get subjects that were taken down
func ModerationQueryStatuses(ctx context.Context, c util.LexClient, ageAssuranceState string, appealed bool, collections []string, comment string, cursor string, excludeTags []string, hostingDeletedAfter string, hostingDeletedBefore string, hostingStatuses []string, hostingUpdatedAfter string, hostingUpdatedBefore string, ignoreSubjects []string, includeAllUserRecords bool, includeMuted bool, lastReviewedBy string, limit int64, minAccountSuspendCount int64, minPriorityScore int64, minReportedRecordsCount int64, minTakendownRecordsCount int64, onlyMuted bool, queueCount int64, queueIndex int64, queueSeed string, reportedAfter string, reportedBefore string, reviewState string, reviewedAfter string, reviewedBefore string, sortDirection string, sortField string, subject string, subjectType string, tags []string, takendown bool) (*ModerationQueryStatuses_Output, error) {
	var out ModerationQueryStatuses_Output

	params := map[string]interface{}{}
	if ageAssuranceState != "" {
		params["ageAssuranceState"] = ageAssuranceState
	}
	if appealed {
		params["appealed"] = appealed
	}
	if len(collections) != 0 {
		params["collections"] = collections
	}
	if comment != "" {
		params["comment"] = comment
	}
	if cursor != "" {
		params["cursor"] = cursor
	}
	if len(excludeTags) != 0 {
		params["excludeTags"] = excludeTags
	}
	if hostingDeletedAfter != "" {
		params["hostingDeletedAfter"] = hostingDeletedAfter
	}
	if hostingDeletedBefore != "" {
		params["hostingDeletedBefore"] = hostingDeletedBefore
	}
	if len(hostingStatuses) != 0 {
		params["hostingStatuses"] = hostingStatuses
	}
	if hostingUpdatedAfter != "" {
		params["hostingUpdatedAfter"] = hostingUpdatedAfter
	}
	if hostingUpdatedBefore != "" {
		params["hostingUpdatedBefore"] = hostingUpdatedBefore
	}
	if len(ignoreSubjects) != 0 {
		params["ignoreSubjects"] = ignoreSubjects
	}
	if includeAllUserRecords {
		params["includeAllUserRecords"] = includeAllUserRecords
	}
	if includeMuted {
		params["includeMuted"] = includeMuted
	}
	if lastReviewedBy != "" {
		params["lastReviewedBy"] = lastReviewedBy
	}
	if limit != 0 {
		params["limit"] = limit
	}
	if minAccountSuspendCount != 0 {
		params["minAccountSuspendCount"] = minAccountSuspendCount
	}
	if minPriorityScore != 0 {
		params["minPriorityScore"] = minPriorityScore
	}
	if minReportedRecordsCount != 0 {
		params["minReportedRecordsCount"] = minReportedRecordsCount
	}
	if minTakendownRecordsCount != 0 {
		params["minTakendownRecordsCount"] = minTakendownRecordsCount
	}
	if onlyMuted {
		params["onlyMuted"] = onlyMuted
	}
	if queueCount != 0 {
		params["queueCount"] = queueCount
	}
	if queueIndex != 0 {
		params["queueIndex"] = queueIndex
	}
	if queueSeed != "" {
		params["queueSeed"] = queueSeed
	}
	if reportedAfter != "" {
		params["reportedAfter"] = reportedAfter
	}
	if reportedBefore != "" {
		params["reportedBefore"] = reportedBefore
	}
	if reviewState != "" {
		params["reviewState"] = reviewState
	}
	if reviewedAfter != "" {
		params["reviewedAfter"] = reviewedAfter
	}
	if reviewedBefore != "" {
		params["reviewedBefore"] = reviewedBefore
	}
	if sortDirection != "" {
		params["sortDirection"] = sortDirection
	}
	if sortField != "" {
		params["sortField"] = sortField
	}
	if subject != "" {
		params["subject"] = subject
	}
	if subjectType != "" {
		params["subjectType"] = subjectType
	}
	if len(tags) != 0 {
		params["tags"] = tags
	}
	if takendown {
		params["takendown"] = takendown
	}
	if err := c.LexDo(ctx, util.Query, "", "tools.ozone.moderation.queryStatuses", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
