package audits

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
	"github.com/chromedp/cdproto/runtime"
)

// AffectedCookie information about a cookie that is affected by an inspector
// issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AffectedCookie
type AffectedCookie struct {
	Name   string `json:"name"` // The following three properties uniquely identify a cookie
	Path   string `json:"path"`
	Domain string `json:"domain"`
}

// AffectedRequest information about a request that is affected by an
// inspector issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AffectedRequest
type AffectedRequest struct {
	RequestID network.RequestID `json:"requestId,omitempty,omitzero"` // The unique request id.
	URL       string            `json:"url"`
}

// AffectedFrame information about the frame affected by an inspector issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AffectedFrame
type AffectedFrame struct {
	FrameID cdp.FrameID `json:"frameId"`
}

// CookieExclusionReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieExclusionReason
type CookieExclusionReason string

// String returns the CookieExclusionReason as string value.
func (t CookieExclusionReason) String() string {
	return string(t)
}

// CookieExclusionReason values.
const (
	CookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax        CookieExclusionReason = "ExcludeSameSiteUnspecifiedTreatedAsLax"
	CookieExclusionReasonExcludeSameSiteNoneInsecure                   CookieExclusionReason = "ExcludeSameSiteNoneInsecure"
	CookieExclusionReasonExcludeSameSiteLax                            CookieExclusionReason = "ExcludeSameSiteLax"
	CookieExclusionReasonExcludeSameSiteStrict                         CookieExclusionReason = "ExcludeSameSiteStrict"
	CookieExclusionReasonExcludeInvalidSameParty                       CookieExclusionReason = "ExcludeInvalidSameParty"
	CookieExclusionReasonExcludeSamePartyCrossPartyContext             CookieExclusionReason = "ExcludeSamePartyCrossPartyContext"
	CookieExclusionReasonExcludeDomainNonASCII                         CookieExclusionReason = "ExcludeDomainNonASCII"
	CookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet CookieExclusionReason = "ExcludeThirdPartyCookieBlockedInFirstPartySet"
	CookieExclusionReasonExcludeThirdPartyPhaseout                     CookieExclusionReason = "ExcludeThirdPartyPhaseout"
	CookieExclusionReasonExcludePortMismatch                           CookieExclusionReason = "ExcludePortMismatch"
	CookieExclusionReasonExcludeSchemeMismatch                         CookieExclusionReason = "ExcludeSchemeMismatch"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookieExclusionReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookieExclusionReason(s) {
	case CookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax:
		*t = CookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax
	case CookieExclusionReasonExcludeSameSiteNoneInsecure:
		*t = CookieExclusionReasonExcludeSameSiteNoneInsecure
	case CookieExclusionReasonExcludeSameSiteLax:
		*t = CookieExclusionReasonExcludeSameSiteLax
	case CookieExclusionReasonExcludeSameSiteStrict:
		*t = CookieExclusionReasonExcludeSameSiteStrict
	case CookieExclusionReasonExcludeInvalidSameParty:
		*t = CookieExclusionReasonExcludeInvalidSameParty
	case CookieExclusionReasonExcludeSamePartyCrossPartyContext:
		*t = CookieExclusionReasonExcludeSamePartyCrossPartyContext
	case CookieExclusionReasonExcludeDomainNonASCII:
		*t = CookieExclusionReasonExcludeDomainNonASCII
	case CookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet:
		*t = CookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet
	case CookieExclusionReasonExcludeThirdPartyPhaseout:
		*t = CookieExclusionReasonExcludeThirdPartyPhaseout
	case CookieExclusionReasonExcludePortMismatch:
		*t = CookieExclusionReasonExcludePortMismatch
	case CookieExclusionReasonExcludeSchemeMismatch:
		*t = CookieExclusionReasonExcludeSchemeMismatch
	default:
		return fmt.Errorf("unknown CookieExclusionReason value: %v", s)
	}
	return nil
}

// CookieWarningReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieWarningReason
type CookieWarningReason string

// String returns the CookieWarningReason as string value.
func (t CookieWarningReason) String() string {
	return string(t)
}

// CookieWarningReason values.
const (
	CookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext        CookieWarningReason = "WarnSameSiteUnspecifiedCrossSiteContext"
	CookieWarningReasonWarnSameSiteNoneInsecure                       CookieWarningReason = "WarnSameSiteNoneInsecure"
	CookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe          CookieWarningReason = "WarnSameSiteUnspecifiedLaxAllowUnsafe"
	CookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict           CookieWarningReason = "WarnSameSiteStrictLaxDowngradeStrict"
	CookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict         CookieWarningReason = "WarnSameSiteStrictCrossDowngradeStrict"
	CookieWarningReasonWarnSameSiteStrictCrossDowngradeLax            CookieWarningReason = "WarnSameSiteStrictCrossDowngradeLax"
	CookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict            CookieWarningReason = "WarnSameSiteLaxCrossDowngradeStrict"
	CookieWarningReasonWarnSameSiteLaxCrossDowngradeLax               CookieWarningReason = "WarnSameSiteLaxCrossDowngradeLax"
	CookieWarningReasonWarnAttributeValueExceedsMaxSize               CookieWarningReason = "WarnAttributeValueExceedsMaxSize"
	CookieWarningReasonWarnDomainNonASCII                             CookieWarningReason = "WarnDomainNonASCII"
	CookieWarningReasonWarnThirdPartyPhaseout                         CookieWarningReason = "WarnThirdPartyPhaseout"
	CookieWarningReasonWarnCrossSiteRedirectDowngradeChangesInclusion CookieWarningReason = "WarnCrossSiteRedirectDowngradeChangesInclusion"
	CookieWarningReasonWarnDeprecationTrialMetadata                   CookieWarningReason = "WarnDeprecationTrialMetadata"
	CookieWarningReasonWarnThirdPartyCookieHeuristic                  CookieWarningReason = "WarnThirdPartyCookieHeuristic"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookieWarningReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookieWarningReason(s) {
	case CookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext:
		*t = CookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext
	case CookieWarningReasonWarnSameSiteNoneInsecure:
		*t = CookieWarningReasonWarnSameSiteNoneInsecure
	case CookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe:
		*t = CookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe
	case CookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict:
		*t = CookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict
	case CookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict:
		*t = CookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict
	case CookieWarningReasonWarnSameSiteStrictCrossDowngradeLax:
		*t = CookieWarningReasonWarnSameSiteStrictCrossDowngradeLax
	case CookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict:
		*t = CookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict
	case CookieWarningReasonWarnSameSiteLaxCrossDowngradeLax:
		*t = CookieWarningReasonWarnSameSiteLaxCrossDowngradeLax
	case CookieWarningReasonWarnAttributeValueExceedsMaxSize:
		*t = CookieWarningReasonWarnAttributeValueExceedsMaxSize
	case CookieWarningReasonWarnDomainNonASCII:
		*t = CookieWarningReasonWarnDomainNonASCII
	case CookieWarningReasonWarnThirdPartyPhaseout:
		*t = CookieWarningReasonWarnThirdPartyPhaseout
	case CookieWarningReasonWarnCrossSiteRedirectDowngradeChangesInclusion:
		*t = CookieWarningReasonWarnCrossSiteRedirectDowngradeChangesInclusion
	case CookieWarningReasonWarnDeprecationTrialMetadata:
		*t = CookieWarningReasonWarnDeprecationTrialMetadata
	case CookieWarningReasonWarnThirdPartyCookieHeuristic:
		*t = CookieWarningReasonWarnThirdPartyCookieHeuristic
	default:
		return fmt.Errorf("unknown CookieWarningReason value: %v", s)
	}
	return nil
}

// CookieOperation [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieOperation
type CookieOperation string

// String returns the CookieOperation as string value.
func (t CookieOperation) String() string {
	return string(t)
}

// CookieOperation values.
const (
	CookieOperationSetCookie  CookieOperation = "SetCookie"
	CookieOperationReadCookie CookieOperation = "ReadCookie"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CookieOperation) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CookieOperation(s) {
	case CookieOperationSetCookie:
		*t = CookieOperationSetCookie
	case CookieOperationReadCookie:
		*t = CookieOperationReadCookie
	default:
		return fmt.Errorf("unknown CookieOperation value: %v", s)
	}
	return nil
}

// InsightType represents the category of insight that a cookie issue falls
// under.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-InsightType
type InsightType string

// String returns the InsightType as string value.
func (t InsightType) String() string {
	return string(t)
}

// InsightType values.
const (
	InsightTypeGitHubResource InsightType = "GitHubResource"
	InsightTypeGracePeriod    InsightType = "GracePeriod"
	InsightTypeHeuristics     InsightType = "Heuristics"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *InsightType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch InsightType(s) {
	case InsightTypeGitHubResource:
		*t = InsightTypeGitHubResource
	case InsightTypeGracePeriod:
		*t = InsightTypeGracePeriod
	case InsightTypeHeuristics:
		*t = InsightTypeHeuristics
	default:
		return fmt.Errorf("unknown InsightType value: %v", s)
	}
	return nil
}

// CookieIssueInsight information about the suggested solution to a cookie
// issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieIssueInsight
type CookieIssueInsight struct {
	Type          InsightType `json:"type"`
	TableEntryURL string      `json:"tableEntryUrl,omitempty,omitzero"` // Link to table entry in third-party cookie migration readiness list.
}

// CookieIssueDetails this information is currently necessary, as the
// front-end has a difficult time finding a specific cookie. With this, we can
// convey specific error information without the cookie.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieIssueDetails
type CookieIssueDetails struct {
	Cookie                 *AffectedCookie         `json:"cookie,omitempty,omitzero"` // If AffectedCookie is not set then rawCookieLine contains the raw Set-Cookie header string. This hints at a problem where the cookie line is syntactically or semantically malformed in a way that no valid cookie could be created.
	RawCookieLine          string                  `json:"rawCookieLine,omitempty,omitzero"`
	CookieWarningReasons   []CookieWarningReason   `json:"cookieWarningReasons"`
	CookieExclusionReasons []CookieExclusionReason `json:"cookieExclusionReasons"`
	Operation              CookieOperation         `json:"operation"` // Optionally identifies the site-for-cookies and the cookie url, which may be used by the front-end as additional context.
	SiteForCookies         string                  `json:"siteForCookies,omitempty,omitzero"`
	CookieURL              string                  `json:"cookieUrl,omitempty,omitzero"`
	Request                *AffectedRequest        `json:"request,omitempty,omitzero"`
	Insight                *CookieIssueInsight     `json:"insight,omitempty,omitzero"` // The recommended solution to the issue.
}

// MixedContentResolutionStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-MixedContentResolutionStatus
type MixedContentResolutionStatus string

// String returns the MixedContentResolutionStatus as string value.
func (t MixedContentResolutionStatus) String() string {
	return string(t)
}

// MixedContentResolutionStatus values.
const (
	MixedContentResolutionStatusMixedContentBlocked               MixedContentResolutionStatus = "MixedContentBlocked"
	MixedContentResolutionStatusMixedContentAutomaticallyUpgraded MixedContentResolutionStatus = "MixedContentAutomaticallyUpgraded"
	MixedContentResolutionStatusMixedContentWarning               MixedContentResolutionStatus = "MixedContentWarning"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *MixedContentResolutionStatus) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch MixedContentResolutionStatus(s) {
	case MixedContentResolutionStatusMixedContentBlocked:
		*t = MixedContentResolutionStatusMixedContentBlocked
	case MixedContentResolutionStatusMixedContentAutomaticallyUpgraded:
		*t = MixedContentResolutionStatusMixedContentAutomaticallyUpgraded
	case MixedContentResolutionStatusMixedContentWarning:
		*t = MixedContentResolutionStatusMixedContentWarning
	default:
		return fmt.Errorf("unknown MixedContentResolutionStatus value: %v", s)
	}
	return nil
}

// MixedContentResourceType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-MixedContentResourceType
type MixedContentResourceType string

// String returns the MixedContentResourceType as string value.
func (t MixedContentResourceType) String() string {
	return string(t)
}

// MixedContentResourceType values.
const (
	MixedContentResourceTypeAttributionSrc   MixedContentResourceType = "AttributionSrc"
	MixedContentResourceTypeAudio            MixedContentResourceType = "Audio"
	MixedContentResourceTypeBeacon           MixedContentResourceType = "Beacon"
	MixedContentResourceTypeCSPReport        MixedContentResourceType = "CSPReport"
	MixedContentResourceTypeDownload         MixedContentResourceType = "Download"
	MixedContentResourceTypeEventSource      MixedContentResourceType = "EventSource"
	MixedContentResourceTypeFavicon          MixedContentResourceType = "Favicon"
	MixedContentResourceTypeFont             MixedContentResourceType = "Font"
	MixedContentResourceTypeForm             MixedContentResourceType = "Form"
	MixedContentResourceTypeFrame            MixedContentResourceType = "Frame"
	MixedContentResourceTypeImage            MixedContentResourceType = "Image"
	MixedContentResourceTypeImport           MixedContentResourceType = "Import"
	MixedContentResourceTypeJSON             MixedContentResourceType = "JSON"
	MixedContentResourceTypeManifest         MixedContentResourceType = "Manifest"
	MixedContentResourceTypePing             MixedContentResourceType = "Ping"
	MixedContentResourceTypePluginData       MixedContentResourceType = "PluginData"
	MixedContentResourceTypePluginResource   MixedContentResourceType = "PluginResource"
	MixedContentResourceTypePrefetch         MixedContentResourceType = "Prefetch"
	MixedContentResourceTypeResource         MixedContentResourceType = "Resource"
	MixedContentResourceTypeScript           MixedContentResourceType = "Script"
	MixedContentResourceTypeServiceWorker    MixedContentResourceType = "ServiceWorker"
	MixedContentResourceTypeSharedWorker     MixedContentResourceType = "SharedWorker"
	MixedContentResourceTypeSpeculationRules MixedContentResourceType = "SpeculationRules"
	MixedContentResourceTypeStylesheet       MixedContentResourceType = "Stylesheet"
	MixedContentResourceTypeTrack            MixedContentResourceType = "Track"
	MixedContentResourceTypeVideo            MixedContentResourceType = "Video"
	MixedContentResourceTypeWorker           MixedContentResourceType = "Worker"
	MixedContentResourceTypeXMLHTTPRequest   MixedContentResourceType = "XMLHttpRequest"
	MixedContentResourceTypeXSLT             MixedContentResourceType = "XSLT"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *MixedContentResourceType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch MixedContentResourceType(s) {
	case MixedContentResourceTypeAttributionSrc:
		*t = MixedContentResourceTypeAttributionSrc
	case MixedContentResourceTypeAudio:
		*t = MixedContentResourceTypeAudio
	case MixedContentResourceTypeBeacon:
		*t = MixedContentResourceTypeBeacon
	case MixedContentResourceTypeCSPReport:
		*t = MixedContentResourceTypeCSPReport
	case MixedContentResourceTypeDownload:
		*t = MixedContentResourceTypeDownload
	case MixedContentResourceTypeEventSource:
		*t = MixedContentResourceTypeEventSource
	case MixedContentResourceTypeFavicon:
		*t = MixedContentResourceTypeFavicon
	case MixedContentResourceTypeFont:
		*t = MixedContentResourceTypeFont
	case MixedContentResourceTypeForm:
		*t = MixedContentResourceTypeForm
	case MixedContentResourceTypeFrame:
		*t = MixedContentResourceTypeFrame
	case MixedContentResourceTypeImage:
		*t = MixedContentResourceTypeImage
	case MixedContentResourceTypeImport:
		*t = MixedContentResourceTypeImport
	case MixedContentResourceTypeJSON:
		*t = MixedContentResourceTypeJSON
	case MixedContentResourceTypeManifest:
		*t = MixedContentResourceTypeManifest
	case MixedContentResourceTypePing:
		*t = MixedContentResourceTypePing
	case MixedContentResourceTypePluginData:
		*t = MixedContentResourceTypePluginData
	case MixedContentResourceTypePluginResource:
		*t = MixedContentResourceTypePluginResource
	case MixedContentResourceTypePrefetch:
		*t = MixedContentResourceTypePrefetch
	case MixedContentResourceTypeResource:
		*t = MixedContentResourceTypeResource
	case MixedContentResourceTypeScript:
		*t = MixedContentResourceTypeScript
	case MixedContentResourceTypeServiceWorker:
		*t = MixedContentResourceTypeServiceWorker
	case MixedContentResourceTypeSharedWorker:
		*t = MixedContentResourceTypeSharedWorker
	case MixedContentResourceTypeSpeculationRules:
		*t = MixedContentResourceTypeSpeculationRules
	case MixedContentResourceTypeStylesheet:
		*t = MixedContentResourceTypeStylesheet
	case MixedContentResourceTypeTrack:
		*t = MixedContentResourceTypeTrack
	case MixedContentResourceTypeVideo:
		*t = MixedContentResourceTypeVideo
	case MixedContentResourceTypeWorker:
		*t = MixedContentResourceTypeWorker
	case MixedContentResourceTypeXMLHTTPRequest:
		*t = MixedContentResourceTypeXMLHTTPRequest
	case MixedContentResourceTypeXSLT:
		*t = MixedContentResourceTypeXSLT
	default:
		return fmt.Errorf("unknown MixedContentResourceType value: %v", s)
	}
	return nil
}

// MixedContentIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-MixedContentIssueDetails
type MixedContentIssueDetails struct {
	ResourceType     MixedContentResourceType     `json:"resourceType,omitempty,omitzero"` // The type of resource causing the mixed content issue (css, js, iframe, form,...). Marked as optional because it is mapped to from blink::mojom::RequestContextType, which will be replaced by network::mojom::RequestDestination
	ResolutionStatus MixedContentResolutionStatus `json:"resolutionStatus"`                // The way the mixed content issue is being resolved.
	InsecureURL      string                       `json:"insecureURL"`                     // The unsafe http url causing the mixed content issue.
	MainResourceURL  string                       `json:"mainResourceURL"`                 // The url responsible for the call to an unsafe url.
	Request          *AffectedRequest             `json:"request,omitempty,omitzero"`      // The mixed content request. Does not always exist (e.g. for unsafe form submission urls).
	Frame            *AffectedFrame               `json:"frame,omitempty,omitzero"`        // Optional because not every mixed content issue is necessarily linked to a frame.
}

// BlockedByResponseReason enum indicating the reason a response has been
// blocked. These reasons are refinements of the net error BLOCKED_BY_RESPONSE.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-BlockedByResponseReason
type BlockedByResponseReason string

// String returns the BlockedByResponseReason as string value.
func (t BlockedByResponseReason) String() string {
	return string(t)
}

// BlockedByResponseReason values.
const (
	BlockedByResponseReasonCoepFrameResourceNeedsCoepHeader                        BlockedByResponseReason = "CoepFrameResourceNeedsCoepHeader"
	BlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage             BlockedByResponseReason = "CoopSandboxedIFrameCannotNavigateToCoopPage"
	BlockedByResponseReasonCorpNotSameOrigin                                       BlockedByResponseReason = "CorpNotSameOrigin"
	BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep       BlockedByResponseReason = "CorpNotSameOriginAfterDefaultedToSameOriginByCoep"
	BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByDip        BlockedByResponseReason = "CorpNotSameOriginAfterDefaultedToSameOriginByDip"
	BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip BlockedByResponseReason = "CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip"
	BlockedByResponseReasonCorpNotSameSite                                         BlockedByResponseReason = "CorpNotSameSite"
	BlockedByResponseReasonSRIMessageSignatureMismatch                             BlockedByResponseReason = "SRIMessageSignatureMismatch"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *BlockedByResponseReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch BlockedByResponseReason(s) {
	case BlockedByResponseReasonCoepFrameResourceNeedsCoepHeader:
		*t = BlockedByResponseReasonCoepFrameResourceNeedsCoepHeader
	case BlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage:
		*t = BlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage
	case BlockedByResponseReasonCorpNotSameOrigin:
		*t = BlockedByResponseReasonCorpNotSameOrigin
	case BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep:
		*t = BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep
	case BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByDip:
		*t = BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByDip
	case BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip:
		*t = BlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip
	case BlockedByResponseReasonCorpNotSameSite:
		*t = BlockedByResponseReasonCorpNotSameSite
	case BlockedByResponseReasonSRIMessageSignatureMismatch:
		*t = BlockedByResponseReasonSRIMessageSignatureMismatch
	default:
		return fmt.Errorf("unknown BlockedByResponseReason value: %v", s)
	}
	return nil
}

// BlockedByResponseIssueDetails details for a request that has been blocked
// with the BLOCKED_BY_RESPONSE code. Currently only used for COEP/COOP, but may
// be extended to include some CSP errors in the future.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-BlockedByResponseIssueDetails
type BlockedByResponseIssueDetails struct {
	Request      *AffectedRequest        `json:"request"`
	ParentFrame  *AffectedFrame          `json:"parentFrame,omitempty,omitzero"`
	BlockedFrame *AffectedFrame          `json:"blockedFrame,omitempty,omitzero"`
	Reason       BlockedByResponseReason `json:"reason"`
}

// HeavyAdResolutionStatus [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-HeavyAdResolutionStatus
type HeavyAdResolutionStatus string

// String returns the HeavyAdResolutionStatus as string value.
func (t HeavyAdResolutionStatus) String() string {
	return string(t)
}

// HeavyAdResolutionStatus values.
const (
	HeavyAdResolutionStatusHeavyAdBlocked HeavyAdResolutionStatus = "HeavyAdBlocked"
	HeavyAdResolutionStatusHeavyAdWarning HeavyAdResolutionStatus = "HeavyAdWarning"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *HeavyAdResolutionStatus) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch HeavyAdResolutionStatus(s) {
	case HeavyAdResolutionStatusHeavyAdBlocked:
		*t = HeavyAdResolutionStatusHeavyAdBlocked
	case HeavyAdResolutionStatusHeavyAdWarning:
		*t = HeavyAdResolutionStatusHeavyAdWarning
	default:
		return fmt.Errorf("unknown HeavyAdResolutionStatus value: %v", s)
	}
	return nil
}

// HeavyAdReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-HeavyAdReason
type HeavyAdReason string

// String returns the HeavyAdReason as string value.
func (t HeavyAdReason) String() string {
	return string(t)
}

// HeavyAdReason values.
const (
	HeavyAdReasonNetworkTotalLimit HeavyAdReason = "NetworkTotalLimit"
	HeavyAdReasonCPUTotalLimit     HeavyAdReason = "CpuTotalLimit"
	HeavyAdReasonCPUPeakLimit      HeavyAdReason = "CpuPeakLimit"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *HeavyAdReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch HeavyAdReason(s) {
	case HeavyAdReasonNetworkTotalLimit:
		*t = HeavyAdReasonNetworkTotalLimit
	case HeavyAdReasonCPUTotalLimit:
		*t = HeavyAdReasonCPUTotalLimit
	case HeavyAdReasonCPUPeakLimit:
		*t = HeavyAdReasonCPUPeakLimit
	default:
		return fmt.Errorf("unknown HeavyAdReason value: %v", s)
	}
	return nil
}

// HeavyAdIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-HeavyAdIssueDetails
type HeavyAdIssueDetails struct {
	Resolution HeavyAdResolutionStatus `json:"resolution"` // The resolution status, either blocking the content or warning.
	Reason     HeavyAdReason           `json:"reason"`     // The reason the ad was blocked, total network or cpu or peak cpu.
	Frame      *AffectedFrame          `json:"frame"`      // The frame that was blocked.
}

// ContentSecurityPolicyViolationType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ContentSecurityPolicyViolationType
type ContentSecurityPolicyViolationType string

// String returns the ContentSecurityPolicyViolationType as string value.
func (t ContentSecurityPolicyViolationType) String() string {
	return string(t)
}

// ContentSecurityPolicyViolationType values.
const (
	ContentSecurityPolicyViolationTypeKInlineViolation             ContentSecurityPolicyViolationType = "kInlineViolation"
	ContentSecurityPolicyViolationTypeKEvalViolation               ContentSecurityPolicyViolationType = "kEvalViolation"
	ContentSecurityPolicyViolationTypeKURLViolation                ContentSecurityPolicyViolationType = "kURLViolation"
	ContentSecurityPolicyViolationTypeKSRIViolation                ContentSecurityPolicyViolationType = "kSRIViolation"
	ContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation   ContentSecurityPolicyViolationType = "kTrustedTypesSinkViolation"
	ContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation ContentSecurityPolicyViolationType = "kTrustedTypesPolicyViolation"
	ContentSecurityPolicyViolationTypeKWasmEvalViolation           ContentSecurityPolicyViolationType = "kWasmEvalViolation"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ContentSecurityPolicyViolationType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ContentSecurityPolicyViolationType(s) {
	case ContentSecurityPolicyViolationTypeKInlineViolation:
		*t = ContentSecurityPolicyViolationTypeKInlineViolation
	case ContentSecurityPolicyViolationTypeKEvalViolation:
		*t = ContentSecurityPolicyViolationTypeKEvalViolation
	case ContentSecurityPolicyViolationTypeKURLViolation:
		*t = ContentSecurityPolicyViolationTypeKURLViolation
	case ContentSecurityPolicyViolationTypeKSRIViolation:
		*t = ContentSecurityPolicyViolationTypeKSRIViolation
	case ContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation:
		*t = ContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation
	case ContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation:
		*t = ContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation
	case ContentSecurityPolicyViolationTypeKWasmEvalViolation:
		*t = ContentSecurityPolicyViolationTypeKWasmEvalViolation
	default:
		return fmt.Errorf("unknown ContentSecurityPolicyViolationType value: %v", s)
	}
	return nil
}

// SourceCodeLocation [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SourceCodeLocation
type SourceCodeLocation struct {
	ScriptID     runtime.ScriptID `json:"scriptId,omitempty,omitzero"`
	URL          string           `json:"url"`
	LineNumber   int64            `json:"lineNumber"`
	ColumnNumber int64            `json:"columnNumber"`
}

// ContentSecurityPolicyIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ContentSecurityPolicyIssueDetails
type ContentSecurityPolicyIssueDetails struct {
	BlockedURL                         string                             `json:"blockedURL,omitempty,omitzero"` // The url not included in allowed sources.
	ViolatedDirective                  string                             `json:"violatedDirective"`             // Specific directive that is violated, causing the CSP issue.
	IsReportOnly                       bool                               `json:"isReportOnly"`
	ContentSecurityPolicyViolationType ContentSecurityPolicyViolationType `json:"contentSecurityPolicyViolationType"`
	FrameAncestor                      *AffectedFrame                     `json:"frameAncestor,omitempty,omitzero"`
	SourceCodeLocation                 *SourceCodeLocation                `json:"sourceCodeLocation,omitempty,omitzero"`
	ViolatingNodeID                    cdp.BackendNodeID                  `json:"violatingNodeId,omitempty,omitzero"`
}

// SharedArrayBufferIssueType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SharedArrayBufferIssueType
type SharedArrayBufferIssueType string

// String returns the SharedArrayBufferIssueType as string value.
func (t SharedArrayBufferIssueType) String() string {
	return string(t)
}

// SharedArrayBufferIssueType values.
const (
	SharedArrayBufferIssueTypeTransferIssue SharedArrayBufferIssueType = "TransferIssue"
	SharedArrayBufferIssueTypeCreationIssue SharedArrayBufferIssueType = "CreationIssue"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SharedArrayBufferIssueType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SharedArrayBufferIssueType(s) {
	case SharedArrayBufferIssueTypeTransferIssue:
		*t = SharedArrayBufferIssueTypeTransferIssue
	case SharedArrayBufferIssueTypeCreationIssue:
		*t = SharedArrayBufferIssueTypeCreationIssue
	default:
		return fmt.Errorf("unknown SharedArrayBufferIssueType value: %v", s)
	}
	return nil
}

// SharedArrayBufferIssueDetails details for a issue arising from an SAB
// being instantiated in, or transferred to a context that is not cross-origin
// isolated.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SharedArrayBufferIssueDetails
type SharedArrayBufferIssueDetails struct {
	SourceCodeLocation *SourceCodeLocation        `json:"sourceCodeLocation"`
	IsWarning          bool                       `json:"isWarning"`
	Type               SharedArrayBufferIssueType `json:"type"`
}

// LowTextContrastIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-LowTextContrastIssueDetails
type LowTextContrastIssueDetails struct {
	ViolatingNodeID       cdp.BackendNodeID `json:"violatingNodeId"`
	ViolatingNodeSelector string            `json:"violatingNodeSelector"`
	ContrastRatio         float64           `json:"contrastRatio"`
	ThresholdAA           float64           `json:"thresholdAA"`
	ThresholdAAA          float64           `json:"thresholdAAA"`
	FontSize              string            `json:"fontSize"`
	FontWeight            string            `json:"fontWeight"`
}

// CorsIssueDetails details for a CORS related issue, e.g. a warning or error
// related to CORS RFC1918 enforcement.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CorsIssueDetails
type CorsIssueDetails struct {
	CorsErrorStatus        *network.CorsErrorStatus     `json:"corsErrorStatus"`
	IsWarning              bool                         `json:"isWarning"`
	Request                *AffectedRequest             `json:"request"`
	Location               *SourceCodeLocation          `json:"location,omitempty,omitzero"`
	InitiatorOrigin        string                       `json:"initiatorOrigin,omitempty,omitzero"`
	ResourceIPAddressSpace network.IPAddressSpace       `json:"resourceIPAddressSpace,omitempty,omitzero"`
	ClientSecurityState    *network.ClientSecurityState `json:"clientSecurityState,omitempty,omitzero"`
}

// AttributionReportingIssueType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AttributionReportingIssueType
type AttributionReportingIssueType string

// String returns the AttributionReportingIssueType as string value.
func (t AttributionReportingIssueType) String() string {
	return string(t)
}

// AttributionReportingIssueType values.
const (
	AttributionReportingIssueTypePermissionPolicyDisabled                             AttributionReportingIssueType = "PermissionPolicyDisabled"
	AttributionReportingIssueTypeUntrustworthyReportingOrigin                         AttributionReportingIssueType = "UntrustworthyReportingOrigin"
	AttributionReportingIssueTypeInsecureContext                                      AttributionReportingIssueType = "InsecureContext"
	AttributionReportingIssueTypeInvalidHeader                                        AttributionReportingIssueType = "InvalidHeader"
	AttributionReportingIssueTypeInvalidRegisterTriggerHeader                         AttributionReportingIssueType = "InvalidRegisterTriggerHeader"
	AttributionReportingIssueTypeSourceAndTriggerHeaders                              AttributionReportingIssueType = "SourceAndTriggerHeaders"
	AttributionReportingIssueTypeSourceIgnored                                        AttributionReportingIssueType = "SourceIgnored"
	AttributionReportingIssueTypeTriggerIgnored                                       AttributionReportingIssueType = "TriggerIgnored"
	AttributionReportingIssueTypeOsSourceIgnored                                      AttributionReportingIssueType = "OsSourceIgnored"
	AttributionReportingIssueTypeOsTriggerIgnored                                     AttributionReportingIssueType = "OsTriggerIgnored"
	AttributionReportingIssueTypeInvalidRegisterOsSourceHeader                        AttributionReportingIssueType = "InvalidRegisterOsSourceHeader"
	AttributionReportingIssueTypeInvalidRegisterOsTriggerHeader                       AttributionReportingIssueType = "InvalidRegisterOsTriggerHeader"
	AttributionReportingIssueTypeWebAndOsHeaders                                      AttributionReportingIssueType = "WebAndOsHeaders"
	AttributionReportingIssueTypeNoWebOrOsSupport                                     AttributionReportingIssueType = "NoWebOrOsSupport"
	AttributionReportingIssueTypeNavigationRegistrationWithoutTransientUserActivation AttributionReportingIssueType = "NavigationRegistrationWithoutTransientUserActivation"
	AttributionReportingIssueTypeInvalidInfoHeader                                    AttributionReportingIssueType = "InvalidInfoHeader"
	AttributionReportingIssueTypeNoRegisterSourceHeader                               AttributionReportingIssueType = "NoRegisterSourceHeader"
	AttributionReportingIssueTypeNoRegisterTriggerHeader                              AttributionReportingIssueType = "NoRegisterTriggerHeader"
	AttributionReportingIssueTypeNoRegisterOsSourceHeader                             AttributionReportingIssueType = "NoRegisterOsSourceHeader"
	AttributionReportingIssueTypeNoRegisterOsTriggerHeader                            AttributionReportingIssueType = "NoRegisterOsTriggerHeader"
	AttributionReportingIssueTypeNavigationRegistrationUniqueScopeAlreadySet          AttributionReportingIssueType = "NavigationRegistrationUniqueScopeAlreadySet"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingIssueType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingIssueType(s) {
	case AttributionReportingIssueTypePermissionPolicyDisabled:
		*t = AttributionReportingIssueTypePermissionPolicyDisabled
	case AttributionReportingIssueTypeUntrustworthyReportingOrigin:
		*t = AttributionReportingIssueTypeUntrustworthyReportingOrigin
	case AttributionReportingIssueTypeInsecureContext:
		*t = AttributionReportingIssueTypeInsecureContext
	case AttributionReportingIssueTypeInvalidHeader:
		*t = AttributionReportingIssueTypeInvalidHeader
	case AttributionReportingIssueTypeInvalidRegisterTriggerHeader:
		*t = AttributionReportingIssueTypeInvalidRegisterTriggerHeader
	case AttributionReportingIssueTypeSourceAndTriggerHeaders:
		*t = AttributionReportingIssueTypeSourceAndTriggerHeaders
	case AttributionReportingIssueTypeSourceIgnored:
		*t = AttributionReportingIssueTypeSourceIgnored
	case AttributionReportingIssueTypeTriggerIgnored:
		*t = AttributionReportingIssueTypeTriggerIgnored
	case AttributionReportingIssueTypeOsSourceIgnored:
		*t = AttributionReportingIssueTypeOsSourceIgnored
	case AttributionReportingIssueTypeOsTriggerIgnored:
		*t = AttributionReportingIssueTypeOsTriggerIgnored
	case AttributionReportingIssueTypeInvalidRegisterOsSourceHeader:
		*t = AttributionReportingIssueTypeInvalidRegisterOsSourceHeader
	case AttributionReportingIssueTypeInvalidRegisterOsTriggerHeader:
		*t = AttributionReportingIssueTypeInvalidRegisterOsTriggerHeader
	case AttributionReportingIssueTypeWebAndOsHeaders:
		*t = AttributionReportingIssueTypeWebAndOsHeaders
	case AttributionReportingIssueTypeNoWebOrOsSupport:
		*t = AttributionReportingIssueTypeNoWebOrOsSupport
	case AttributionReportingIssueTypeNavigationRegistrationWithoutTransientUserActivation:
		*t = AttributionReportingIssueTypeNavigationRegistrationWithoutTransientUserActivation
	case AttributionReportingIssueTypeInvalidInfoHeader:
		*t = AttributionReportingIssueTypeInvalidInfoHeader
	case AttributionReportingIssueTypeNoRegisterSourceHeader:
		*t = AttributionReportingIssueTypeNoRegisterSourceHeader
	case AttributionReportingIssueTypeNoRegisterTriggerHeader:
		*t = AttributionReportingIssueTypeNoRegisterTriggerHeader
	case AttributionReportingIssueTypeNoRegisterOsSourceHeader:
		*t = AttributionReportingIssueTypeNoRegisterOsSourceHeader
	case AttributionReportingIssueTypeNoRegisterOsTriggerHeader:
		*t = AttributionReportingIssueTypeNoRegisterOsTriggerHeader
	case AttributionReportingIssueTypeNavigationRegistrationUniqueScopeAlreadySet:
		*t = AttributionReportingIssueTypeNavigationRegistrationUniqueScopeAlreadySet
	default:
		return fmt.Errorf("unknown AttributionReportingIssueType value: %v", s)
	}
	return nil
}

// SharedDictionaryError [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SharedDictionaryError
type SharedDictionaryError string

// String returns the SharedDictionaryError as string value.
func (t SharedDictionaryError) String() string {
	return string(t)
}

// SharedDictionaryError values.
const (
	SharedDictionaryErrorUseErrorCrossOriginNoCorsRequest          SharedDictionaryError = "UseErrorCrossOriginNoCorsRequest"
	SharedDictionaryErrorUseErrorDictionaryLoadFailure             SharedDictionaryError = "UseErrorDictionaryLoadFailure"
	SharedDictionaryErrorUseErrorMatchingDictionaryNotUsed         SharedDictionaryError = "UseErrorMatchingDictionaryNotUsed"
	SharedDictionaryErrorUseErrorUnexpectedContentDictionaryHeader SharedDictionaryError = "UseErrorUnexpectedContentDictionaryHeader"
	SharedDictionaryErrorWriteErrorCossOriginNoCorsRequest         SharedDictionaryError = "WriteErrorCossOriginNoCorsRequest"
	SharedDictionaryErrorWriteErrorDisallowedBySettings            SharedDictionaryError = "WriteErrorDisallowedBySettings"
	SharedDictionaryErrorWriteErrorExpiredResponse                 SharedDictionaryError = "WriteErrorExpiredResponse"
	SharedDictionaryErrorWriteErrorFeatureDisabled                 SharedDictionaryError = "WriteErrorFeatureDisabled"
	SharedDictionaryErrorWriteErrorInsufficientResources           SharedDictionaryError = "WriteErrorInsufficientResources"
	SharedDictionaryErrorWriteErrorInvalidMatchField               SharedDictionaryError = "WriteErrorInvalidMatchField"
	SharedDictionaryErrorWriteErrorInvalidStructuredHeader         SharedDictionaryError = "WriteErrorInvalidStructuredHeader"
	SharedDictionaryErrorWriteErrorNavigationRequest               SharedDictionaryError = "WriteErrorNavigationRequest"
	SharedDictionaryErrorWriteErrorNoMatchField                    SharedDictionaryError = "WriteErrorNoMatchField"
	SharedDictionaryErrorWriteErrorNonListMatchDestField           SharedDictionaryError = "WriteErrorNonListMatchDestField"
	SharedDictionaryErrorWriteErrorNonSecureContext                SharedDictionaryError = "WriteErrorNonSecureContext"
	SharedDictionaryErrorWriteErrorNonStringIDField                SharedDictionaryError = "WriteErrorNonStringIdField"
	SharedDictionaryErrorWriteErrorNonStringInMatchDestList        SharedDictionaryError = "WriteErrorNonStringInMatchDestList"
	SharedDictionaryErrorWriteErrorNonStringMatchField             SharedDictionaryError = "WriteErrorNonStringMatchField"
	SharedDictionaryErrorWriteErrorNonTokenTypeField               SharedDictionaryError = "WriteErrorNonTokenTypeField"
	SharedDictionaryErrorWriteErrorRequestAborted                  SharedDictionaryError = "WriteErrorRequestAborted"
	SharedDictionaryErrorWriteErrorShuttingDown                    SharedDictionaryError = "WriteErrorShuttingDown"
	SharedDictionaryErrorWriteErrorTooLongIDField                  SharedDictionaryError = "WriteErrorTooLongIdField"
	SharedDictionaryErrorWriteErrorUnsupportedType                 SharedDictionaryError = "WriteErrorUnsupportedType"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SharedDictionaryError) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SharedDictionaryError(s) {
	case SharedDictionaryErrorUseErrorCrossOriginNoCorsRequest:
		*t = SharedDictionaryErrorUseErrorCrossOriginNoCorsRequest
	case SharedDictionaryErrorUseErrorDictionaryLoadFailure:
		*t = SharedDictionaryErrorUseErrorDictionaryLoadFailure
	case SharedDictionaryErrorUseErrorMatchingDictionaryNotUsed:
		*t = SharedDictionaryErrorUseErrorMatchingDictionaryNotUsed
	case SharedDictionaryErrorUseErrorUnexpectedContentDictionaryHeader:
		*t = SharedDictionaryErrorUseErrorUnexpectedContentDictionaryHeader
	case SharedDictionaryErrorWriteErrorCossOriginNoCorsRequest:
		*t = SharedDictionaryErrorWriteErrorCossOriginNoCorsRequest
	case SharedDictionaryErrorWriteErrorDisallowedBySettings:
		*t = SharedDictionaryErrorWriteErrorDisallowedBySettings
	case SharedDictionaryErrorWriteErrorExpiredResponse:
		*t = SharedDictionaryErrorWriteErrorExpiredResponse
	case SharedDictionaryErrorWriteErrorFeatureDisabled:
		*t = SharedDictionaryErrorWriteErrorFeatureDisabled
	case SharedDictionaryErrorWriteErrorInsufficientResources:
		*t = SharedDictionaryErrorWriteErrorInsufficientResources
	case SharedDictionaryErrorWriteErrorInvalidMatchField:
		*t = SharedDictionaryErrorWriteErrorInvalidMatchField
	case SharedDictionaryErrorWriteErrorInvalidStructuredHeader:
		*t = SharedDictionaryErrorWriteErrorInvalidStructuredHeader
	case SharedDictionaryErrorWriteErrorNavigationRequest:
		*t = SharedDictionaryErrorWriteErrorNavigationRequest
	case SharedDictionaryErrorWriteErrorNoMatchField:
		*t = SharedDictionaryErrorWriteErrorNoMatchField
	case SharedDictionaryErrorWriteErrorNonListMatchDestField:
		*t = SharedDictionaryErrorWriteErrorNonListMatchDestField
	case SharedDictionaryErrorWriteErrorNonSecureContext:
		*t = SharedDictionaryErrorWriteErrorNonSecureContext
	case SharedDictionaryErrorWriteErrorNonStringIDField:
		*t = SharedDictionaryErrorWriteErrorNonStringIDField
	case SharedDictionaryErrorWriteErrorNonStringInMatchDestList:
		*t = SharedDictionaryErrorWriteErrorNonStringInMatchDestList
	case SharedDictionaryErrorWriteErrorNonStringMatchField:
		*t = SharedDictionaryErrorWriteErrorNonStringMatchField
	case SharedDictionaryErrorWriteErrorNonTokenTypeField:
		*t = SharedDictionaryErrorWriteErrorNonTokenTypeField
	case SharedDictionaryErrorWriteErrorRequestAborted:
		*t = SharedDictionaryErrorWriteErrorRequestAborted
	case SharedDictionaryErrorWriteErrorShuttingDown:
		*t = SharedDictionaryErrorWriteErrorShuttingDown
	case SharedDictionaryErrorWriteErrorTooLongIDField:
		*t = SharedDictionaryErrorWriteErrorTooLongIDField
	case SharedDictionaryErrorWriteErrorUnsupportedType:
		*t = SharedDictionaryErrorWriteErrorUnsupportedType
	default:
		return fmt.Errorf("unknown SharedDictionaryError value: %v", s)
	}
	return nil
}

// SRIMessageSignatureError [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SRIMessageSignatureError
type SRIMessageSignatureError string

// String returns the SRIMessageSignatureError as string value.
func (t SRIMessageSignatureError) String() string {
	return string(t)
}

// SRIMessageSignatureError values.
const (
	SRIMessageSignatureErrorMissingSignatureHeader                               SRIMessageSignatureError = "MissingSignatureHeader"
	SRIMessageSignatureErrorMissingSignatureInputHeader                          SRIMessageSignatureError = "MissingSignatureInputHeader"
	SRIMessageSignatureErrorInvalidSignatureHeader                               SRIMessageSignatureError = "InvalidSignatureHeader"
	SRIMessageSignatureErrorInvalidSignatureInputHeader                          SRIMessageSignatureError = "InvalidSignatureInputHeader"
	SRIMessageSignatureErrorSignatureHeaderValueIsNotByteSequence                SRIMessageSignatureError = "SignatureHeaderValueIsNotByteSequence"
	SRIMessageSignatureErrorSignatureHeaderValueIsParameterized                  SRIMessageSignatureError = "SignatureHeaderValueIsParameterized"
	SRIMessageSignatureErrorSignatureHeaderValueIsIncorrectLength                SRIMessageSignatureError = "SignatureHeaderValueIsIncorrectLength"
	SRIMessageSignatureErrorSignatureInputHeaderMissingLabel                     SRIMessageSignatureError = "SignatureInputHeaderMissingLabel"
	SRIMessageSignatureErrorSignatureInputHeaderValueNotInnerList                SRIMessageSignatureError = "SignatureInputHeaderValueNotInnerList"
	SRIMessageSignatureErrorSignatureInputHeaderValueMissingComponents           SRIMessageSignatureError = "SignatureInputHeaderValueMissingComponents"
	SRIMessageSignatureErrorSignatureInputHeaderInvalidComponentType             SRIMessageSignatureError = "SignatureInputHeaderInvalidComponentType"
	SRIMessageSignatureErrorSignatureInputHeaderInvalidComponentName             SRIMessageSignatureError = "SignatureInputHeaderInvalidComponentName"
	SRIMessageSignatureErrorSignatureInputHeaderInvalidHeaderComponentParameter  SRIMessageSignatureError = "SignatureInputHeaderInvalidHeaderComponentParameter"
	SRIMessageSignatureErrorSignatureInputHeaderInvalidDerivedComponentParameter SRIMessageSignatureError = "SignatureInputHeaderInvalidDerivedComponentParameter"
	SRIMessageSignatureErrorSignatureInputHeaderKeyIDLength                      SRIMessageSignatureError = "SignatureInputHeaderKeyIdLength"
	SRIMessageSignatureErrorSignatureInputHeaderInvalidParameter                 SRIMessageSignatureError = "SignatureInputHeaderInvalidParameter"
	SRIMessageSignatureErrorSignatureInputHeaderMissingRequiredParameters        SRIMessageSignatureError = "SignatureInputHeaderMissingRequiredParameters"
	SRIMessageSignatureErrorValidationFailedSignatureExpired                     SRIMessageSignatureError = "ValidationFailedSignatureExpired"
	SRIMessageSignatureErrorValidationFailedInvalidLength                        SRIMessageSignatureError = "ValidationFailedInvalidLength"
	SRIMessageSignatureErrorValidationFailedSignatureMismatch                    SRIMessageSignatureError = "ValidationFailedSignatureMismatch"
	SRIMessageSignatureErrorValidationFailedIntegrityMismatch                    SRIMessageSignatureError = "ValidationFailedIntegrityMismatch"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SRIMessageSignatureError) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SRIMessageSignatureError(s) {
	case SRIMessageSignatureErrorMissingSignatureHeader:
		*t = SRIMessageSignatureErrorMissingSignatureHeader
	case SRIMessageSignatureErrorMissingSignatureInputHeader:
		*t = SRIMessageSignatureErrorMissingSignatureInputHeader
	case SRIMessageSignatureErrorInvalidSignatureHeader:
		*t = SRIMessageSignatureErrorInvalidSignatureHeader
	case SRIMessageSignatureErrorInvalidSignatureInputHeader:
		*t = SRIMessageSignatureErrorInvalidSignatureInputHeader
	case SRIMessageSignatureErrorSignatureHeaderValueIsNotByteSequence:
		*t = SRIMessageSignatureErrorSignatureHeaderValueIsNotByteSequence
	case SRIMessageSignatureErrorSignatureHeaderValueIsParameterized:
		*t = SRIMessageSignatureErrorSignatureHeaderValueIsParameterized
	case SRIMessageSignatureErrorSignatureHeaderValueIsIncorrectLength:
		*t = SRIMessageSignatureErrorSignatureHeaderValueIsIncorrectLength
	case SRIMessageSignatureErrorSignatureInputHeaderMissingLabel:
		*t = SRIMessageSignatureErrorSignatureInputHeaderMissingLabel
	case SRIMessageSignatureErrorSignatureInputHeaderValueNotInnerList:
		*t = SRIMessageSignatureErrorSignatureInputHeaderValueNotInnerList
	case SRIMessageSignatureErrorSignatureInputHeaderValueMissingComponents:
		*t = SRIMessageSignatureErrorSignatureInputHeaderValueMissingComponents
	case SRIMessageSignatureErrorSignatureInputHeaderInvalidComponentType:
		*t = SRIMessageSignatureErrorSignatureInputHeaderInvalidComponentType
	case SRIMessageSignatureErrorSignatureInputHeaderInvalidComponentName:
		*t = SRIMessageSignatureErrorSignatureInputHeaderInvalidComponentName
	case SRIMessageSignatureErrorSignatureInputHeaderInvalidHeaderComponentParameter:
		*t = SRIMessageSignatureErrorSignatureInputHeaderInvalidHeaderComponentParameter
	case SRIMessageSignatureErrorSignatureInputHeaderInvalidDerivedComponentParameter:
		*t = SRIMessageSignatureErrorSignatureInputHeaderInvalidDerivedComponentParameter
	case SRIMessageSignatureErrorSignatureInputHeaderKeyIDLength:
		*t = SRIMessageSignatureErrorSignatureInputHeaderKeyIDLength
	case SRIMessageSignatureErrorSignatureInputHeaderInvalidParameter:
		*t = SRIMessageSignatureErrorSignatureInputHeaderInvalidParameter
	case SRIMessageSignatureErrorSignatureInputHeaderMissingRequiredParameters:
		*t = SRIMessageSignatureErrorSignatureInputHeaderMissingRequiredParameters
	case SRIMessageSignatureErrorValidationFailedSignatureExpired:
		*t = SRIMessageSignatureErrorValidationFailedSignatureExpired
	case SRIMessageSignatureErrorValidationFailedInvalidLength:
		*t = SRIMessageSignatureErrorValidationFailedInvalidLength
	case SRIMessageSignatureErrorValidationFailedSignatureMismatch:
		*t = SRIMessageSignatureErrorValidationFailedSignatureMismatch
	case SRIMessageSignatureErrorValidationFailedIntegrityMismatch:
		*t = SRIMessageSignatureErrorValidationFailedIntegrityMismatch
	default:
		return fmt.Errorf("unknown SRIMessageSignatureError value: %v", s)
	}
	return nil
}

// AttributionReportingIssueDetails details for issues around "Attribution
// Reporting API" usage. Explainer:
// https://github.com/WICG/attribution-reporting-api.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-AttributionReportingIssueDetails
type AttributionReportingIssueDetails struct {
	ViolationType    AttributionReportingIssueType `json:"violationType"`
	Request          *AffectedRequest              `json:"request,omitempty,omitzero"`
	ViolatingNodeID  cdp.BackendNodeID             `json:"violatingNodeId,omitempty,omitzero"`
	InvalidParameter string                        `json:"invalidParameter,omitempty,omitzero"`
}

// QuirksModeIssueDetails details for issues about documents in Quirks Mode
// or Limited Quirks Mode that affects page layouting.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-QuirksModeIssueDetails
type QuirksModeIssueDetails struct {
	IsLimitedQuirksMode bool              `json:"isLimitedQuirksMode"` // If false, it means the document's mode is "quirks" instead of "limited-quirks".
	DocumentNodeID      cdp.BackendNodeID `json:"documentNodeId"`
	URL                 string            `json:"url"`
	FrameID             cdp.FrameID       `json:"frameId"`
	LoaderID            cdp.LoaderID      `json:"loaderId"`
}

// SharedDictionaryIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SharedDictionaryIssueDetails
type SharedDictionaryIssueDetails struct {
	SharedDictionaryError SharedDictionaryError `json:"sharedDictionaryError"`
	Request               *AffectedRequest      `json:"request"`
}

// SRIMessageSignatureIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SRIMessageSignatureIssueDetails
type SRIMessageSignatureIssueDetails struct {
	Error               SRIMessageSignatureError `json:"error"`
	SignatureBase       string                   `json:"signatureBase"`
	IntegrityAssertions []string                 `json:"integrityAssertions"`
	Request             *AffectedRequest         `json:"request"`
}

// GenericIssueErrorType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-GenericIssueErrorType
type GenericIssueErrorType string

// String returns the GenericIssueErrorType as string value.
func (t GenericIssueErrorType) String() string {
	return string(t)
}

// GenericIssueErrorType values.
const (
	GenericIssueErrorTypeFormLabelForNameError                                      GenericIssueErrorType = "FormLabelForNameError"
	GenericIssueErrorTypeFormDuplicateIDForInputError                               GenericIssueErrorType = "FormDuplicateIdForInputError"
	GenericIssueErrorTypeFormInputWithNoLabelError                                  GenericIssueErrorType = "FormInputWithNoLabelError"
	GenericIssueErrorTypeFormAutocompleteAttributeEmptyError                        GenericIssueErrorType = "FormAutocompleteAttributeEmptyError"
	GenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError                  GenericIssueErrorType = "FormEmptyIdAndNameAttributesForInputError"
	GenericIssueErrorTypeFormAriaLabelledByToNonExistingID                          GenericIssueErrorType = "FormAriaLabelledByToNonExistingId"
	GenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError GenericIssueErrorType = "FormInputAssignedAutocompleteValueToIdOrNameAttributeError"
	GenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput                       GenericIssueErrorType = "FormLabelHasNeitherForNorNestedInput"
	GenericIssueErrorTypeFormLabelForMatchesNonExistingIDError                      GenericIssueErrorType = "FormLabelForMatchesNonExistingIdError"
	GenericIssueErrorTypeFormInputHasWrongButWellIntendedAutocompleteValueError     GenericIssueErrorType = "FormInputHasWrongButWellIntendedAutocompleteValueError"
	GenericIssueErrorTypeResponseWasBlockedByORB                                    GenericIssueErrorType = "ResponseWasBlockedByORB"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *GenericIssueErrorType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch GenericIssueErrorType(s) {
	case GenericIssueErrorTypeFormLabelForNameError:
		*t = GenericIssueErrorTypeFormLabelForNameError
	case GenericIssueErrorTypeFormDuplicateIDForInputError:
		*t = GenericIssueErrorTypeFormDuplicateIDForInputError
	case GenericIssueErrorTypeFormInputWithNoLabelError:
		*t = GenericIssueErrorTypeFormInputWithNoLabelError
	case GenericIssueErrorTypeFormAutocompleteAttributeEmptyError:
		*t = GenericIssueErrorTypeFormAutocompleteAttributeEmptyError
	case GenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError:
		*t = GenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError
	case GenericIssueErrorTypeFormAriaLabelledByToNonExistingID:
		*t = GenericIssueErrorTypeFormAriaLabelledByToNonExistingID
	case GenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError:
		*t = GenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError
	case GenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput:
		*t = GenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput
	case GenericIssueErrorTypeFormLabelForMatchesNonExistingIDError:
		*t = GenericIssueErrorTypeFormLabelForMatchesNonExistingIDError
	case GenericIssueErrorTypeFormInputHasWrongButWellIntendedAutocompleteValueError:
		*t = GenericIssueErrorTypeFormInputHasWrongButWellIntendedAutocompleteValueError
	case GenericIssueErrorTypeResponseWasBlockedByORB:
		*t = GenericIssueErrorTypeResponseWasBlockedByORB
	default:
		return fmt.Errorf("unknown GenericIssueErrorType value: %v", s)
	}
	return nil
}

// GenericIssueDetails depending on the concrete errorType, different
// properties are set.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-GenericIssueDetails
type GenericIssueDetails struct {
	ErrorType              GenericIssueErrorType `json:"errorType"` // Issues with the same errorType are aggregated in the frontend.
	FrameID                cdp.FrameID           `json:"frameId,omitempty,omitzero"`
	ViolatingNodeID        cdp.BackendNodeID     `json:"violatingNodeId,omitempty,omitzero"`
	ViolatingNodeAttribute string                `json:"violatingNodeAttribute,omitempty,omitzero"`
	Request                *AffectedRequest      `json:"request,omitempty,omitzero"`
}

// DeprecationIssueDetails this issue tracks information needed to print a
// deprecation message.
// https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/frame/third_party/blink/renderer/core/frame/deprecation/README.md.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-DeprecationIssueDetails
type DeprecationIssueDetails struct {
	AffectedFrame      *AffectedFrame      `json:"affectedFrame,omitempty,omitzero"`
	SourceCodeLocation *SourceCodeLocation `json:"sourceCodeLocation"`
	Type               string              `json:"type"` // One of the deprecation names from third_party/blink/renderer/core/frame/deprecation/deprecation.json5
}

// BounceTrackingIssueDetails this issue warns about sites in the redirect
// chain of a finished navigation that may be flagged as trackers and have their
// state cleared if they don't receive a user interaction. Note that in this
// context 'site' means eTLD+1. For example, if the URL
// https://example.test:80/bounce was in the redirect chain, the site reported
// would be example.test.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-BounceTrackingIssueDetails
type BounceTrackingIssueDetails struct {
	TrackingSites []string `json:"trackingSites"`
}

// CookieDeprecationMetadataIssueDetails this issue warns about third-party
// sites that are accessing cookies on the current page, and have been permitted
// due to having a global metadata grant. Note that in this context 'site' means
// eTLD+1. For example, if the URL https://example.test:80/web_page was
// accessing cookies, the site reported would be example.test.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-CookieDeprecationMetadataIssueDetails
type CookieDeprecationMetadataIssueDetails struct {
	AllowedSites     []string        `json:"allowedSites"`
	OptOutPercentage float64         `json:"optOutPercentage"`
	IsOptOutTopLevel bool            `json:"isOptOutTopLevel"`
	Operation        CookieOperation `json:"operation"`
}

// ClientHintIssueReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ClientHintIssueReason
type ClientHintIssueReason string

// String returns the ClientHintIssueReason as string value.
func (t ClientHintIssueReason) String() string {
	return string(t)
}

// ClientHintIssueReason values.
const (
	ClientHintIssueReasonMetaTagAllowListInvalidOrigin ClientHintIssueReason = "MetaTagAllowListInvalidOrigin"
	ClientHintIssueReasonMetaTagModifiedHTML           ClientHintIssueReason = "MetaTagModifiedHTML"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ClientHintIssueReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ClientHintIssueReason(s) {
	case ClientHintIssueReasonMetaTagAllowListInvalidOrigin:
		*t = ClientHintIssueReasonMetaTagAllowListInvalidOrigin
	case ClientHintIssueReasonMetaTagModifiedHTML:
		*t = ClientHintIssueReasonMetaTagModifiedHTML
	default:
		return fmt.Errorf("unknown ClientHintIssueReason value: %v", s)
	}
	return nil
}

// FederatedAuthRequestIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthRequestIssueDetails
type FederatedAuthRequestIssueDetails struct {
	FederatedAuthRequestIssueReason FederatedAuthRequestIssueReason `json:"federatedAuthRequestIssueReason"`
}

// FederatedAuthRequestIssueReason represents the failure reason when a
// federated authentication reason fails. Should be updated alongside
// RequestIdTokenStatus in
// third_party/blink/public/mojom/devtools/inspector_issue.mojom to include all
// cases except for success.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthRequestIssueReason
type FederatedAuthRequestIssueReason string

// String returns the FederatedAuthRequestIssueReason as string value.
func (t FederatedAuthRequestIssueReason) String() string {
	return string(t)
}

// FederatedAuthRequestIssueReason values.
const (
	FederatedAuthRequestIssueReasonShouldEmbargo                    FederatedAuthRequestIssueReason = "ShouldEmbargo"
	FederatedAuthRequestIssueReasonTooManyRequests                  FederatedAuthRequestIssueReason = "TooManyRequests"
	FederatedAuthRequestIssueReasonWellKnownHTTPNotFound            FederatedAuthRequestIssueReason = "WellKnownHttpNotFound"
	FederatedAuthRequestIssueReasonWellKnownNoResponse              FederatedAuthRequestIssueReason = "WellKnownNoResponse"
	FederatedAuthRequestIssueReasonWellKnownInvalidResponse         FederatedAuthRequestIssueReason = "WellKnownInvalidResponse"
	FederatedAuthRequestIssueReasonWellKnownListEmpty               FederatedAuthRequestIssueReason = "WellKnownListEmpty"
	FederatedAuthRequestIssueReasonWellKnownInvalidContentType      FederatedAuthRequestIssueReason = "WellKnownInvalidContentType"
	FederatedAuthRequestIssueReasonConfigNotInWellKnown             FederatedAuthRequestIssueReason = "ConfigNotInWellKnown"
	FederatedAuthRequestIssueReasonWellKnownTooBig                  FederatedAuthRequestIssueReason = "WellKnownTooBig"
	FederatedAuthRequestIssueReasonConfigHTTPNotFound               FederatedAuthRequestIssueReason = "ConfigHttpNotFound"
	FederatedAuthRequestIssueReasonConfigNoResponse                 FederatedAuthRequestIssueReason = "ConfigNoResponse"
	FederatedAuthRequestIssueReasonConfigInvalidResponse            FederatedAuthRequestIssueReason = "ConfigInvalidResponse"
	FederatedAuthRequestIssueReasonConfigInvalidContentType         FederatedAuthRequestIssueReason = "ConfigInvalidContentType"
	FederatedAuthRequestIssueReasonClientMetadataHTTPNotFound       FederatedAuthRequestIssueReason = "ClientMetadataHttpNotFound"
	FederatedAuthRequestIssueReasonClientMetadataNoResponse         FederatedAuthRequestIssueReason = "ClientMetadataNoResponse"
	FederatedAuthRequestIssueReasonClientMetadataInvalidResponse    FederatedAuthRequestIssueReason = "ClientMetadataInvalidResponse"
	FederatedAuthRequestIssueReasonClientMetadataInvalidContentType FederatedAuthRequestIssueReason = "ClientMetadataInvalidContentType"
	FederatedAuthRequestIssueReasonIdpNotPotentiallyTrustworthy     FederatedAuthRequestIssueReason = "IdpNotPotentiallyTrustworthy"
	FederatedAuthRequestIssueReasonDisabledInSettings               FederatedAuthRequestIssueReason = "DisabledInSettings"
	FederatedAuthRequestIssueReasonDisabledInFlags                  FederatedAuthRequestIssueReason = "DisabledInFlags"
	FederatedAuthRequestIssueReasonErrorFetchingSignin              FederatedAuthRequestIssueReason = "ErrorFetchingSignin"
	FederatedAuthRequestIssueReasonInvalidSigninResponse            FederatedAuthRequestIssueReason = "InvalidSigninResponse"
	FederatedAuthRequestIssueReasonAccountsHTTPNotFound             FederatedAuthRequestIssueReason = "AccountsHttpNotFound"
	FederatedAuthRequestIssueReasonAccountsNoResponse               FederatedAuthRequestIssueReason = "AccountsNoResponse"
	FederatedAuthRequestIssueReasonAccountsInvalidResponse          FederatedAuthRequestIssueReason = "AccountsInvalidResponse"
	FederatedAuthRequestIssueReasonAccountsListEmpty                FederatedAuthRequestIssueReason = "AccountsListEmpty"
	FederatedAuthRequestIssueReasonAccountsInvalidContentType       FederatedAuthRequestIssueReason = "AccountsInvalidContentType"
	FederatedAuthRequestIssueReasonIDTokenHTTPNotFound              FederatedAuthRequestIssueReason = "IdTokenHttpNotFound"
	FederatedAuthRequestIssueReasonIDTokenNoResponse                FederatedAuthRequestIssueReason = "IdTokenNoResponse"
	FederatedAuthRequestIssueReasonIDTokenInvalidResponse           FederatedAuthRequestIssueReason = "IdTokenInvalidResponse"
	FederatedAuthRequestIssueReasonIDTokenIdpErrorResponse          FederatedAuthRequestIssueReason = "IdTokenIdpErrorResponse"
	FederatedAuthRequestIssueReasonIDTokenCrossSiteIdpErrorResponse FederatedAuthRequestIssueReason = "IdTokenCrossSiteIdpErrorResponse"
	FederatedAuthRequestIssueReasonIDTokenInvalidRequest            FederatedAuthRequestIssueReason = "IdTokenInvalidRequest"
	FederatedAuthRequestIssueReasonIDTokenInvalidContentType        FederatedAuthRequestIssueReason = "IdTokenInvalidContentType"
	FederatedAuthRequestIssueReasonErrorIDToken                     FederatedAuthRequestIssueReason = "ErrorIdToken"
	FederatedAuthRequestIssueReasonCanceled                         FederatedAuthRequestIssueReason = "Canceled"
	FederatedAuthRequestIssueReasonRpPageNotVisible                 FederatedAuthRequestIssueReason = "RpPageNotVisible"
	FederatedAuthRequestIssueReasonSilentMediationFailure           FederatedAuthRequestIssueReason = "SilentMediationFailure"
	FederatedAuthRequestIssueReasonThirdPartyCookiesBlocked         FederatedAuthRequestIssueReason = "ThirdPartyCookiesBlocked"
	FederatedAuthRequestIssueReasonNotSignedInWithIdp               FederatedAuthRequestIssueReason = "NotSignedInWithIdp"
	FederatedAuthRequestIssueReasonMissingTransientUserActivation   FederatedAuthRequestIssueReason = "MissingTransientUserActivation"
	FederatedAuthRequestIssueReasonReplacedByActiveMode             FederatedAuthRequestIssueReason = "ReplacedByActiveMode"
	FederatedAuthRequestIssueReasonInvalidFieldsSpecified           FederatedAuthRequestIssueReason = "InvalidFieldsSpecified"
	FederatedAuthRequestIssueReasonRelyingPartyOriginIsOpaque       FederatedAuthRequestIssueReason = "RelyingPartyOriginIsOpaque"
	FederatedAuthRequestIssueReasonTypeNotMatching                  FederatedAuthRequestIssueReason = "TypeNotMatching"
	FederatedAuthRequestIssueReasonUIDismissedNoEmbargo             FederatedAuthRequestIssueReason = "UiDismissedNoEmbargo"
	FederatedAuthRequestIssueReasonCorsError                        FederatedAuthRequestIssueReason = "CorsError"
	FederatedAuthRequestIssueReasonSuppressedBySegmentationPlatform FederatedAuthRequestIssueReason = "SuppressedBySegmentationPlatform"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *FederatedAuthRequestIssueReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch FederatedAuthRequestIssueReason(s) {
	case FederatedAuthRequestIssueReasonShouldEmbargo:
		*t = FederatedAuthRequestIssueReasonShouldEmbargo
	case FederatedAuthRequestIssueReasonTooManyRequests:
		*t = FederatedAuthRequestIssueReasonTooManyRequests
	case FederatedAuthRequestIssueReasonWellKnownHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonWellKnownHTTPNotFound
	case FederatedAuthRequestIssueReasonWellKnownNoResponse:
		*t = FederatedAuthRequestIssueReasonWellKnownNoResponse
	case FederatedAuthRequestIssueReasonWellKnownInvalidResponse:
		*t = FederatedAuthRequestIssueReasonWellKnownInvalidResponse
	case FederatedAuthRequestIssueReasonWellKnownListEmpty:
		*t = FederatedAuthRequestIssueReasonWellKnownListEmpty
	case FederatedAuthRequestIssueReasonWellKnownInvalidContentType:
		*t = FederatedAuthRequestIssueReasonWellKnownInvalidContentType
	case FederatedAuthRequestIssueReasonConfigNotInWellKnown:
		*t = FederatedAuthRequestIssueReasonConfigNotInWellKnown
	case FederatedAuthRequestIssueReasonWellKnownTooBig:
		*t = FederatedAuthRequestIssueReasonWellKnownTooBig
	case FederatedAuthRequestIssueReasonConfigHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonConfigHTTPNotFound
	case FederatedAuthRequestIssueReasonConfigNoResponse:
		*t = FederatedAuthRequestIssueReasonConfigNoResponse
	case FederatedAuthRequestIssueReasonConfigInvalidResponse:
		*t = FederatedAuthRequestIssueReasonConfigInvalidResponse
	case FederatedAuthRequestIssueReasonConfigInvalidContentType:
		*t = FederatedAuthRequestIssueReasonConfigInvalidContentType
	case FederatedAuthRequestIssueReasonClientMetadataHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonClientMetadataHTTPNotFound
	case FederatedAuthRequestIssueReasonClientMetadataNoResponse:
		*t = FederatedAuthRequestIssueReasonClientMetadataNoResponse
	case FederatedAuthRequestIssueReasonClientMetadataInvalidResponse:
		*t = FederatedAuthRequestIssueReasonClientMetadataInvalidResponse
	case FederatedAuthRequestIssueReasonClientMetadataInvalidContentType:
		*t = FederatedAuthRequestIssueReasonClientMetadataInvalidContentType
	case FederatedAuthRequestIssueReasonIdpNotPotentiallyTrustworthy:
		*t = FederatedAuthRequestIssueReasonIdpNotPotentiallyTrustworthy
	case FederatedAuthRequestIssueReasonDisabledInSettings:
		*t = FederatedAuthRequestIssueReasonDisabledInSettings
	case FederatedAuthRequestIssueReasonDisabledInFlags:
		*t = FederatedAuthRequestIssueReasonDisabledInFlags
	case FederatedAuthRequestIssueReasonErrorFetchingSignin:
		*t = FederatedAuthRequestIssueReasonErrorFetchingSignin
	case FederatedAuthRequestIssueReasonInvalidSigninResponse:
		*t = FederatedAuthRequestIssueReasonInvalidSigninResponse
	case FederatedAuthRequestIssueReasonAccountsHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonAccountsHTTPNotFound
	case FederatedAuthRequestIssueReasonAccountsNoResponse:
		*t = FederatedAuthRequestIssueReasonAccountsNoResponse
	case FederatedAuthRequestIssueReasonAccountsInvalidResponse:
		*t = FederatedAuthRequestIssueReasonAccountsInvalidResponse
	case FederatedAuthRequestIssueReasonAccountsListEmpty:
		*t = FederatedAuthRequestIssueReasonAccountsListEmpty
	case FederatedAuthRequestIssueReasonAccountsInvalidContentType:
		*t = FederatedAuthRequestIssueReasonAccountsInvalidContentType
	case FederatedAuthRequestIssueReasonIDTokenHTTPNotFound:
		*t = FederatedAuthRequestIssueReasonIDTokenHTTPNotFound
	case FederatedAuthRequestIssueReasonIDTokenNoResponse:
		*t = FederatedAuthRequestIssueReasonIDTokenNoResponse
	case FederatedAuthRequestIssueReasonIDTokenInvalidResponse:
		*t = FederatedAuthRequestIssueReasonIDTokenInvalidResponse
	case FederatedAuthRequestIssueReasonIDTokenIdpErrorResponse:
		*t = FederatedAuthRequestIssueReasonIDTokenIdpErrorResponse
	case FederatedAuthRequestIssueReasonIDTokenCrossSiteIdpErrorResponse:
		*t = FederatedAuthRequestIssueReasonIDTokenCrossSiteIdpErrorResponse
	case FederatedAuthRequestIssueReasonIDTokenInvalidRequest:
		*t = FederatedAuthRequestIssueReasonIDTokenInvalidRequest
	case FederatedAuthRequestIssueReasonIDTokenInvalidContentType:
		*t = FederatedAuthRequestIssueReasonIDTokenInvalidContentType
	case FederatedAuthRequestIssueReasonErrorIDToken:
		*t = FederatedAuthRequestIssueReasonErrorIDToken
	case FederatedAuthRequestIssueReasonCanceled:
		*t = FederatedAuthRequestIssueReasonCanceled
	case FederatedAuthRequestIssueReasonRpPageNotVisible:
		*t = FederatedAuthRequestIssueReasonRpPageNotVisible
	case FederatedAuthRequestIssueReasonSilentMediationFailure:
		*t = FederatedAuthRequestIssueReasonSilentMediationFailure
	case FederatedAuthRequestIssueReasonThirdPartyCookiesBlocked:
		*t = FederatedAuthRequestIssueReasonThirdPartyCookiesBlocked
	case FederatedAuthRequestIssueReasonNotSignedInWithIdp:
		*t = FederatedAuthRequestIssueReasonNotSignedInWithIdp
	case FederatedAuthRequestIssueReasonMissingTransientUserActivation:
		*t = FederatedAuthRequestIssueReasonMissingTransientUserActivation
	case FederatedAuthRequestIssueReasonReplacedByActiveMode:
		*t = FederatedAuthRequestIssueReasonReplacedByActiveMode
	case FederatedAuthRequestIssueReasonInvalidFieldsSpecified:
		*t = FederatedAuthRequestIssueReasonInvalidFieldsSpecified
	case FederatedAuthRequestIssueReasonRelyingPartyOriginIsOpaque:
		*t = FederatedAuthRequestIssueReasonRelyingPartyOriginIsOpaque
	case FederatedAuthRequestIssueReasonTypeNotMatching:
		*t = FederatedAuthRequestIssueReasonTypeNotMatching
	case FederatedAuthRequestIssueReasonUIDismissedNoEmbargo:
		*t = FederatedAuthRequestIssueReasonUIDismissedNoEmbargo
	case FederatedAuthRequestIssueReasonCorsError:
		*t = FederatedAuthRequestIssueReasonCorsError
	case FederatedAuthRequestIssueReasonSuppressedBySegmentationPlatform:
		*t = FederatedAuthRequestIssueReasonSuppressedBySegmentationPlatform
	default:
		return fmt.Errorf("unknown FederatedAuthRequestIssueReason value: %v", s)
	}
	return nil
}

// FederatedAuthUserInfoRequestIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthUserInfoRequestIssueDetails
type FederatedAuthUserInfoRequestIssueDetails struct {
	FederatedAuthUserInfoRequestIssueReason FederatedAuthUserInfoRequestIssueReason `json:"federatedAuthUserInfoRequestIssueReason"`
}

// FederatedAuthUserInfoRequestIssueReason represents the failure reason when
// a getUserInfo() call fails. Should be updated alongside
// FederatedAuthUserInfoRequestResult in
// third_party/blink/public/mojom/devtools/inspector_issue.mojom.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FederatedAuthUserInfoRequestIssueReason
type FederatedAuthUserInfoRequestIssueReason string

// String returns the FederatedAuthUserInfoRequestIssueReason as string value.
func (t FederatedAuthUserInfoRequestIssueReason) String() string {
	return string(t)
}

// FederatedAuthUserInfoRequestIssueReason values.
const (
	FederatedAuthUserInfoRequestIssueReasonNotSameOrigin                      FederatedAuthUserInfoRequestIssueReason = "NotSameOrigin"
	FederatedAuthUserInfoRequestIssueReasonNotIframe                          FederatedAuthUserInfoRequestIssueReason = "NotIframe"
	FederatedAuthUserInfoRequestIssueReasonNotPotentiallyTrustworthy          FederatedAuthUserInfoRequestIssueReason = "NotPotentiallyTrustworthy"
	FederatedAuthUserInfoRequestIssueReasonNoAPIPermission                    FederatedAuthUserInfoRequestIssueReason = "NoApiPermission"
	FederatedAuthUserInfoRequestIssueReasonNotSignedInWithIdp                 FederatedAuthUserInfoRequestIssueReason = "NotSignedInWithIdp"
	FederatedAuthUserInfoRequestIssueReasonNoAccountSharingPermission         FederatedAuthUserInfoRequestIssueReason = "NoAccountSharingPermission"
	FederatedAuthUserInfoRequestIssueReasonInvalidConfigOrWellKnown           FederatedAuthUserInfoRequestIssueReason = "InvalidConfigOrWellKnown"
	FederatedAuthUserInfoRequestIssueReasonInvalidAccountsResponse            FederatedAuthUserInfoRequestIssueReason = "InvalidAccountsResponse"
	FederatedAuthUserInfoRequestIssueReasonNoReturningUserFromFetchedAccounts FederatedAuthUserInfoRequestIssueReason = "NoReturningUserFromFetchedAccounts"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *FederatedAuthUserInfoRequestIssueReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch FederatedAuthUserInfoRequestIssueReason(s) {
	case FederatedAuthUserInfoRequestIssueReasonNotSameOrigin:
		*t = FederatedAuthUserInfoRequestIssueReasonNotSameOrigin
	case FederatedAuthUserInfoRequestIssueReasonNotIframe:
		*t = FederatedAuthUserInfoRequestIssueReasonNotIframe
	case FederatedAuthUserInfoRequestIssueReasonNotPotentiallyTrustworthy:
		*t = FederatedAuthUserInfoRequestIssueReasonNotPotentiallyTrustworthy
	case FederatedAuthUserInfoRequestIssueReasonNoAPIPermission:
		*t = FederatedAuthUserInfoRequestIssueReasonNoAPIPermission
	case FederatedAuthUserInfoRequestIssueReasonNotSignedInWithIdp:
		*t = FederatedAuthUserInfoRequestIssueReasonNotSignedInWithIdp
	case FederatedAuthUserInfoRequestIssueReasonNoAccountSharingPermission:
		*t = FederatedAuthUserInfoRequestIssueReasonNoAccountSharingPermission
	case FederatedAuthUserInfoRequestIssueReasonInvalidConfigOrWellKnown:
		*t = FederatedAuthUserInfoRequestIssueReasonInvalidConfigOrWellKnown
	case FederatedAuthUserInfoRequestIssueReasonInvalidAccountsResponse:
		*t = FederatedAuthUserInfoRequestIssueReasonInvalidAccountsResponse
	case FederatedAuthUserInfoRequestIssueReasonNoReturningUserFromFetchedAccounts:
		*t = FederatedAuthUserInfoRequestIssueReasonNoReturningUserFromFetchedAccounts
	default:
		return fmt.Errorf("unknown FederatedAuthUserInfoRequestIssueReason value: %v", s)
	}
	return nil
}

// ClientHintIssueDetails this issue tracks client hints related issues. It's
// used to deprecate old features, encourage the use of new ones, and provide
// general guidance.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-ClientHintIssueDetails
type ClientHintIssueDetails struct {
	SourceCodeLocation    *SourceCodeLocation   `json:"sourceCodeLocation"`
	ClientHintIssueReason ClientHintIssueReason `json:"clientHintIssueReason"`
}

// FailedRequestInfo [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-FailedRequestInfo
type FailedRequestInfo struct {
	URL            string            `json:"url"`            // The URL that failed to load.
	FailureMessage string            `json:"failureMessage"` // The failure message for the failed request.
	RequestID      network.RequestID `json:"requestId,omitempty,omitzero"`
}

// PartitioningBlobURLInfo [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-PartitioningBlobURLInfo
type PartitioningBlobURLInfo string

// String returns the PartitioningBlobURLInfo as string value.
func (t PartitioningBlobURLInfo) String() string {
	return string(t)
}

// PartitioningBlobURLInfo values.
const (
	PartitioningBlobURLInfoBlockedCrossPartitionFetching PartitioningBlobURLInfo = "BlockedCrossPartitionFetching"
	PartitioningBlobURLInfoEnforceNoopenerForNavigation  PartitioningBlobURLInfo = "EnforceNoopenerForNavigation"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PartitioningBlobURLInfo) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PartitioningBlobURLInfo(s) {
	case PartitioningBlobURLInfoBlockedCrossPartitionFetching:
		*t = PartitioningBlobURLInfoBlockedCrossPartitionFetching
	case PartitioningBlobURLInfoEnforceNoopenerForNavigation:
		*t = PartitioningBlobURLInfoEnforceNoopenerForNavigation
	default:
		return fmt.Errorf("unknown PartitioningBlobURLInfo value: %v", s)
	}
	return nil
}

// PartitioningBlobURLIssueDetails [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-PartitioningBlobURLIssueDetails
type PartitioningBlobURLIssueDetails struct {
	URL                     string                  `json:"url"`                     // The BlobURL that failed to load.
	PartitioningBlobURLInfo PartitioningBlobURLInfo `json:"partitioningBlobURLInfo"` // Additional information about the Partitioning Blob URL issue.
}

// SelectElementAccessibilityIssueReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SelectElementAccessibilityIssueReason
type SelectElementAccessibilityIssueReason string

// String returns the SelectElementAccessibilityIssueReason as string value.
func (t SelectElementAccessibilityIssueReason) String() string {
	return string(t)
}

// SelectElementAccessibilityIssueReason values.
const (
	SelectElementAccessibilityIssueReasonDisallowedSelectChild         SelectElementAccessibilityIssueReason = "DisallowedSelectChild"
	SelectElementAccessibilityIssueReasonDisallowedOptGroupChild       SelectElementAccessibilityIssueReason = "DisallowedOptGroupChild"
	SelectElementAccessibilityIssueReasonNonPhrasingContentOptionChild SelectElementAccessibilityIssueReason = "NonPhrasingContentOptionChild"
	SelectElementAccessibilityIssueReasonInteractiveContentOptionChild SelectElementAccessibilityIssueReason = "InteractiveContentOptionChild"
	SelectElementAccessibilityIssueReasonInteractiveContentLegendChild SelectElementAccessibilityIssueReason = "InteractiveContentLegendChild"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SelectElementAccessibilityIssueReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SelectElementAccessibilityIssueReason(s) {
	case SelectElementAccessibilityIssueReasonDisallowedSelectChild:
		*t = SelectElementAccessibilityIssueReasonDisallowedSelectChild
	case SelectElementAccessibilityIssueReasonDisallowedOptGroupChild:
		*t = SelectElementAccessibilityIssueReasonDisallowedOptGroupChild
	case SelectElementAccessibilityIssueReasonNonPhrasingContentOptionChild:
		*t = SelectElementAccessibilityIssueReasonNonPhrasingContentOptionChild
	case SelectElementAccessibilityIssueReasonInteractiveContentOptionChild:
		*t = SelectElementAccessibilityIssueReasonInteractiveContentOptionChild
	case SelectElementAccessibilityIssueReasonInteractiveContentLegendChild:
		*t = SelectElementAccessibilityIssueReasonInteractiveContentLegendChild
	default:
		return fmt.Errorf("unknown SelectElementAccessibilityIssueReason value: %v", s)
	}
	return nil
}

// SelectElementAccessibilityIssueDetails this issue warns about errors in
// the select element content model.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-SelectElementAccessibilityIssueDetails
type SelectElementAccessibilityIssueDetails struct {
	NodeID                                cdp.BackendNodeID                     `json:"nodeId"`
	SelectElementAccessibilityIssueReason SelectElementAccessibilityIssueReason `json:"selectElementAccessibilityIssueReason"`
	HasDisallowedAttributes               bool                                  `json:"hasDisallowedAttributes"`
}

// StyleSheetLoadingIssueReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-StyleSheetLoadingIssueReason
type StyleSheetLoadingIssueReason string

// String returns the StyleSheetLoadingIssueReason as string value.
func (t StyleSheetLoadingIssueReason) String() string {
	return string(t)
}

// StyleSheetLoadingIssueReason values.
const (
	StyleSheetLoadingIssueReasonLateImportRule StyleSheetLoadingIssueReason = "LateImportRule"
	StyleSheetLoadingIssueReasonRequestFailed  StyleSheetLoadingIssueReason = "RequestFailed"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *StyleSheetLoadingIssueReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch StyleSheetLoadingIssueReason(s) {
	case StyleSheetLoadingIssueReasonLateImportRule:
		*t = StyleSheetLoadingIssueReasonLateImportRule
	case StyleSheetLoadingIssueReasonRequestFailed:
		*t = StyleSheetLoadingIssueReasonRequestFailed
	default:
		return fmt.Errorf("unknown StyleSheetLoadingIssueReason value: %v", s)
	}
	return nil
}

// StylesheetLoadingIssueDetails this issue warns when a referenced
// stylesheet couldn't be loaded.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-StylesheetLoadingIssueDetails
type StylesheetLoadingIssueDetails struct {
	SourceCodeLocation           *SourceCodeLocation          `json:"sourceCodeLocation"`                   // Source code position that referenced the failing stylesheet.
	StyleSheetLoadingIssueReason StyleSheetLoadingIssueReason `json:"styleSheetLoadingIssueReason"`         // Reason why the stylesheet couldn't be loaded.
	FailedRequestInfo            *FailedRequestInfo           `json:"failedRequestInfo,omitempty,omitzero"` // Contains additional info when the failure was due to a request.
}

// PropertyRuleIssueReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-PropertyRuleIssueReason
type PropertyRuleIssueReason string

// String returns the PropertyRuleIssueReason as string value.
func (t PropertyRuleIssueReason) String() string {
	return string(t)
}

// PropertyRuleIssueReason values.
const (
	PropertyRuleIssueReasonInvalidSyntax       PropertyRuleIssueReason = "InvalidSyntax"
	PropertyRuleIssueReasonInvalidInitialValue PropertyRuleIssueReason = "InvalidInitialValue"
	PropertyRuleIssueReasonInvalidInherits     PropertyRuleIssueReason = "InvalidInherits"
	PropertyRuleIssueReasonInvalidName         PropertyRuleIssueReason = "InvalidName"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PropertyRuleIssueReason) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PropertyRuleIssueReason(s) {
	case PropertyRuleIssueReasonInvalidSyntax:
		*t = PropertyRuleIssueReasonInvalidSyntax
	case PropertyRuleIssueReasonInvalidInitialValue:
		*t = PropertyRuleIssueReasonInvalidInitialValue
	case PropertyRuleIssueReasonInvalidInherits:
		*t = PropertyRuleIssueReasonInvalidInherits
	case PropertyRuleIssueReasonInvalidName:
		*t = PropertyRuleIssueReasonInvalidName
	default:
		return fmt.Errorf("unknown PropertyRuleIssueReason value: %v", s)
	}
	return nil
}

// PropertyRuleIssueDetails this issue warns about errors in property rules
// that lead to property registrations being ignored.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-PropertyRuleIssueDetails
type PropertyRuleIssueDetails struct {
	SourceCodeLocation      *SourceCodeLocation     `json:"sourceCodeLocation"`               // Source code position of the property rule.
	PropertyRuleIssueReason PropertyRuleIssueReason `json:"propertyRuleIssueReason"`          // Reason why the property rule was discarded.
	PropertyValue           string                  `json:"propertyValue,omitempty,omitzero"` // The value of the property rule property that failed to parse
}

// InspectorIssueCode a unique identifier for the type of issue. Each type
// may use one of the optional fields in InspectorIssueDetails to convey more
// specific information about the kind of issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-InspectorIssueCode
type InspectorIssueCode string

// String returns the InspectorIssueCode as string value.
func (t InspectorIssueCode) String() string {
	return string(t)
}

// InspectorIssueCode values.
const (
	InspectorIssueCodeCookieIssue                       InspectorIssueCode = "CookieIssue"
	InspectorIssueCodeMixedContentIssue                 InspectorIssueCode = "MixedContentIssue"
	InspectorIssueCodeBlockedByResponseIssue            InspectorIssueCode = "BlockedByResponseIssue"
	InspectorIssueCodeHeavyAdIssue                      InspectorIssueCode = "HeavyAdIssue"
	InspectorIssueCodeContentSecurityPolicyIssue        InspectorIssueCode = "ContentSecurityPolicyIssue"
	InspectorIssueCodeSharedArrayBufferIssue            InspectorIssueCode = "SharedArrayBufferIssue"
	InspectorIssueCodeLowTextContrastIssue              InspectorIssueCode = "LowTextContrastIssue"
	InspectorIssueCodeCorsIssue                         InspectorIssueCode = "CorsIssue"
	InspectorIssueCodeAttributionReportingIssue         InspectorIssueCode = "AttributionReportingIssue"
	InspectorIssueCodeQuirksModeIssue                   InspectorIssueCode = "QuirksModeIssue"
	InspectorIssueCodePartitioningBlobURLIssue          InspectorIssueCode = "PartitioningBlobURLIssue"
	InspectorIssueCodeNavigatorUserAgentIssue           InspectorIssueCode = "NavigatorUserAgentIssue"
	InspectorIssueCodeGenericIssue                      InspectorIssueCode = "GenericIssue"
	InspectorIssueCodeDeprecationIssue                  InspectorIssueCode = "DeprecationIssue"
	InspectorIssueCodeClientHintIssue                   InspectorIssueCode = "ClientHintIssue"
	InspectorIssueCodeFederatedAuthRequestIssue         InspectorIssueCode = "FederatedAuthRequestIssue"
	InspectorIssueCodeBounceTrackingIssue               InspectorIssueCode = "BounceTrackingIssue"
	InspectorIssueCodeCookieDeprecationMetadataIssue    InspectorIssueCode = "CookieDeprecationMetadataIssue"
	InspectorIssueCodeStylesheetLoadingIssue            InspectorIssueCode = "StylesheetLoadingIssue"
	InspectorIssueCodeFederatedAuthUserInfoRequestIssue InspectorIssueCode = "FederatedAuthUserInfoRequestIssue"
	InspectorIssueCodePropertyRuleIssue                 InspectorIssueCode = "PropertyRuleIssue"
	InspectorIssueCodeSharedDictionaryIssue             InspectorIssueCode = "SharedDictionaryIssue"
	InspectorIssueCodeSelectElementAccessibilityIssue   InspectorIssueCode = "SelectElementAccessibilityIssue"
	InspectorIssueCodeSRIMessageSignatureIssue          InspectorIssueCode = "SRIMessageSignatureIssue"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *InspectorIssueCode) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch InspectorIssueCode(s) {
	case InspectorIssueCodeCookieIssue:
		*t = InspectorIssueCodeCookieIssue
	case InspectorIssueCodeMixedContentIssue:
		*t = InspectorIssueCodeMixedContentIssue
	case InspectorIssueCodeBlockedByResponseIssue:
		*t = InspectorIssueCodeBlockedByResponseIssue
	case InspectorIssueCodeHeavyAdIssue:
		*t = InspectorIssueCodeHeavyAdIssue
	case InspectorIssueCodeContentSecurityPolicyIssue:
		*t = InspectorIssueCodeContentSecurityPolicyIssue
	case InspectorIssueCodeSharedArrayBufferIssue:
		*t = InspectorIssueCodeSharedArrayBufferIssue
	case InspectorIssueCodeLowTextContrastIssue:
		*t = InspectorIssueCodeLowTextContrastIssue
	case InspectorIssueCodeCorsIssue:
		*t = InspectorIssueCodeCorsIssue
	case InspectorIssueCodeAttributionReportingIssue:
		*t = InspectorIssueCodeAttributionReportingIssue
	case InspectorIssueCodeQuirksModeIssue:
		*t = InspectorIssueCodeQuirksModeIssue
	case InspectorIssueCodePartitioningBlobURLIssue:
		*t = InspectorIssueCodePartitioningBlobURLIssue
	case InspectorIssueCodeNavigatorUserAgentIssue:
		*t = InspectorIssueCodeNavigatorUserAgentIssue
	case InspectorIssueCodeGenericIssue:
		*t = InspectorIssueCodeGenericIssue
	case InspectorIssueCodeDeprecationIssue:
		*t = InspectorIssueCodeDeprecationIssue
	case InspectorIssueCodeClientHintIssue:
		*t = InspectorIssueCodeClientHintIssue
	case InspectorIssueCodeFederatedAuthRequestIssue:
		*t = InspectorIssueCodeFederatedAuthRequestIssue
	case InspectorIssueCodeBounceTrackingIssue:
		*t = InspectorIssueCodeBounceTrackingIssue
	case InspectorIssueCodeCookieDeprecationMetadataIssue:
		*t = InspectorIssueCodeCookieDeprecationMetadataIssue
	case InspectorIssueCodeStylesheetLoadingIssue:
		*t = InspectorIssueCodeStylesheetLoadingIssue
	case InspectorIssueCodeFederatedAuthUserInfoRequestIssue:
		*t = InspectorIssueCodeFederatedAuthUserInfoRequestIssue
	case InspectorIssueCodePropertyRuleIssue:
		*t = InspectorIssueCodePropertyRuleIssue
	case InspectorIssueCodeSharedDictionaryIssue:
		*t = InspectorIssueCodeSharedDictionaryIssue
	case InspectorIssueCodeSelectElementAccessibilityIssue:
		*t = InspectorIssueCodeSelectElementAccessibilityIssue
	case InspectorIssueCodeSRIMessageSignatureIssue:
		*t = InspectorIssueCodeSRIMessageSignatureIssue
	default:
		return fmt.Errorf("unknown InspectorIssueCode value: %v", s)
	}
	return nil
}

// InspectorIssueDetails this struct holds a list of optional fields with
// additional information specific to the kind of issue. When adding a new issue
// code, please also add a new optional field to this type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-InspectorIssueDetails
type InspectorIssueDetails struct {
	CookieIssueDetails                       *CookieIssueDetails                       `json:"cookieIssueDetails,omitempty,omitzero"`
	MixedContentIssueDetails                 *MixedContentIssueDetails                 `json:"mixedContentIssueDetails,omitempty,omitzero"`
	BlockedByResponseIssueDetails            *BlockedByResponseIssueDetails            `json:"blockedByResponseIssueDetails,omitempty,omitzero"`
	HeavyAdIssueDetails                      *HeavyAdIssueDetails                      `json:"heavyAdIssueDetails,omitempty,omitzero"`
	ContentSecurityPolicyIssueDetails        *ContentSecurityPolicyIssueDetails        `json:"contentSecurityPolicyIssueDetails,omitempty,omitzero"`
	SharedArrayBufferIssueDetails            *SharedArrayBufferIssueDetails            `json:"sharedArrayBufferIssueDetails,omitempty,omitzero"`
	LowTextContrastIssueDetails              *LowTextContrastIssueDetails              `json:"lowTextContrastIssueDetails,omitempty,omitzero"`
	CorsIssueDetails                         *CorsIssueDetails                         `json:"corsIssueDetails,omitempty,omitzero"`
	AttributionReportingIssueDetails         *AttributionReportingIssueDetails         `json:"attributionReportingIssueDetails,omitempty,omitzero"`
	QuirksModeIssueDetails                   *QuirksModeIssueDetails                   `json:"quirksModeIssueDetails,omitempty,omitzero"`
	PartitioningBlobURLIssueDetails          *PartitioningBlobURLIssueDetails          `json:"partitioningBlobURLIssueDetails,omitempty,omitzero"`
	GenericIssueDetails                      *GenericIssueDetails                      `json:"genericIssueDetails,omitempty,omitzero"`
	DeprecationIssueDetails                  *DeprecationIssueDetails                  `json:"deprecationIssueDetails,omitempty,omitzero"`
	ClientHintIssueDetails                   *ClientHintIssueDetails                   `json:"clientHintIssueDetails,omitempty,omitzero"`
	FederatedAuthRequestIssueDetails         *FederatedAuthRequestIssueDetails         `json:"federatedAuthRequestIssueDetails,omitempty,omitzero"`
	BounceTrackingIssueDetails               *BounceTrackingIssueDetails               `json:"bounceTrackingIssueDetails,omitempty,omitzero"`
	CookieDeprecationMetadataIssueDetails    *CookieDeprecationMetadataIssueDetails    `json:"cookieDeprecationMetadataIssueDetails,omitempty,omitzero"`
	StylesheetLoadingIssueDetails            *StylesheetLoadingIssueDetails            `json:"stylesheetLoadingIssueDetails,omitempty,omitzero"`
	PropertyRuleIssueDetails                 *PropertyRuleIssueDetails                 `json:"propertyRuleIssueDetails,omitempty,omitzero"`
	FederatedAuthUserInfoRequestIssueDetails *FederatedAuthUserInfoRequestIssueDetails `json:"federatedAuthUserInfoRequestIssueDetails,omitempty,omitzero"`
	SharedDictionaryIssueDetails             *SharedDictionaryIssueDetails             `json:"sharedDictionaryIssueDetails,omitempty,omitzero"`
	SelectElementAccessibilityIssueDetails   *SelectElementAccessibilityIssueDetails   `json:"selectElementAccessibilityIssueDetails,omitempty,omitzero"`
	SriMessageSignatureIssueDetails          *SRIMessageSignatureIssueDetails          `json:"sriMessageSignatureIssueDetails,omitempty,omitzero"`
}

// IssueID a unique id for a DevTools inspector issue. Allows other entities
// (e.g. exceptions, CDP message, console messages, etc.) to reference an issue.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-IssueId
type IssueID string

// String returns the IssueID as string value.
func (t IssueID) String() string {
	return string(t)
}

// InspectorIssue an inspector issue reported from the back-end.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#type-InspectorIssue
type InspectorIssue struct {
	Code    InspectorIssueCode     `json:"code"`
	Details *InspectorIssueDetails `json:"details"`
	IssueID IssueID                `json:"issueId,omitempty,omitzero"` // A unique id for this issue. May be omitted if no other entity (e.g. exception, CDP message, etc.) is referencing this issue.
}

// GetEncodedResponseEncoding the encoding to use.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Audits#method-getEncodedResponse
type GetEncodedResponseEncoding string

// String returns the GetEncodedResponseEncoding as string value.
func (t GetEncodedResponseEncoding) String() string {
	return string(t)
}

// GetEncodedResponseEncoding values.
const (
	GetEncodedResponseEncodingWebp GetEncodedResponseEncoding = "webp"
	GetEncodedResponseEncodingJpeg GetEncodedResponseEncoding = "jpeg"
	GetEncodedResponseEncodingPng  GetEncodedResponseEncoding = "png"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *GetEncodedResponseEncoding) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch GetEncodedResponseEncoding(s) {
	case GetEncodedResponseEncodingWebp:
		*t = GetEncodedResponseEncodingWebp
	case GetEncodedResponseEncodingJpeg:
		*t = GetEncodedResponseEncodingJpeg
	case GetEncodedResponseEncodingPng:
		*t = GetEncodedResponseEncodingPng
	default:
		return fmt.Errorf("unknown GetEncodedResponseEncoding value: %v", s)
	}
	return nil
}
