// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlist"
)

// AllowList is the model entity for the AllowList schema.
type AllowList struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// FromConsole holds the value of the "from_console" field.
	FromConsole bool `json:"from_console,omitempty"`
	// Description holds the value of the "description" field.
	Description string `json:"description,omitempty"`
	// AllowlistID holds the value of the "allowlist_id" field.
	AllowlistID string `json:"allowlist_id,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the AllowListQuery when eager-loading is set.
	Edges        AllowListEdges `json:"edges"`
	selectValues sql.SelectValues
}

// AllowListEdges holds the relations/edges for other nodes in the graph.
type AllowListEdges struct {
	// AllowlistItems holds the value of the allowlist_items edge.
	AllowlistItems []*AllowListItem `json:"allowlist_items,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// AllowlistItemsOrErr returns the AllowlistItems value or an error if the edge
// was not loaded in eager-loading.
func (e AllowListEdges) AllowlistItemsOrErr() ([]*AllowListItem, error) {
	if e.loadedTypes[0] {
		return e.AllowlistItems, nil
	}
	return nil, &NotLoadedError{edge: "allowlist_items"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*AllowList) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case allowlist.FieldFromConsole:
			values[i] = new(sql.NullBool)
		case allowlist.FieldID:
			values[i] = new(sql.NullInt64)
		case allowlist.FieldName, allowlist.FieldDescription, allowlist.FieldAllowlistID:
			values[i] = new(sql.NullString)
		case allowlist.FieldCreatedAt, allowlist.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the AllowList fields.
func (al *AllowList) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case allowlist.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			al.ID = int(value.Int64)
		case allowlist.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				al.CreatedAt = value.Time
			}
		case allowlist.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				al.UpdatedAt = value.Time
			}
		case allowlist.FieldName:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field name", values[i])
			} else if value.Valid {
				al.Name = value.String
			}
		case allowlist.FieldFromConsole:
			if value, ok := values[i].(*sql.NullBool); !ok {
				return fmt.Errorf("unexpected type %T for field from_console", values[i])
			} else if value.Valid {
				al.FromConsole = value.Bool
			}
		case allowlist.FieldDescription:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field description", values[i])
			} else if value.Valid {
				al.Description = value.String
			}
		case allowlist.FieldAllowlistID:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field allowlist_id", values[i])
			} else if value.Valid {
				al.AllowlistID = value.String
			}
		default:
			al.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the AllowList.
// This includes values selected through modifiers, order, etc.
func (al *AllowList) Value(name string) (ent.Value, error) {
	return al.selectValues.Get(name)
}

// QueryAllowlistItems queries the "allowlist_items" edge of the AllowList entity.
func (al *AllowList) QueryAllowlistItems() *AllowListItemQuery {
	return NewAllowListClient(al.config).QueryAllowlistItems(al)
}

// Update returns a builder for updating this AllowList.
// Note that you need to call AllowList.Unwrap() before calling this method if this AllowList
// was returned from a transaction, and the transaction was committed or rolled back.
func (al *AllowList) Update() *AllowListUpdateOne {
	return NewAllowListClient(al.config).UpdateOne(al)
}

// Unwrap unwraps the AllowList entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (al *AllowList) Unwrap() *AllowList {
	_tx, ok := al.config.driver.(*txDriver)
	if !ok {
		panic("ent: AllowList is not a transactional entity")
	}
	al.config.driver = _tx.drv
	return al
}

// String implements the fmt.Stringer.
func (al *AllowList) String() string {
	var builder strings.Builder
	builder.WriteString("AllowList(")
	builder.WriteString(fmt.Sprintf("id=%v, ", al.ID))
	builder.WriteString("created_at=")
	builder.WriteString(al.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(al.UpdatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("name=")
	builder.WriteString(al.Name)
	builder.WriteString(", ")
	builder.WriteString("from_console=")
	builder.WriteString(fmt.Sprintf("%v", al.FromConsole))
	builder.WriteString(", ")
	builder.WriteString("description=")
	builder.WriteString(al.Description)
	builder.WriteString(", ")
	builder.WriteString("allowlist_id=")
	builder.WriteString(al.AllowlistID)
	builder.WriteByte(')')
	return builder.String()
}

// AllowLists is a parsable slice of AllowList.
type AllowLists []*AllowList
