// Code generated by ent, DO NOT EDIT.

package allowlistitem

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

const (
	// Label holds the string label denoting the allowlistitem type in the database.
	Label = "allow_list_item"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// FieldExpiresAt holds the string denoting the expires_at field in the database.
	FieldExpiresAt = "expires_at"
	// FieldComment holds the string denoting the comment field in the database.
	FieldComment = "comment"
	// FieldValue holds the string denoting the value field in the database.
	FieldValue = "value"
	// FieldStartIP holds the string denoting the start_ip field in the database.
	FieldStartIP = "start_ip"
	// FieldEndIP holds the string denoting the end_ip field in the database.
	FieldEndIP = "end_ip"
	// FieldStartSuffix holds the string denoting the start_suffix field in the database.
	FieldStartSuffix = "start_suffix"
	// FieldEndSuffix holds the string denoting the end_suffix field in the database.
	FieldEndSuffix = "end_suffix"
	// FieldIPSize holds the string denoting the ip_size field in the database.
	FieldIPSize = "ip_size"
	// EdgeAllowlist holds the string denoting the allowlist edge name in mutations.
	EdgeAllowlist = "allowlist"
	// Table holds the table name of the allowlistitem in the database.
	Table = "allow_list_items"
	// AllowlistTable is the table that holds the allowlist relation/edge. The primary key declared below.
	AllowlistTable = "allow_list_allowlist_items"
	// AllowlistInverseTable is the table name for the AllowList entity.
	// It exists in this package in order to avoid circular dependency with the "allowlist" package.
	AllowlistInverseTable = "allow_lists"
)

// Columns holds all SQL columns for allowlistitem fields.
var Columns = []string{
	FieldID,
	FieldCreatedAt,
	FieldUpdatedAt,
	FieldExpiresAt,
	FieldComment,
	FieldValue,
	FieldStartIP,
	FieldEndIP,
	FieldStartSuffix,
	FieldEndSuffix,
	FieldIPSize,
}

var (
	// AllowlistPrimaryKey and AllowlistColumn2 are the table columns denoting the
	// primary key for the allowlist relation (M2M).
	AllowlistPrimaryKey = []string{"allow_list_id", "allow_list_item_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
)

// OrderOption defines the ordering options for the AllowListItem queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByExpiresAt orders the results by the expires_at field.
func ByExpiresAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldExpiresAt, opts...).ToFunc()
}

// ByComment orders the results by the comment field.
func ByComment(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldComment, opts...).ToFunc()
}

// ByValue orders the results by the value field.
func ByValue(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldValue, opts...).ToFunc()
}

// ByStartIP orders the results by the start_ip field.
func ByStartIP(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStartIP, opts...).ToFunc()
}

// ByEndIP orders the results by the end_ip field.
func ByEndIP(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEndIP, opts...).ToFunc()
}

// ByStartSuffix orders the results by the start_suffix field.
func ByStartSuffix(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldStartSuffix, opts...).ToFunc()
}

// ByEndSuffix orders the results by the end_suffix field.
func ByEndSuffix(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldEndSuffix, opts...).ToFunc()
}

// ByIPSize orders the results by the ip_size field.
func ByIPSize(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldIPSize, opts...).ToFunc()
}

// ByAllowlistCount orders the results by allowlist count.
func ByAllowlistCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newAllowlistStep(), opts...)
	}
}

// ByAllowlist orders the results by allowlist terms.
func ByAllowlist(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newAllowlistStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newAllowlistStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(AllowlistInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, true, AllowlistTable, AllowlistPrimaryKey...),
	)
}
