// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ListTeamsRolesReader is a Reader for the ListTeamsRoles structure.
type ListTeamsRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListTeamsRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListTeamsRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewListTeamsRolesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListTeamsRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListTeamsRolesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /access-control/teams/roles/search] listTeamsRoles", response, response.Code())
	}
}

// NewListTeamsRolesOK creates a ListTeamsRolesOK with default headers values
func NewListTeamsRolesOK() *ListTeamsRolesOK {
	return &ListTeamsRolesOK{}
}

/*
ListTeamsRolesOK describes a response with status code 200, with default header values.

(empty)
*/
type ListTeamsRolesOK struct {
	Payload map[string][]models.RoleDTO
}

// IsSuccess returns true when this list teams roles Ok response has a 2xx status code
func (o *ListTeamsRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list teams roles Ok response has a 3xx status code
func (o *ListTeamsRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list teams roles Ok response has a 4xx status code
func (o *ListTeamsRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list teams roles Ok response has a 5xx status code
func (o *ListTeamsRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list teams roles Ok response a status code equal to that given
func (o *ListTeamsRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list teams roles Ok response
func (o *ListTeamsRolesOK) Code() int {
	return 200
}

func (o *ListTeamsRolesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesOk %s", 200, payload)
}

func (o *ListTeamsRolesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesOk %s", 200, payload)
}

func (o *ListTeamsRolesOK) GetPayload() map[string][]models.RoleDTO {
	return o.Payload
}

func (o *ListTeamsRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTeamsRolesBadRequest creates a ListTeamsRolesBadRequest with default headers values
func NewListTeamsRolesBadRequest() *ListTeamsRolesBadRequest {
	return &ListTeamsRolesBadRequest{}
}

/*
ListTeamsRolesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type ListTeamsRolesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list teams roles bad request response has a 2xx status code
func (o *ListTeamsRolesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list teams roles bad request response has a 3xx status code
func (o *ListTeamsRolesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list teams roles bad request response has a 4xx status code
func (o *ListTeamsRolesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this list teams roles bad request response has a 5xx status code
func (o *ListTeamsRolesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this list teams roles bad request response a status code equal to that given
func (o *ListTeamsRolesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the list teams roles bad request response
func (o *ListTeamsRolesBadRequest) Code() int {
	return 400
}

func (o *ListTeamsRolesBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesBadRequest %s", 400, payload)
}

func (o *ListTeamsRolesBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesBadRequest %s", 400, payload)
}

func (o *ListTeamsRolesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTeamsRolesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTeamsRolesForbidden creates a ListTeamsRolesForbidden with default headers values
func NewListTeamsRolesForbidden() *ListTeamsRolesForbidden {
	return &ListTeamsRolesForbidden{}
}

/*
ListTeamsRolesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ListTeamsRolesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list teams roles forbidden response has a 2xx status code
func (o *ListTeamsRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list teams roles forbidden response has a 3xx status code
func (o *ListTeamsRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list teams roles forbidden response has a 4xx status code
func (o *ListTeamsRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list teams roles forbidden response has a 5xx status code
func (o *ListTeamsRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list teams roles forbidden response a status code equal to that given
func (o *ListTeamsRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list teams roles forbidden response
func (o *ListTeamsRolesForbidden) Code() int {
	return 403
}

func (o *ListTeamsRolesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesForbidden %s", 403, payload)
}

func (o *ListTeamsRolesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesForbidden %s", 403, payload)
}

func (o *ListTeamsRolesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTeamsRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTeamsRolesInternalServerError creates a ListTeamsRolesInternalServerError with default headers values
func NewListTeamsRolesInternalServerError() *ListTeamsRolesInternalServerError {
	return &ListTeamsRolesInternalServerError{}
}

/*
ListTeamsRolesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type ListTeamsRolesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list teams roles internal server error response has a 2xx status code
func (o *ListTeamsRolesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list teams roles internal server error response has a 3xx status code
func (o *ListTeamsRolesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list teams roles internal server error response has a 4xx status code
func (o *ListTeamsRolesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this list teams roles internal server error response has a 5xx status code
func (o *ListTeamsRolesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this list teams roles internal server error response a status code equal to that given
func (o *ListTeamsRolesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the list teams roles internal server error response
func (o *ListTeamsRolesInternalServerError) Code() int {
	return 500
}

func (o *ListTeamsRolesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesInternalServerError %s", 500, payload)
}

func (o *ListTeamsRolesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/roles/search][%d] listTeamsRolesInternalServerError %s", 500, payload)
}

func (o *ListTeamsRolesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTeamsRolesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
