// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewSetRoleAssignmentsParams creates a new SetRoleAssignmentsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSetRoleAssignmentsParams() *SetRoleAssignmentsParams {
	return &SetRoleAssignmentsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSetRoleAssignmentsParamsWithTimeout creates a new SetRoleAssignmentsParams object
// with the ability to set a timeout on a request.
func NewSetRoleAssignmentsParamsWithTimeout(timeout time.Duration) *SetRoleAssignmentsParams {
	return &SetRoleAssignmentsParams{
		timeout: timeout,
	}
}

// NewSetRoleAssignmentsParamsWithContext creates a new SetRoleAssignmentsParams object
// with the ability to set a context for a request.
func NewSetRoleAssignmentsParamsWithContext(ctx context.Context) *SetRoleAssignmentsParams {
	return &SetRoleAssignmentsParams{
		Context: ctx,
	}
}

// NewSetRoleAssignmentsParamsWithHTTPClient creates a new SetRoleAssignmentsParams object
// with the ability to set a custom HTTPClient for a request.
func NewSetRoleAssignmentsParamsWithHTTPClient(client *http.Client) *SetRoleAssignmentsParams {
	return &SetRoleAssignmentsParams{
		HTTPClient: client,
	}
}

/*
SetRoleAssignmentsParams contains all the parameters to send to the API endpoint

	for the set role assignments operation.

	Typically these are written to a http.Request.
*/
type SetRoleAssignmentsParams struct {

	// Body.
	Body *models.SetRoleAssignmentsCommand

	// RoleUID.
	RoleUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the set role assignments params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetRoleAssignmentsParams) WithDefaults() *SetRoleAssignmentsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the set role assignments params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetRoleAssignmentsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the set role assignments params
func (o *SetRoleAssignmentsParams) WithTimeout(timeout time.Duration) *SetRoleAssignmentsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the set role assignments params
func (o *SetRoleAssignmentsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the set role assignments params
func (o *SetRoleAssignmentsParams) WithContext(ctx context.Context) *SetRoleAssignmentsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the set role assignments params
func (o *SetRoleAssignmentsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the set role assignments params
func (o *SetRoleAssignmentsParams) WithHTTPClient(client *http.Client) *SetRoleAssignmentsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the set role assignments params
func (o *SetRoleAssignmentsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the set role assignments params
func (o *SetRoleAssignmentsParams) WithBody(body *models.SetRoleAssignmentsCommand) *SetRoleAssignmentsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the set role assignments params
func (o *SetRoleAssignmentsParams) SetBody(body *models.SetRoleAssignmentsCommand) {
	o.Body = body
}

// WithRoleUID adds the roleUID to the set role assignments params
func (o *SetRoleAssignmentsParams) WithRoleUID(roleUID string) *SetRoleAssignmentsParams {
	o.SetRoleUID(roleUID)
	return o
}

// SetRoleUID adds the roleUid to the set role assignments params
func (o *SetRoleAssignmentsParams) SetRoleUID(roleUID string) {
	o.RoleUID = roleUID
}

// WriteToRequest writes these params to a swagger request
func (o *SetRoleAssignmentsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param roleUID
	if err := r.SetPathParam("roleUID", o.RoleUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
