// Code generated by go-swagger; DO NOT EDIT.

package correlations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteCorrelationReader is a Reader for the DeleteCorrelation structure.
type DeleteCorrelationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteCorrelationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteCorrelationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeleteCorrelationUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteCorrelationForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteCorrelationNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteCorrelationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}] deleteCorrelation", response, response.Code())
	}
}

// NewDeleteCorrelationOK creates a DeleteCorrelationOK with default headers values
func NewDeleteCorrelationOK() *DeleteCorrelationOK {
	return &DeleteCorrelationOK{}
}

/*
DeleteCorrelationOK describes a response with status code 200, with default header values.

(empty)
*/
type DeleteCorrelationOK struct {
	Payload *models.DeleteCorrelationResponseBody
}

// IsSuccess returns true when this delete correlation Ok response has a 2xx status code
func (o *DeleteCorrelationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete correlation Ok response has a 3xx status code
func (o *DeleteCorrelationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete correlation Ok response has a 4xx status code
func (o *DeleteCorrelationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete correlation Ok response has a 5xx status code
func (o *DeleteCorrelationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete correlation Ok response a status code equal to that given
func (o *DeleteCorrelationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete correlation Ok response
func (o *DeleteCorrelationOK) Code() int {
	return 200
}

func (o *DeleteCorrelationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationOk %s", 200, payload)
}

func (o *DeleteCorrelationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationOk %s", 200, payload)
}

func (o *DeleteCorrelationOK) GetPayload() *models.DeleteCorrelationResponseBody {
	return o.Payload
}

func (o *DeleteCorrelationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DeleteCorrelationResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCorrelationUnauthorized creates a DeleteCorrelationUnauthorized with default headers values
func NewDeleteCorrelationUnauthorized() *DeleteCorrelationUnauthorized {
	return &DeleteCorrelationUnauthorized{}
}

/*
DeleteCorrelationUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteCorrelationUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete correlation unauthorized response has a 2xx status code
func (o *DeleteCorrelationUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete correlation unauthorized response has a 3xx status code
func (o *DeleteCorrelationUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete correlation unauthorized response has a 4xx status code
func (o *DeleteCorrelationUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete correlation unauthorized response has a 5xx status code
func (o *DeleteCorrelationUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete correlation unauthorized response a status code equal to that given
func (o *DeleteCorrelationUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete correlation unauthorized response
func (o *DeleteCorrelationUnauthorized) Code() int {
	return 401
}

func (o *DeleteCorrelationUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationUnauthorized %s", 401, payload)
}

func (o *DeleteCorrelationUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationUnauthorized %s", 401, payload)
}

func (o *DeleteCorrelationUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteCorrelationUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCorrelationForbidden creates a DeleteCorrelationForbidden with default headers values
func NewDeleteCorrelationForbidden() *DeleteCorrelationForbidden {
	return &DeleteCorrelationForbidden{}
}

/*
DeleteCorrelationForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteCorrelationForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete correlation forbidden response has a 2xx status code
func (o *DeleteCorrelationForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete correlation forbidden response has a 3xx status code
func (o *DeleteCorrelationForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete correlation forbidden response has a 4xx status code
func (o *DeleteCorrelationForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete correlation forbidden response has a 5xx status code
func (o *DeleteCorrelationForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete correlation forbidden response a status code equal to that given
func (o *DeleteCorrelationForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete correlation forbidden response
func (o *DeleteCorrelationForbidden) Code() int {
	return 403
}

func (o *DeleteCorrelationForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationForbidden %s", 403, payload)
}

func (o *DeleteCorrelationForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationForbidden %s", 403, payload)
}

func (o *DeleteCorrelationForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteCorrelationForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCorrelationNotFound creates a DeleteCorrelationNotFound with default headers values
func NewDeleteCorrelationNotFound() *DeleteCorrelationNotFound {
	return &DeleteCorrelationNotFound{}
}

/*
DeleteCorrelationNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteCorrelationNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete correlation not found response has a 2xx status code
func (o *DeleteCorrelationNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete correlation not found response has a 3xx status code
func (o *DeleteCorrelationNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete correlation not found response has a 4xx status code
func (o *DeleteCorrelationNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete correlation not found response has a 5xx status code
func (o *DeleteCorrelationNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete correlation not found response a status code equal to that given
func (o *DeleteCorrelationNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete correlation not found response
func (o *DeleteCorrelationNotFound) Code() int {
	return 404
}

func (o *DeleteCorrelationNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationNotFound %s", 404, payload)
}

func (o *DeleteCorrelationNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationNotFound %s", 404, payload)
}

func (o *DeleteCorrelationNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteCorrelationNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteCorrelationInternalServerError creates a DeleteCorrelationInternalServerError with default headers values
func NewDeleteCorrelationInternalServerError() *DeleteCorrelationInternalServerError {
	return &DeleteCorrelationInternalServerError{}
}

/*
DeleteCorrelationInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteCorrelationInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete correlation internal server error response has a 2xx status code
func (o *DeleteCorrelationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete correlation internal server error response has a 3xx status code
func (o *DeleteCorrelationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete correlation internal server error response has a 4xx status code
func (o *DeleteCorrelationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete correlation internal server error response has a 5xx status code
func (o *DeleteCorrelationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete correlation internal server error response a status code equal to that given
func (o *DeleteCorrelationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete correlation internal server error response
func (o *DeleteCorrelationInternalServerError) Code() int {
	return 500
}

func (o *DeleteCorrelationInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationInternalServerError %s", 500, payload)
}

func (o *DeleteCorrelationInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/uid/{uid}/correlations/{correlationUID}][%d] deleteCorrelationInternalServerError %s", 500, payload)
}

func (o *DeleteCorrelationInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteCorrelationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
