// Code generated by go-swagger; DO NOT EDIT.

package dashboards

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PostDashboardReader is a Reader for the PostDashboard structure.
type PostDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPostDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPostDashboardBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewPostDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPostDashboardForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewPostDashboardNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 412:
		result := NewPostDashboardPreconditionFailed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewPostDashboardUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPostDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /dashboards/db] postDashboard", response, response.Code())
	}
}

// NewPostDashboardOK creates a PostDashboardOK with default headers values
func NewPostDashboardOK() *PostDashboardOK {
	return &PostDashboardOK{}
}

/*
PostDashboardOK describes a response with status code 200, with default header values.

(empty)
*/
type PostDashboardOK struct {
	Payload *models.PostDashboardOKBody
}

// IsSuccess returns true when this post dashboard Ok response has a 2xx status code
func (o *PostDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this post dashboard Ok response has a 3xx status code
func (o *PostDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard Ok response has a 4xx status code
func (o *PostDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this post dashboard Ok response has a 5xx status code
func (o *PostDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this post dashboard Ok response a status code equal to that given
func (o *PostDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the post dashboard Ok response
func (o *PostDashboardOK) Code() int {
	return 200
}

func (o *PostDashboardOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardOk %s", 200, payload)
}

func (o *PostDashboardOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardOk %s", 200, payload)
}

func (o *PostDashboardOK) GetPayload() *models.PostDashboardOKBody {
	return o.Payload
}

func (o *PostDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PostDashboardOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostDashboardBadRequest creates a PostDashboardBadRequest with default headers values
func NewPostDashboardBadRequest() *PostDashboardBadRequest {
	return &PostDashboardBadRequest{}
}

/*
PostDashboardBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type PostDashboardBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post dashboard bad request response has a 2xx status code
func (o *PostDashboardBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post dashboard bad request response has a 3xx status code
func (o *PostDashboardBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard bad request response has a 4xx status code
func (o *PostDashboardBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this post dashboard bad request response has a 5xx status code
func (o *PostDashboardBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this post dashboard bad request response a status code equal to that given
func (o *PostDashboardBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the post dashboard bad request response
func (o *PostDashboardBadRequest) Code() int {
	return 400
}

func (o *PostDashboardBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardBadRequest %s", 400, payload)
}

func (o *PostDashboardBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardBadRequest %s", 400, payload)
}

func (o *PostDashboardBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostDashboardBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostDashboardUnauthorized creates a PostDashboardUnauthorized with default headers values
func NewPostDashboardUnauthorized() *PostDashboardUnauthorized {
	return &PostDashboardUnauthorized{}
}

/*
PostDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type PostDashboardUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post dashboard unauthorized response has a 2xx status code
func (o *PostDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post dashboard unauthorized response has a 3xx status code
func (o *PostDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard unauthorized response has a 4xx status code
func (o *PostDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this post dashboard unauthorized response has a 5xx status code
func (o *PostDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this post dashboard unauthorized response a status code equal to that given
func (o *PostDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the post dashboard unauthorized response
func (o *PostDashboardUnauthorized) Code() int {
	return 401
}

func (o *PostDashboardUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardUnauthorized %s", 401, payload)
}

func (o *PostDashboardUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardUnauthorized %s", 401, payload)
}

func (o *PostDashboardUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostDashboardForbidden creates a PostDashboardForbidden with default headers values
func NewPostDashboardForbidden() *PostDashboardForbidden {
	return &PostDashboardForbidden{}
}

/*
PostDashboardForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type PostDashboardForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post dashboard forbidden response has a 2xx status code
func (o *PostDashboardForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post dashboard forbidden response has a 3xx status code
func (o *PostDashboardForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard forbidden response has a 4xx status code
func (o *PostDashboardForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this post dashboard forbidden response has a 5xx status code
func (o *PostDashboardForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this post dashboard forbidden response a status code equal to that given
func (o *PostDashboardForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the post dashboard forbidden response
func (o *PostDashboardForbidden) Code() int {
	return 403
}

func (o *PostDashboardForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardForbidden %s", 403, payload)
}

func (o *PostDashboardForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardForbidden %s", 403, payload)
}

func (o *PostDashboardForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostDashboardForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostDashboardNotFound creates a PostDashboardNotFound with default headers values
func NewPostDashboardNotFound() *PostDashboardNotFound {
	return &PostDashboardNotFound{}
}

/*
PostDashboardNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type PostDashboardNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post dashboard not found response has a 2xx status code
func (o *PostDashboardNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post dashboard not found response has a 3xx status code
func (o *PostDashboardNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard not found response has a 4xx status code
func (o *PostDashboardNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this post dashboard not found response has a 5xx status code
func (o *PostDashboardNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this post dashboard not found response a status code equal to that given
func (o *PostDashboardNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the post dashboard not found response
func (o *PostDashboardNotFound) Code() int {
	return 404
}

func (o *PostDashboardNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardNotFound %s", 404, payload)
}

func (o *PostDashboardNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardNotFound %s", 404, payload)
}

func (o *PostDashboardNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostDashboardNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostDashboardPreconditionFailed creates a PostDashboardPreconditionFailed with default headers values
func NewPostDashboardPreconditionFailed() *PostDashboardPreconditionFailed {
	return &PostDashboardPreconditionFailed{}
}

/*
PostDashboardPreconditionFailed describes a response with status code 412, with default header values.

PreconditionFailedError
*/
type PostDashboardPreconditionFailed struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post dashboard precondition failed response has a 2xx status code
func (o *PostDashboardPreconditionFailed) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post dashboard precondition failed response has a 3xx status code
func (o *PostDashboardPreconditionFailed) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard precondition failed response has a 4xx status code
func (o *PostDashboardPreconditionFailed) IsClientError() bool {
	return true
}

// IsServerError returns true when this post dashboard precondition failed response has a 5xx status code
func (o *PostDashboardPreconditionFailed) IsServerError() bool {
	return false
}

// IsCode returns true when this post dashboard precondition failed response a status code equal to that given
func (o *PostDashboardPreconditionFailed) IsCode(code int) bool {
	return code == 412
}

// Code gets the status code for the post dashboard precondition failed response
func (o *PostDashboardPreconditionFailed) Code() int {
	return 412
}

func (o *PostDashboardPreconditionFailed) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardPreconditionFailed %s", 412, payload)
}

func (o *PostDashboardPreconditionFailed) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardPreconditionFailed %s", 412, payload)
}

func (o *PostDashboardPreconditionFailed) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostDashboardPreconditionFailed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostDashboardUnprocessableEntity creates a PostDashboardUnprocessableEntity with default headers values
func NewPostDashboardUnprocessableEntity() *PostDashboardUnprocessableEntity {
	return &PostDashboardUnprocessableEntity{}
}

/*
PostDashboardUnprocessableEntity describes a response with status code 422, with default header values.

UnprocessableEntityError
*/
type PostDashboardUnprocessableEntity struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post dashboard unprocessable entity response has a 2xx status code
func (o *PostDashboardUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post dashboard unprocessable entity response has a 3xx status code
func (o *PostDashboardUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard unprocessable entity response has a 4xx status code
func (o *PostDashboardUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this post dashboard unprocessable entity response has a 5xx status code
func (o *PostDashboardUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this post dashboard unprocessable entity response a status code equal to that given
func (o *PostDashboardUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the post dashboard unprocessable entity response
func (o *PostDashboardUnprocessableEntity) Code() int {
	return 422
}

func (o *PostDashboardUnprocessableEntity) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardUnprocessableEntity %s", 422, payload)
}

func (o *PostDashboardUnprocessableEntity) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardUnprocessableEntity %s", 422, payload)
}

func (o *PostDashboardUnprocessableEntity) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostDashboardUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostDashboardInternalServerError creates a PostDashboardInternalServerError with default headers values
func NewPostDashboardInternalServerError() *PostDashboardInternalServerError {
	return &PostDashboardInternalServerError{}
}

/*
PostDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type PostDashboardInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post dashboard internal server error response has a 2xx status code
func (o *PostDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post dashboard internal server error response has a 3xx status code
func (o *PostDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post dashboard internal server error response has a 4xx status code
func (o *PostDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this post dashboard internal server error response has a 5xx status code
func (o *PostDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this post dashboard internal server error response a status code equal to that given
func (o *PostDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the post dashboard internal server error response
func (o *PostDashboardInternalServerError) Code() int {
	return 500
}

func (o *PostDashboardInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardInternalServerError %s", 500, payload)
}

func (o *PostDashboardInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /dashboards/db][%d] postDashboardInternalServerError %s", 500, payload)
}

func (o *PostDashboardInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
