// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DatasourceProxyPOSTcallsReader is a Reader for the DatasourceProxyPOSTcalls structure.
type DatasourceProxyPOSTcallsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DatasourceProxyPOSTcallsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewDatasourceProxyPOSTcallsCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewDatasourceProxyPOSTcallsAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDatasourceProxyPOSTcallsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDatasourceProxyPOSTcallsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDatasourceProxyPOSTcallsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDatasourceProxyPOSTcallsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDatasourceProxyPOSTcallsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /datasources/proxy/{id}/{datasource_proxy_route}] datasourceProxyPOSTcalls", response, response.Code())
	}
}

// NewDatasourceProxyPOSTcallsCreated creates a DatasourceProxyPOSTcallsCreated with default headers values
func NewDatasourceProxyPOSTcallsCreated() *DatasourceProxyPOSTcallsCreated {
	return &DatasourceProxyPOSTcallsCreated{}
}

/*
DatasourceProxyPOSTcallsCreated describes a response with status code 201, with default header values.

(empty)
*/
type DatasourceProxyPOSTcallsCreated struct {
}

// IsSuccess returns true when this datasource proxy p o s tcalls created response has a 2xx status code
func (o *DatasourceProxyPOSTcallsCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datasource proxy p o s tcalls created response has a 3xx status code
func (o *DatasourceProxyPOSTcallsCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datasource proxy p o s tcalls created response has a 4xx status code
func (o *DatasourceProxyPOSTcallsCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this datasource proxy p o s tcalls created response has a 5xx status code
func (o *DatasourceProxyPOSTcallsCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this datasource proxy p o s tcalls created response a status code equal to that given
func (o *DatasourceProxyPOSTcallsCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the datasource proxy p o s tcalls created response
func (o *DatasourceProxyPOSTcallsCreated) Code() int {
	return 201
}

func (o *DatasourceProxyPOSTcallsCreated) Error() string {
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsCreated", 201)
}

func (o *DatasourceProxyPOSTcallsCreated) String() string {
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsCreated", 201)
}

func (o *DatasourceProxyPOSTcallsCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDatasourceProxyPOSTcallsAccepted creates a DatasourceProxyPOSTcallsAccepted with default headers values
func NewDatasourceProxyPOSTcallsAccepted() *DatasourceProxyPOSTcallsAccepted {
	return &DatasourceProxyPOSTcallsAccepted{}
}

/*
DatasourceProxyPOSTcallsAccepted describes a response with status code 202, with default header values.

(empty)
*/
type DatasourceProxyPOSTcallsAccepted struct {
}

// IsSuccess returns true when this datasource proxy p o s tcalls accepted response has a 2xx status code
func (o *DatasourceProxyPOSTcallsAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this datasource proxy p o s tcalls accepted response has a 3xx status code
func (o *DatasourceProxyPOSTcallsAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datasource proxy p o s tcalls accepted response has a 4xx status code
func (o *DatasourceProxyPOSTcallsAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this datasource proxy p o s tcalls accepted response has a 5xx status code
func (o *DatasourceProxyPOSTcallsAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this datasource proxy p o s tcalls accepted response a status code equal to that given
func (o *DatasourceProxyPOSTcallsAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the datasource proxy p o s tcalls accepted response
func (o *DatasourceProxyPOSTcallsAccepted) Code() int {
	return 202
}

func (o *DatasourceProxyPOSTcallsAccepted) Error() string {
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsAccepted", 202)
}

func (o *DatasourceProxyPOSTcallsAccepted) String() string {
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsAccepted", 202)
}

func (o *DatasourceProxyPOSTcallsAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDatasourceProxyPOSTcallsBadRequest creates a DatasourceProxyPOSTcallsBadRequest with default headers values
func NewDatasourceProxyPOSTcallsBadRequest() *DatasourceProxyPOSTcallsBadRequest {
	return &DatasourceProxyPOSTcallsBadRequest{}
}

/*
DatasourceProxyPOSTcallsBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DatasourceProxyPOSTcallsBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this datasource proxy p o s tcalls bad request response has a 2xx status code
func (o *DatasourceProxyPOSTcallsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this datasource proxy p o s tcalls bad request response has a 3xx status code
func (o *DatasourceProxyPOSTcallsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datasource proxy p o s tcalls bad request response has a 4xx status code
func (o *DatasourceProxyPOSTcallsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this datasource proxy p o s tcalls bad request response has a 5xx status code
func (o *DatasourceProxyPOSTcallsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this datasource proxy p o s tcalls bad request response a status code equal to that given
func (o *DatasourceProxyPOSTcallsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the datasource proxy p o s tcalls bad request response
func (o *DatasourceProxyPOSTcallsBadRequest) Code() int {
	return 400
}

func (o *DatasourceProxyPOSTcallsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsBadRequest %s", 400, payload)
}

func (o *DatasourceProxyPOSTcallsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsBadRequest %s", 400, payload)
}

func (o *DatasourceProxyPOSTcallsBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DatasourceProxyPOSTcallsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatasourceProxyPOSTcallsUnauthorized creates a DatasourceProxyPOSTcallsUnauthorized with default headers values
func NewDatasourceProxyPOSTcallsUnauthorized() *DatasourceProxyPOSTcallsUnauthorized {
	return &DatasourceProxyPOSTcallsUnauthorized{}
}

/*
DatasourceProxyPOSTcallsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DatasourceProxyPOSTcallsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this datasource proxy p o s tcalls unauthorized response has a 2xx status code
func (o *DatasourceProxyPOSTcallsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this datasource proxy p o s tcalls unauthorized response has a 3xx status code
func (o *DatasourceProxyPOSTcallsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datasource proxy p o s tcalls unauthorized response has a 4xx status code
func (o *DatasourceProxyPOSTcallsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this datasource proxy p o s tcalls unauthorized response has a 5xx status code
func (o *DatasourceProxyPOSTcallsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this datasource proxy p o s tcalls unauthorized response a status code equal to that given
func (o *DatasourceProxyPOSTcallsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the datasource proxy p o s tcalls unauthorized response
func (o *DatasourceProxyPOSTcallsUnauthorized) Code() int {
	return 401
}

func (o *DatasourceProxyPOSTcallsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsUnauthorized %s", 401, payload)
}

func (o *DatasourceProxyPOSTcallsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsUnauthorized %s", 401, payload)
}

func (o *DatasourceProxyPOSTcallsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DatasourceProxyPOSTcallsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatasourceProxyPOSTcallsForbidden creates a DatasourceProxyPOSTcallsForbidden with default headers values
func NewDatasourceProxyPOSTcallsForbidden() *DatasourceProxyPOSTcallsForbidden {
	return &DatasourceProxyPOSTcallsForbidden{}
}

/*
DatasourceProxyPOSTcallsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DatasourceProxyPOSTcallsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this datasource proxy p o s tcalls forbidden response has a 2xx status code
func (o *DatasourceProxyPOSTcallsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this datasource proxy p o s tcalls forbidden response has a 3xx status code
func (o *DatasourceProxyPOSTcallsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datasource proxy p o s tcalls forbidden response has a 4xx status code
func (o *DatasourceProxyPOSTcallsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this datasource proxy p o s tcalls forbidden response has a 5xx status code
func (o *DatasourceProxyPOSTcallsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this datasource proxy p o s tcalls forbidden response a status code equal to that given
func (o *DatasourceProxyPOSTcallsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the datasource proxy p o s tcalls forbidden response
func (o *DatasourceProxyPOSTcallsForbidden) Code() int {
	return 403
}

func (o *DatasourceProxyPOSTcallsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsForbidden %s", 403, payload)
}

func (o *DatasourceProxyPOSTcallsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsForbidden %s", 403, payload)
}

func (o *DatasourceProxyPOSTcallsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DatasourceProxyPOSTcallsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatasourceProxyPOSTcallsNotFound creates a DatasourceProxyPOSTcallsNotFound with default headers values
func NewDatasourceProxyPOSTcallsNotFound() *DatasourceProxyPOSTcallsNotFound {
	return &DatasourceProxyPOSTcallsNotFound{}
}

/*
DatasourceProxyPOSTcallsNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DatasourceProxyPOSTcallsNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this datasource proxy p o s tcalls not found response has a 2xx status code
func (o *DatasourceProxyPOSTcallsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this datasource proxy p o s tcalls not found response has a 3xx status code
func (o *DatasourceProxyPOSTcallsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datasource proxy p o s tcalls not found response has a 4xx status code
func (o *DatasourceProxyPOSTcallsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this datasource proxy p o s tcalls not found response has a 5xx status code
func (o *DatasourceProxyPOSTcallsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this datasource proxy p o s tcalls not found response a status code equal to that given
func (o *DatasourceProxyPOSTcallsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the datasource proxy p o s tcalls not found response
func (o *DatasourceProxyPOSTcallsNotFound) Code() int {
	return 404
}

func (o *DatasourceProxyPOSTcallsNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsNotFound %s", 404, payload)
}

func (o *DatasourceProxyPOSTcallsNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsNotFound %s", 404, payload)
}

func (o *DatasourceProxyPOSTcallsNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DatasourceProxyPOSTcallsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDatasourceProxyPOSTcallsInternalServerError creates a DatasourceProxyPOSTcallsInternalServerError with default headers values
func NewDatasourceProxyPOSTcallsInternalServerError() *DatasourceProxyPOSTcallsInternalServerError {
	return &DatasourceProxyPOSTcallsInternalServerError{}
}

/*
DatasourceProxyPOSTcallsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DatasourceProxyPOSTcallsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this datasource proxy p o s tcalls internal server error response has a 2xx status code
func (o *DatasourceProxyPOSTcallsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this datasource proxy p o s tcalls internal server error response has a 3xx status code
func (o *DatasourceProxyPOSTcallsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this datasource proxy p o s tcalls internal server error response has a 4xx status code
func (o *DatasourceProxyPOSTcallsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this datasource proxy p o s tcalls internal server error response has a 5xx status code
func (o *DatasourceProxyPOSTcallsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this datasource proxy p o s tcalls internal server error response a status code equal to that given
func (o *DatasourceProxyPOSTcallsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the datasource proxy p o s tcalls internal server error response
func (o *DatasourceProxyPOSTcallsInternalServerError) Code() int {
	return 500
}

func (o *DatasourceProxyPOSTcallsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsInternalServerError %s", 500, payload)
}

func (o *DatasourceProxyPOSTcallsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/proxy/{id}/{datasource_proxy_route}][%d] datasourceProxyPOSTcallsInternalServerError %s", 500, payload)
}

func (o *DatasourceProxyPOSTcallsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DatasourceProxyPOSTcallsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
