// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetShapshotListParams creates a new GetShapshotListParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetShapshotListParams() *GetShapshotListParams {
	return &GetShapshotListParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetShapshotListParamsWithTimeout creates a new GetShapshotListParams object
// with the ability to set a timeout on a request.
func NewGetShapshotListParamsWithTimeout(timeout time.Duration) *GetShapshotListParams {
	return &GetShapshotListParams{
		timeout: timeout,
	}
}

// NewGetShapshotListParamsWithContext creates a new GetShapshotListParams object
// with the ability to set a context for a request.
func NewGetShapshotListParamsWithContext(ctx context.Context) *GetShapshotListParams {
	return &GetShapshotListParams{
		Context: ctx,
	}
}

// NewGetShapshotListParamsWithHTTPClient creates a new GetShapshotListParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetShapshotListParamsWithHTTPClient(client *http.Client) *GetShapshotListParams {
	return &GetShapshotListParams{
		HTTPClient: client,
	}
}

/*
GetShapshotListParams contains all the parameters to send to the API endpoint

	for the get shapshot list operation.

	Typically these are written to a http.Request.
*/
type GetShapshotListParams struct {

	/* Limit.

	   Max limit for results returned.

	   Format: int64
	   Default: 100
	*/
	Limit *int64

	/* Page.

	   Page is used for pagination with limit

	   Format: int64
	   Default: 1
	*/
	Page *int64

	/* Sort.

	   Sort with value latest to return results sorted in descending order.
	*/
	Sort *string

	/* UID.

	   Session UID of a session
	*/
	UID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get shapshot list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetShapshotListParams) WithDefaults() *GetShapshotListParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get shapshot list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetShapshotListParams) SetDefaults() {
	var (
		limitDefault = int64(100)

		pageDefault = int64(1)
	)

	val := GetShapshotListParams{
		Limit: &limitDefault,
		Page:  &pageDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get shapshot list params
func (o *GetShapshotListParams) WithTimeout(timeout time.Duration) *GetShapshotListParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get shapshot list params
func (o *GetShapshotListParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get shapshot list params
func (o *GetShapshotListParams) WithContext(ctx context.Context) *GetShapshotListParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get shapshot list params
func (o *GetShapshotListParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get shapshot list params
func (o *GetShapshotListParams) WithHTTPClient(client *http.Client) *GetShapshotListParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get shapshot list params
func (o *GetShapshotListParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the get shapshot list params
func (o *GetShapshotListParams) WithLimit(limit *int64) *GetShapshotListParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get shapshot list params
func (o *GetShapshotListParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithPage adds the page to the get shapshot list params
func (o *GetShapshotListParams) WithPage(page *int64) *GetShapshotListParams {
	o.SetPage(page)
	return o
}

// SetPage adds the page to the get shapshot list params
func (o *GetShapshotListParams) SetPage(page *int64) {
	o.Page = page
}

// WithSort adds the sort to the get shapshot list params
func (o *GetShapshotListParams) WithSort(sort *string) *GetShapshotListParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the get shapshot list params
func (o *GetShapshotListParams) SetSort(sort *string) {
	o.Sort = sort
}

// WithUID adds the uid to the get shapshot list params
func (o *GetShapshotListParams) WithUID(uid string) *GetShapshotListParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the get shapshot list params
func (o *GetShapshotListParams) SetUID(uid string) {
	o.UID = uid
}

// WriteToRequest writes these params to a swagger request
func (o *GetShapshotListParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Page != nil {

		// query param page
		var qrPage int64

		if o.Page != nil {
			qrPage = *o.Page
		}
		qPage := swag.FormatInt64(qrPage)
		if qPage != "" {

			if err := r.SetQueryParam("page", qPage); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	// path param uid
	if err := r.SetPathParam("uid", o.UID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
