// Code generated by go-swagger; DO NOT EDIT.

package playlists

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetPlaylistReader is a Reader for the GetPlaylist structure.
type GetPlaylistReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetPlaylistReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetPlaylistOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetPlaylistUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetPlaylistForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetPlaylistNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetPlaylistInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /playlists/{uid}] getPlaylist", response, response.Code())
	}
}

// NewGetPlaylistOK creates a GetPlaylistOK with default headers values
func NewGetPlaylistOK() *GetPlaylistOK {
	return &GetPlaylistOK{}
}

/*
GetPlaylistOK describes a response with status code 200, with default header values.

(empty)
*/
type GetPlaylistOK struct {
	Payload *models.Playlist
}

// IsSuccess returns true when this get playlist Ok response has a 2xx status code
func (o *GetPlaylistOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get playlist Ok response has a 3xx status code
func (o *GetPlaylistOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist Ok response has a 4xx status code
func (o *GetPlaylistOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get playlist Ok response has a 5xx status code
func (o *GetPlaylistOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist Ok response a status code equal to that given
func (o *GetPlaylistOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get playlist Ok response
func (o *GetPlaylistOK) Code() int {
	return 200
}

func (o *GetPlaylistOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistOk %s", 200, payload)
}

func (o *GetPlaylistOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistOk %s", 200, payload)
}

func (o *GetPlaylistOK) GetPayload() *models.Playlist {
	return o.Payload
}

func (o *GetPlaylistOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Playlist)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistUnauthorized creates a GetPlaylistUnauthorized with default headers values
func NewGetPlaylistUnauthorized() *GetPlaylistUnauthorized {
	return &GetPlaylistUnauthorized{}
}

/*
GetPlaylistUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetPlaylistUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist unauthorized response has a 2xx status code
func (o *GetPlaylistUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist unauthorized response has a 3xx status code
func (o *GetPlaylistUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist unauthorized response has a 4xx status code
func (o *GetPlaylistUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get playlist unauthorized response has a 5xx status code
func (o *GetPlaylistUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist unauthorized response a status code equal to that given
func (o *GetPlaylistUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get playlist unauthorized response
func (o *GetPlaylistUnauthorized) Code() int {
	return 401
}

func (o *GetPlaylistUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistUnauthorized %s", 401, payload)
}

func (o *GetPlaylistUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistUnauthorized %s", 401, payload)
}

func (o *GetPlaylistUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistForbidden creates a GetPlaylistForbidden with default headers values
func NewGetPlaylistForbidden() *GetPlaylistForbidden {
	return &GetPlaylistForbidden{}
}

/*
GetPlaylistForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetPlaylistForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist forbidden response has a 2xx status code
func (o *GetPlaylistForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist forbidden response has a 3xx status code
func (o *GetPlaylistForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist forbidden response has a 4xx status code
func (o *GetPlaylistForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get playlist forbidden response has a 5xx status code
func (o *GetPlaylistForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist forbidden response a status code equal to that given
func (o *GetPlaylistForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get playlist forbidden response
func (o *GetPlaylistForbidden) Code() int {
	return 403
}

func (o *GetPlaylistForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistForbidden %s", 403, payload)
}

func (o *GetPlaylistForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistForbidden %s", 403, payload)
}

func (o *GetPlaylistForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistNotFound creates a GetPlaylistNotFound with default headers values
func NewGetPlaylistNotFound() *GetPlaylistNotFound {
	return &GetPlaylistNotFound{}
}

/*
GetPlaylistNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetPlaylistNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist not found response has a 2xx status code
func (o *GetPlaylistNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist not found response has a 3xx status code
func (o *GetPlaylistNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist not found response has a 4xx status code
func (o *GetPlaylistNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get playlist not found response has a 5xx status code
func (o *GetPlaylistNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist not found response a status code equal to that given
func (o *GetPlaylistNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get playlist not found response
func (o *GetPlaylistNotFound) Code() int {
	return 404
}

func (o *GetPlaylistNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistNotFound %s", 404, payload)
}

func (o *GetPlaylistNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistNotFound %s", 404, payload)
}

func (o *GetPlaylistNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistInternalServerError creates a GetPlaylistInternalServerError with default headers values
func NewGetPlaylistInternalServerError() *GetPlaylistInternalServerError {
	return &GetPlaylistInternalServerError{}
}

/*
GetPlaylistInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetPlaylistInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist internal server error response has a 2xx status code
func (o *GetPlaylistInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist internal server error response has a 3xx status code
func (o *GetPlaylistInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist internal server error response has a 4xx status code
func (o *GetPlaylistInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get playlist internal server error response has a 5xx status code
func (o *GetPlaylistInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get playlist internal server error response a status code equal to that given
func (o *GetPlaylistInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get playlist internal server error response
func (o *GetPlaylistInternalServerError) Code() int {
	return 500
}

func (o *GetPlaylistInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistInternalServerError %s", 500, payload)
}

func (o *GetPlaylistInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}][%d] getPlaylistInternalServerError %s", 500, payload)
}

func (o *GetPlaylistInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
