// Code generated by go-swagger; DO NOT EDIT.

package playlists

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewUpdatePlaylistParams creates a new UpdatePlaylistParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdatePlaylistParams() *UpdatePlaylistParams {
	return &UpdatePlaylistParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdatePlaylistParamsWithTimeout creates a new UpdatePlaylistParams object
// with the ability to set a timeout on a request.
func NewUpdatePlaylistParamsWithTimeout(timeout time.Duration) *UpdatePlaylistParams {
	return &UpdatePlaylistParams{
		timeout: timeout,
	}
}

// NewUpdatePlaylistParamsWithContext creates a new UpdatePlaylistParams object
// with the ability to set a context for a request.
func NewUpdatePlaylistParamsWithContext(ctx context.Context) *UpdatePlaylistParams {
	return &UpdatePlaylistParams{
		Context: ctx,
	}
}

// NewUpdatePlaylistParamsWithHTTPClient creates a new UpdatePlaylistParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdatePlaylistParamsWithHTTPClient(client *http.Client) *UpdatePlaylistParams {
	return &UpdatePlaylistParams{
		HTTPClient: client,
	}
}

/*
UpdatePlaylistParams contains all the parameters to send to the API endpoint

	for the update playlist operation.

	Typically these are written to a http.Request.
*/
type UpdatePlaylistParams struct {

	// Body.
	Body *models.UpdatePlaylistCommand

	// UID.
	UID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update playlist params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdatePlaylistParams) WithDefaults() *UpdatePlaylistParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update playlist params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdatePlaylistParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update playlist params
func (o *UpdatePlaylistParams) WithTimeout(timeout time.Duration) *UpdatePlaylistParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update playlist params
func (o *UpdatePlaylistParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update playlist params
func (o *UpdatePlaylistParams) WithContext(ctx context.Context) *UpdatePlaylistParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update playlist params
func (o *UpdatePlaylistParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update playlist params
func (o *UpdatePlaylistParams) WithHTTPClient(client *http.Client) *UpdatePlaylistParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update playlist params
func (o *UpdatePlaylistParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update playlist params
func (o *UpdatePlaylistParams) WithBody(body *models.UpdatePlaylistCommand) *UpdatePlaylistParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update playlist params
func (o *UpdatePlaylistParams) SetBody(body *models.UpdatePlaylistCommand) {
	o.Body = body
}

// WithUID adds the uid to the update playlist params
func (o *UpdatePlaylistParams) WithUID(uid string) *UpdatePlaylistParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the update playlist params
func (o *UpdatePlaylistParams) SetUID(uid string) {
	o.UID = uid
}

// WriteToRequest writes these params to a swagger request
func (o *UpdatePlaylistParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param uid
	if err := r.SetPathParam("uid", o.UID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
