// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new provisioning API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for provisioning API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	DeleteAlertRule(params *DeleteAlertRuleParams, opts ...ClientOption) (*DeleteAlertRuleNoContent, error)

	DeleteAlertRuleGroup(group string, folderUID string, opts ...ClientOption) (*DeleteAlertRuleGroupNoContent, error)
	DeleteAlertRuleGroupWithParams(params *DeleteAlertRuleGroupParams, opts ...ClientOption) (*DeleteAlertRuleGroupNoContent, error)

	DeleteContactpoints(uid string, opts ...ClientOption) (*DeleteContactpointsAccepted, error)
	DeleteContactpointsWithParams(params *DeleteContactpointsParams, opts ...ClientOption) (*DeleteContactpointsAccepted, error)

	DeleteMuteTiming(params *DeleteMuteTimingParams, opts ...ClientOption) (*DeleteMuteTimingNoContent, error)

	DeleteTemplate(params *DeleteTemplateParams, opts ...ClientOption) (*DeleteTemplateNoContent, error)

	ExportMuteTiming(params *ExportMuteTimingParams, opts ...ClientOption) (*ExportMuteTimingOK, error)

	ExportMuteTimings(params *ExportMuteTimingsParams, opts ...ClientOption) (*ExportMuteTimingsOK, error)

	GetAlertRule(uid string, opts ...ClientOption) (*GetAlertRuleOK, error)
	GetAlertRuleWithParams(params *GetAlertRuleParams, opts ...ClientOption) (*GetAlertRuleOK, error)

	GetAlertRuleExport(params *GetAlertRuleExportParams, opts ...ClientOption) (*GetAlertRuleExportOK, error)

	GetAlertRuleGroup(group string, folderUID string, opts ...ClientOption) (*GetAlertRuleGroupOK, error)
	GetAlertRuleGroupWithParams(params *GetAlertRuleGroupParams, opts ...ClientOption) (*GetAlertRuleGroupOK, error)

	GetAlertRuleGroupExport(params *GetAlertRuleGroupExportParams, opts ...ClientOption) (*GetAlertRuleGroupExportOK, error)

	GetAlertRules(opts ...ClientOption) (*GetAlertRulesOK, error)
	GetAlertRulesWithParams(params *GetAlertRulesParams, opts ...ClientOption) (*GetAlertRulesOK, error)

	GetAlertRulesExport(params *GetAlertRulesExportParams, opts ...ClientOption) (*GetAlertRulesExportOK, error)

	GetContactpoints(params *GetContactpointsParams, opts ...ClientOption) (*GetContactpointsOK, error)

	GetContactpointsExport(params *GetContactpointsExportParams, opts ...ClientOption) (*GetContactpointsExportOK, error)

	GetMuteTiming(name string, opts ...ClientOption) (*GetMuteTimingOK, error)
	GetMuteTimingWithParams(params *GetMuteTimingParams, opts ...ClientOption) (*GetMuteTimingOK, error)

	GetMuteTimings(opts ...ClientOption) (*GetMuteTimingsOK, error)
	GetMuteTimingsWithParams(params *GetMuteTimingsParams, opts ...ClientOption) (*GetMuteTimingsOK, error)

	GetPolicyTree(opts ...ClientOption) (*GetPolicyTreeOK, error)
	GetPolicyTreeWithParams(params *GetPolicyTreeParams, opts ...ClientOption) (*GetPolicyTreeOK, error)

	GetPolicyTreeExport(opts ...ClientOption) (*GetPolicyTreeExportOK, error)
	GetPolicyTreeExportWithParams(params *GetPolicyTreeExportParams, opts ...ClientOption) (*GetPolicyTreeExportOK, error)

	GetTemplate(name string, opts ...ClientOption) (*GetTemplateOK, error)
	GetTemplateWithParams(params *GetTemplateParams, opts ...ClientOption) (*GetTemplateOK, error)

	GetTemplates(opts ...ClientOption) (*GetTemplatesOK, error)
	GetTemplatesWithParams(params *GetTemplatesParams, opts ...ClientOption) (*GetTemplatesOK, error)

	PostAlertRule(params *PostAlertRuleParams, opts ...ClientOption) (*PostAlertRuleCreated, error)

	PostContactpoints(params *PostContactpointsParams, opts ...ClientOption) (*PostContactpointsAccepted, error)

	PostMuteTiming(params *PostMuteTimingParams, opts ...ClientOption) (*PostMuteTimingCreated, error)

	PutAlertRule(params *PutAlertRuleParams, opts ...ClientOption) (*PutAlertRuleOK, error)

	PutAlertRuleGroup(params *PutAlertRuleGroupParams, opts ...ClientOption) (*PutAlertRuleGroupOK, error)

	PutContactpoint(params *PutContactpointParams, opts ...ClientOption) (*PutContactpointAccepted, error)

	PutMuteTiming(params *PutMuteTimingParams, opts ...ClientOption) (*PutMuteTimingAccepted, error)

	PutPolicyTree(params *PutPolicyTreeParams, opts ...ClientOption) (*PutPolicyTreeAccepted, error)

	PutTemplate(params *PutTemplateParams, opts ...ClientOption) (*PutTemplateAccepted, error)

	ResetPolicyTree(opts ...ClientOption) (*ResetPolicyTreeAccepted, error)
	ResetPolicyTreeWithParams(params *ResetPolicyTreeParams, opts ...ClientOption) (*ResetPolicyTreeAccepted, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
DeleteAlertRule deletes a specific alert rule by UID
*/

func (a *Client) DeleteAlertRule(params *DeleteAlertRuleParams, opts ...ClientOption) (*DeleteAlertRuleNoContent, error) {
	if params == nil {
		params = NewDeleteAlertRuleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAlertRule",
		Method:             "DELETE",
		PathPattern:        "/v1/provisioning/alert-rules/{UID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteAlertRuleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAlertRuleNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteAlertRule: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteAlertRuleGroup Delete rule group
*/
func (a *Client) DeleteAlertRuleGroup(group string, folderUID string, opts ...ClientOption) (*DeleteAlertRuleGroupNoContent, error) {
	params := NewDeleteAlertRuleGroupParams().WithFolderUID(folderUID).WithGroup(group)
	return a.DeleteAlertRuleGroupWithParams(params, opts...)
}

func (a *Client) DeleteAlertRuleGroupWithParams(params *DeleteAlertRuleGroupParams, opts ...ClientOption) (*DeleteAlertRuleGroupNoContent, error) {
	if params == nil {
		params = NewDeleteAlertRuleGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAlertRuleGroup",
		Method:             "DELETE",
		PathPattern:        "/v1/provisioning/folder/{FolderUID}/rule-groups/{Group}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteAlertRuleGroupReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAlertRuleGroupNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteAlertRuleGroup: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteContactpoints deletes a contact point
*/
func (a *Client) DeleteContactpoints(uid string, opts ...ClientOption) (*DeleteContactpointsAccepted, error) {
	params := NewDeleteContactpointsParams().WithUID(uid)
	return a.DeleteContactpointsWithParams(params, opts...)
}

func (a *Client) DeleteContactpointsWithParams(params *DeleteContactpointsParams, opts ...ClientOption) (*DeleteContactpointsAccepted, error) {
	if params == nil {
		params = NewDeleteContactpointsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteContactpoints",
		Method:             "DELETE",
		PathPattern:        "/v1/provisioning/contact-points/{UID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteContactpointsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteContactpointsAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteContactpoints: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteMuteTiming deletes a mute timing
*/

func (a *Client) DeleteMuteTiming(params *DeleteMuteTimingParams, opts ...ClientOption) (*DeleteMuteTimingNoContent, error) {
	if params == nil {
		params = NewDeleteMuteTimingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteMuteTiming",
		Method:             "DELETE",
		PathPattern:        "/v1/provisioning/mute-timings/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteMuteTimingReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteMuteTimingNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteMuteTiming: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteTemplate deletes a template
*/

func (a *Client) DeleteTemplate(params *DeleteTemplateParams, opts ...ClientOption) (*DeleteTemplateNoContent, error) {
	if params == nil {
		params = NewDeleteTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteTemplate",
		Method:             "DELETE",
		PathPattern:        "/v1/provisioning/templates/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteTemplateReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteTemplateNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteTemplate: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ExportMuteTiming exports a mute timing in provisioning format
*/

func (a *Client) ExportMuteTiming(params *ExportMuteTimingParams, opts ...ClientOption) (*ExportMuteTimingOK, error) {
	if params == nil {
		params = NewExportMuteTimingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ExportMuteTiming",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/mute-timings/{name}/export",
		ProducesMediaTypes: []string{"application/json", "application/terraform+hcl", "application/yaml", "text/hcl", "text/yaml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ExportMuteTimingReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportMuteTimingOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ExportMuteTiming: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ExportMuteTimings exports all mute timings in provisioning format
*/

func (a *Client) ExportMuteTimings(params *ExportMuteTimingsParams, opts ...ClientOption) (*ExportMuteTimingsOK, error) {
	if params == nil {
		params = NewExportMuteTimingsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ExportMuteTimings",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/mute-timings/export",
		ProducesMediaTypes: []string{"application/json", "application/terraform+hcl", "application/yaml", "text/hcl", "text/yaml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ExportMuteTimingsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportMuteTimingsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ExportMuteTimings: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAlertRule gets a specific alert rule by UID
*/
func (a *Client) GetAlertRule(uid string, opts ...ClientOption) (*GetAlertRuleOK, error) {
	params := NewGetAlertRuleParams().WithUID(uid)
	return a.GetAlertRuleWithParams(params, opts...)
}

func (a *Client) GetAlertRuleWithParams(params *GetAlertRuleParams, opts ...ClientOption) (*GetAlertRuleOK, error) {
	if params == nil {
		params = NewGetAlertRuleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAlertRule",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/alert-rules/{UID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetAlertRuleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAlertRuleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAlertRule: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAlertRuleExport exports an alert rule in provisioning file format
*/

func (a *Client) GetAlertRuleExport(params *GetAlertRuleExportParams, opts ...ClientOption) (*GetAlertRuleExportOK, error) {
	if params == nil {
		params = NewGetAlertRuleExportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAlertRuleExport",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/alert-rules/{UID}/export",
		ProducesMediaTypes: []string{"application/json", "application/terraform+hcl", "application/yaml", "text/hcl", "text/yaml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetAlertRuleExportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAlertRuleExportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAlertRuleExport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAlertRuleGroup gets a rule group
*/
func (a *Client) GetAlertRuleGroup(group string, folderUID string, opts ...ClientOption) (*GetAlertRuleGroupOK, error) {
	params := NewGetAlertRuleGroupParams().WithFolderUID(folderUID).WithGroup(group)
	return a.GetAlertRuleGroupWithParams(params, opts...)
}

func (a *Client) GetAlertRuleGroupWithParams(params *GetAlertRuleGroupParams, opts ...ClientOption) (*GetAlertRuleGroupOK, error) {
	if params == nil {
		params = NewGetAlertRuleGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAlertRuleGroup",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/folder/{FolderUID}/rule-groups/{Group}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetAlertRuleGroupReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAlertRuleGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAlertRuleGroup: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAlertRuleGroupExport exports an alert rule group in provisioning file format
*/

func (a *Client) GetAlertRuleGroupExport(params *GetAlertRuleGroupExportParams, opts ...ClientOption) (*GetAlertRuleGroupExportOK, error) {
	if params == nil {
		params = NewGetAlertRuleGroupExportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAlertRuleGroupExport",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/folder/{FolderUID}/rule-groups/{Group}/export",
		ProducesMediaTypes: []string{"application/json", "application/terraform+hcl", "application/yaml", "text/hcl", "text/yaml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetAlertRuleGroupExportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAlertRuleGroupExportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAlertRuleGroupExport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAlertRules gets all the alert rules
*/
func (a *Client) GetAlertRules(opts ...ClientOption) (*GetAlertRulesOK, error) {
	params := NewGetAlertRulesParams()
	return a.GetAlertRulesWithParams(params, opts...)
}

func (a *Client) GetAlertRulesWithParams(params *GetAlertRulesParams, opts ...ClientOption) (*GetAlertRulesOK, error) {
	if params == nil {
		params = NewGetAlertRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAlertRules",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/alert-rules",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetAlertRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAlertRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAlertRules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetAlertRulesExport exports all alert rules in provisioning file format
*/

func (a *Client) GetAlertRulesExport(params *GetAlertRulesExportParams, opts ...ClientOption) (*GetAlertRulesExportOK, error) {
	if params == nil {
		params = NewGetAlertRulesExportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAlertRulesExport",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/alert-rules/export",
		ProducesMediaTypes: []string{"application/json", "application/terraform+hcl", "application/yaml", "text/hcl", "text/yaml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetAlertRulesExportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAlertRulesExportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetAlertRulesExport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetContactpoints gets all the contact points
*/

func (a *Client) GetContactpoints(params *GetContactpointsParams, opts ...ClientOption) (*GetContactpointsOK, error) {
	if params == nil {
		params = NewGetContactpointsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetContactpoints",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/contact-points",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetContactpointsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetContactpointsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetContactpoints: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetContactpointsExport exports all contact points in provisioning file format
*/

func (a *Client) GetContactpointsExport(params *GetContactpointsExportParams, opts ...ClientOption) (*GetContactpointsExportOK, error) {
	if params == nil {
		params = NewGetContactpointsExportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetContactpointsExport",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/contact-points/export",
		ProducesMediaTypes: []string{"application/json", "application/terraform+hcl", "application/yaml", "text/hcl", "text/yaml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetContactpointsExportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetContactpointsExportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetContactpointsExport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetMuteTiming gets a mute timing
*/
func (a *Client) GetMuteTiming(name string, opts ...ClientOption) (*GetMuteTimingOK, error) {
	params := NewGetMuteTimingParams().WithName(name)
	return a.GetMuteTimingWithParams(params, opts...)
}

func (a *Client) GetMuteTimingWithParams(params *GetMuteTimingParams, opts ...ClientOption) (*GetMuteTimingOK, error) {
	if params == nil {
		params = NewGetMuteTimingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetMuteTiming",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/mute-timings/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetMuteTimingReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMuteTimingOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetMuteTiming: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetMuteTimings gets all the mute timings
*/
func (a *Client) GetMuteTimings(opts ...ClientOption) (*GetMuteTimingsOK, error) {
	params := NewGetMuteTimingsParams()
	return a.GetMuteTimingsWithParams(params, opts...)
}

func (a *Client) GetMuteTimingsWithParams(params *GetMuteTimingsParams, opts ...ClientOption) (*GetMuteTimingsOK, error) {
	if params == nil {
		params = NewGetMuteTimingsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetMuteTimings",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/mute-timings",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetMuteTimingsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMuteTimingsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetMuteTimings: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPolicyTree gets the notification policy tree
*/
func (a *Client) GetPolicyTree(opts ...ClientOption) (*GetPolicyTreeOK, error) {
	params := NewGetPolicyTreeParams()
	return a.GetPolicyTreeWithParams(params, opts...)
}

func (a *Client) GetPolicyTreeWithParams(params *GetPolicyTreeParams, opts ...ClientOption) (*GetPolicyTreeOK, error) {
	if params == nil {
		params = NewGetPolicyTreeParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetPolicyTree",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/policies",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPolicyTreeReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPolicyTreeOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetPolicyTree: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPolicyTreeExport exports the notification policy tree in provisioning file format
*/
func (a *Client) GetPolicyTreeExport(opts ...ClientOption) (*GetPolicyTreeExportOK, error) {
	params := NewGetPolicyTreeExportParams()
	return a.GetPolicyTreeExportWithParams(params, opts...)
}

func (a *Client) GetPolicyTreeExportWithParams(params *GetPolicyTreeExportParams, opts ...ClientOption) (*GetPolicyTreeExportOK, error) {
	if params == nil {
		params = NewGetPolicyTreeExportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetPolicyTreeExport",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/policies/export",
		ProducesMediaTypes: []string{"application/json", "application/terraform+hcl", "application/yaml", "text/hcl", "text/yaml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPolicyTreeExportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPolicyTreeExportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetPolicyTreeExport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetTemplate gets a notification template
*/
func (a *Client) GetTemplate(name string, opts ...ClientOption) (*GetTemplateOK, error) {
	params := NewGetTemplateParams().WithName(name)
	return a.GetTemplateWithParams(params, opts...)
}

func (a *Client) GetTemplateWithParams(params *GetTemplateParams, opts ...ClientOption) (*GetTemplateOK, error) {
	if params == nil {
		params = NewGetTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetTemplate",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/templates/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTemplateReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTemplateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetTemplate: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetTemplates gets all notification templates
*/
func (a *Client) GetTemplates(opts ...ClientOption) (*GetTemplatesOK, error) {
	params := NewGetTemplatesParams()
	return a.GetTemplatesWithParams(params, opts...)
}

func (a *Client) GetTemplatesWithParams(params *GetTemplatesParams, opts ...ClientOption) (*GetTemplatesOK, error) {
	if params == nil {
		params = NewGetTemplatesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetTemplates",
		Method:             "GET",
		PathPattern:        "/v1/provisioning/templates",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTemplatesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTemplatesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetTemplates: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PostAlertRule creates a new alert rule
*/

func (a *Client) PostAlertRule(params *PostAlertRuleParams, opts ...ClientOption) (*PostAlertRuleCreated, error) {
	if params == nil {
		params = NewPostAlertRuleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PostAlertRule",
		Method:             "POST",
		PathPattern:        "/v1/provisioning/alert-rules",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostAlertRuleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PostAlertRuleCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PostAlertRule: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PostContactpoints creates a contact point
*/

func (a *Client) PostContactpoints(params *PostContactpointsParams, opts ...ClientOption) (*PostContactpointsAccepted, error) {
	if params == nil {
		params = NewPostContactpointsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PostContactpoints",
		Method:             "POST",
		PathPattern:        "/v1/provisioning/contact-points",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostContactpointsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PostContactpointsAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PostContactpoints: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PostMuteTiming creates a new mute timing
*/

func (a *Client) PostMuteTiming(params *PostMuteTimingParams, opts ...ClientOption) (*PostMuteTimingCreated, error) {
	if params == nil {
		params = NewPostMuteTimingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PostMuteTiming",
		Method:             "POST",
		PathPattern:        "/v1/provisioning/mute-timings",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostMuteTimingReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PostMuteTimingCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PostMuteTiming: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutAlertRule updates an existing alert rule
*/

func (a *Client) PutAlertRule(params *PutAlertRuleParams, opts ...ClientOption) (*PutAlertRuleOK, error) {
	if params == nil {
		params = NewPutAlertRuleParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutAlertRule",
		Method:             "PUT",
		PathPattern:        "/v1/provisioning/alert-rules/{UID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PutAlertRuleReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutAlertRuleOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutAlertRule: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutAlertRuleGroup creates or update alert rule group
*/

func (a *Client) PutAlertRuleGroup(params *PutAlertRuleGroupParams, opts ...ClientOption) (*PutAlertRuleGroupOK, error) {
	if params == nil {
		params = NewPutAlertRuleGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutAlertRuleGroup",
		Method:             "PUT",
		PathPattern:        "/v1/provisioning/folder/{FolderUID}/rule-groups/{Group}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PutAlertRuleGroupReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutAlertRuleGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutAlertRuleGroup: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutContactpoint updates an existing contact point
*/

func (a *Client) PutContactpoint(params *PutContactpointParams, opts ...ClientOption) (*PutContactpointAccepted, error) {
	if params == nil {
		params = NewPutContactpointParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutContactpoint",
		Method:             "PUT",
		PathPattern:        "/v1/provisioning/contact-points/{UID}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PutContactpointReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutContactpointAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutContactpoint: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutMuteTiming replaces an existing mute timing
*/

func (a *Client) PutMuteTiming(params *PutMuteTimingParams, opts ...ClientOption) (*PutMuteTimingAccepted, error) {
	if params == nil {
		params = NewPutMuteTimingParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutMuteTiming",
		Method:             "PUT",
		PathPattern:        "/v1/provisioning/mute-timings/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PutMuteTimingReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutMuteTimingAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutMuteTiming: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutPolicyTree sets the notification policy tree
*/

func (a *Client) PutPolicyTree(params *PutPolicyTreeParams, opts ...ClientOption) (*PutPolicyTreeAccepted, error) {
	if params == nil {
		params = NewPutPolicyTreeParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutPolicyTree",
		Method:             "PUT",
		PathPattern:        "/v1/provisioning/policies",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PutPolicyTreeReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutPolicyTreeAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutPolicyTree: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PutTemplate updates an existing notification template
*/

func (a *Client) PutTemplate(params *PutTemplateParams, opts ...ClientOption) (*PutTemplateAccepted, error) {
	if params == nil {
		params = NewPutTemplateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PutTemplate",
		Method:             "PUT",
		PathPattern:        "/v1/provisioning/templates/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PutTemplateReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PutTemplateAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PutTemplate: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ResetPolicyTree clears the notification policy tree
*/
func (a *Client) ResetPolicyTree(opts ...ClientOption) (*ResetPolicyTreeAccepted, error) {
	params := NewResetPolicyTreeParams()
	return a.ResetPolicyTreeWithParams(params, opts...)
}

func (a *Client) ResetPolicyTreeWithParams(params *ResetPolicyTreeParams, opts ...ClientOption) (*ResetPolicyTreeAccepted, error) {
	if params == nil {
		params = NewResetPolicyTreeParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResetPolicyTree",
		Method:             "DELETE",
		PathPattern:        "/v1/provisioning/policies",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ResetPolicyTreeReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResetPolicyTreeAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ResetPolicyTree: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
