// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PutPolicyTreeReader is a Reader for the PutPolicyTree structure.
type PutPolicyTreeReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PutPolicyTreeReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 202:
		result := NewPutPolicyTreeAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPutPolicyTreeBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /v1/provisioning/policies] PutPolicyTree", response, response.Code())
	}
}

// NewPutPolicyTreeAccepted creates a PutPolicyTreeAccepted with default headers values
func NewPutPolicyTreeAccepted() *PutPolicyTreeAccepted {
	return &PutPolicyTreeAccepted{}
}

/*
PutPolicyTreeAccepted describes a response with status code 202, with default header values.

Ack
*/
type PutPolicyTreeAccepted struct {
	Payload models.Ack
}

// IsSuccess returns true when this put policy tree accepted response has a 2xx status code
func (o *PutPolicyTreeAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put policy tree accepted response has a 3xx status code
func (o *PutPolicyTreeAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put policy tree accepted response has a 4xx status code
func (o *PutPolicyTreeAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this put policy tree accepted response has a 5xx status code
func (o *PutPolicyTreeAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this put policy tree accepted response a status code equal to that given
func (o *PutPolicyTreeAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the put policy tree accepted response
func (o *PutPolicyTreeAccepted) Code() int {
	return 202
}

func (o *PutPolicyTreeAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/policies][%d] putPolicyTreeAccepted %s", 202, payload)
}

func (o *PutPolicyTreeAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/policies][%d] putPolicyTreeAccepted %s", 202, payload)
}

func (o *PutPolicyTreeAccepted) GetPayload() models.Ack {
	return o.Payload
}

func (o *PutPolicyTreeAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutPolicyTreeBadRequest creates a PutPolicyTreeBadRequest with default headers values
func NewPutPolicyTreeBadRequest() *PutPolicyTreeBadRequest {
	return &PutPolicyTreeBadRequest{}
}

/*
PutPolicyTreeBadRequest describes a response with status code 400, with default header values.

ValidationError
*/
type PutPolicyTreeBadRequest struct {
	Payload *models.ValidationError
}

// IsSuccess returns true when this put policy tree bad request response has a 2xx status code
func (o *PutPolicyTreeBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put policy tree bad request response has a 3xx status code
func (o *PutPolicyTreeBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put policy tree bad request response has a 4xx status code
func (o *PutPolicyTreeBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this put policy tree bad request response has a 5xx status code
func (o *PutPolicyTreeBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this put policy tree bad request response a status code equal to that given
func (o *PutPolicyTreeBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the put policy tree bad request response
func (o *PutPolicyTreeBadRequest) Code() int {
	return 400
}

func (o *PutPolicyTreeBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/policies][%d] putPolicyTreeBadRequest %s", 400, payload)
}

func (o *PutPolicyTreeBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/policies][%d] putPolicyTreeBadRequest %s", 400, payload)
}

func (o *PutPolicyTreeBadRequest) GetPayload() *models.ValidationError {
	return o.Payload
}

func (o *PutPolicyTreeBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ValidationError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
