// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UnstarDashboardReader is a Reader for the UnstarDashboard structure.
type UnstarDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnstarDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnstarDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUnstarDashboardBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUnstarDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUnstarDashboardForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUnstarDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /user/stars/dashboard/{dashboard_id}] unstarDashboard", response, response.Code())
	}
}

// NewUnstarDashboardOK creates a UnstarDashboardOK with default headers values
func NewUnstarDashboardOK() *UnstarDashboardOK {
	return &UnstarDashboardOK{}
}

/*
UnstarDashboardOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UnstarDashboardOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this unstar dashboard Ok response has a 2xx status code
func (o *UnstarDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unstar dashboard Ok response has a 3xx status code
func (o *UnstarDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar dashboard Ok response has a 4xx status code
func (o *UnstarDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unstar dashboard Ok response has a 5xx status code
func (o *UnstarDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unstar dashboard Ok response a status code equal to that given
func (o *UnstarDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unstar dashboard Ok response
func (o *UnstarDashboardOK) Code() int {
	return 200
}

func (o *UnstarDashboardOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardOk %s", 200, payload)
}

func (o *UnstarDashboardOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardOk %s", 200, payload)
}

func (o *UnstarDashboardOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UnstarDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnstarDashboardBadRequest creates a UnstarDashboardBadRequest with default headers values
func NewUnstarDashboardBadRequest() *UnstarDashboardBadRequest {
	return &UnstarDashboardBadRequest{}
}

/*
UnstarDashboardBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UnstarDashboardBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this unstar dashboard bad request response has a 2xx status code
func (o *UnstarDashboardBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this unstar dashboard bad request response has a 3xx status code
func (o *UnstarDashboardBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar dashboard bad request response has a 4xx status code
func (o *UnstarDashboardBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this unstar dashboard bad request response has a 5xx status code
func (o *UnstarDashboardBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this unstar dashboard bad request response a status code equal to that given
func (o *UnstarDashboardBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the unstar dashboard bad request response
func (o *UnstarDashboardBadRequest) Code() int {
	return 400
}

func (o *UnstarDashboardBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardBadRequest %s", 400, payload)
}

func (o *UnstarDashboardBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardBadRequest %s", 400, payload)
}

func (o *UnstarDashboardBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UnstarDashboardBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnstarDashboardUnauthorized creates a UnstarDashboardUnauthorized with default headers values
func NewUnstarDashboardUnauthorized() *UnstarDashboardUnauthorized {
	return &UnstarDashboardUnauthorized{}
}

/*
UnstarDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UnstarDashboardUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this unstar dashboard unauthorized response has a 2xx status code
func (o *UnstarDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this unstar dashboard unauthorized response has a 3xx status code
func (o *UnstarDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar dashboard unauthorized response has a 4xx status code
func (o *UnstarDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this unstar dashboard unauthorized response has a 5xx status code
func (o *UnstarDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this unstar dashboard unauthorized response a status code equal to that given
func (o *UnstarDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the unstar dashboard unauthorized response
func (o *UnstarDashboardUnauthorized) Code() int {
	return 401
}

func (o *UnstarDashboardUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardUnauthorized %s", 401, payload)
}

func (o *UnstarDashboardUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardUnauthorized %s", 401, payload)
}

func (o *UnstarDashboardUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UnstarDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnstarDashboardForbidden creates a UnstarDashboardForbidden with default headers values
func NewUnstarDashboardForbidden() *UnstarDashboardForbidden {
	return &UnstarDashboardForbidden{}
}

/*
UnstarDashboardForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UnstarDashboardForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this unstar dashboard forbidden response has a 2xx status code
func (o *UnstarDashboardForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this unstar dashboard forbidden response has a 3xx status code
func (o *UnstarDashboardForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar dashboard forbidden response has a 4xx status code
func (o *UnstarDashboardForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this unstar dashboard forbidden response has a 5xx status code
func (o *UnstarDashboardForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this unstar dashboard forbidden response a status code equal to that given
func (o *UnstarDashboardForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the unstar dashboard forbidden response
func (o *UnstarDashboardForbidden) Code() int {
	return 403
}

func (o *UnstarDashboardForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardForbidden %s", 403, payload)
}

func (o *UnstarDashboardForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardForbidden %s", 403, payload)
}

func (o *UnstarDashboardForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UnstarDashboardForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnstarDashboardInternalServerError creates a UnstarDashboardInternalServerError with default headers values
func NewUnstarDashboardInternalServerError() *UnstarDashboardInternalServerError {
	return &UnstarDashboardInternalServerError{}
}

/*
UnstarDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UnstarDashboardInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this unstar dashboard internal server error response has a 2xx status code
func (o *UnstarDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this unstar dashboard internal server error response has a 3xx status code
func (o *UnstarDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar dashboard internal server error response has a 4xx status code
func (o *UnstarDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this unstar dashboard internal server error response has a 5xx status code
func (o *UnstarDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this unstar dashboard internal server error response a status code equal to that given
func (o *UnstarDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the unstar dashboard internal server error response
func (o *UnstarDashboardInternalServerError) Code() int {
	return 500
}

func (o *UnstarDashboardInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardInternalServerError %s", 500, payload)
}

func (o *UnstarDashboardInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /user/stars/dashboard/{dashboard_id}][%d] unstarDashboardInternalServerError %s", 500, payload)
}

func (o *UnstarDashboardInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UnstarDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
