// Code generated by go-swagger; DO NOT EDIT.

package signing_keys

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new signing keys API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for signing keys API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	RetrieveJWKS(opts ...ClientOption) (*RetrieveJWKSOK, error)
	RetrieveJWKSWithParams(params *RetrieveJWKSParams, opts ...ClientOption) (*RetrieveJWKSOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
RetrieveJWKS gets JSON web key set j w k s with all the keys that can be used to verify tokens public keys

Required permissions
None
*/
func (a *Client) RetrieveJWKS(opts ...ClientOption) (*RetrieveJWKSOK, error) {
	params := NewRetrieveJWKSParams()
	return a.RetrieveJWKSWithParams(params, opts...)
}

func (a *Client) RetrieveJWKSWithParams(params *RetrieveJWKSParams, opts ...ClientOption) (*RetrieveJWKSOK, error) {
	if params == nil {
		params = NewRetrieveJWKSParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "retrieveJWKS",
		Method:             "GET",
		PathPattern:        "/signing-keys/keys",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RetrieveJWKSReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RetrieveJWKSOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for retrieveJWKS: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
