// Code generated by go-swagger; DO NOT EDIT.

package sync_team_groups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new sync team groups API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for sync team groups API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AddTeamGroupAPI(teamID int64, body *models.TeamGroupMapping, opts ...ClientOption) (*AddTeamGroupAPIOK, error)
	AddTeamGroupAPIWithParams(params *AddTeamGroupAPIParams, opts ...ClientOption) (*AddTeamGroupAPIOK, error)

	GetTeamGroupsAPI(teamID int64, opts ...ClientOption) (*GetTeamGroupsAPIOK, error)
	GetTeamGroupsAPIWithParams(params *GetTeamGroupsAPIParams, opts ...ClientOption) (*GetTeamGroupsAPIOK, error)

	RemoveTeamGroupAPIQuery(params *RemoveTeamGroupAPIQueryParams, opts ...ClientOption) (*RemoveTeamGroupAPIQueryOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AddTeamGroupAPI adds external group
*/
func (a *Client) AddTeamGroupAPI(teamID int64, body *models.TeamGroupMapping, opts ...ClientOption) (*AddTeamGroupAPIOK, error) {
	params := NewAddTeamGroupAPIParams().WithBody(body).WithTeamID(teamID)
	return a.AddTeamGroupAPIWithParams(params, opts...)
}

func (a *Client) AddTeamGroupAPIWithParams(params *AddTeamGroupAPIParams, opts ...ClientOption) (*AddTeamGroupAPIOK, error) {
	if params == nil {
		params = NewAddTeamGroupAPIParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addTeamGroupApi",
		Method:             "POST",
		PathPattern:        "/teams/{teamId}/groups",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AddTeamGroupAPIReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AddTeamGroupAPIOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for addTeamGroupApi: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetTeamGroupsAPI gets external groups
*/
func (a *Client) GetTeamGroupsAPI(teamID int64, opts ...ClientOption) (*GetTeamGroupsAPIOK, error) {
	params := NewGetTeamGroupsAPIParams().WithTeamID(teamID)
	return a.GetTeamGroupsAPIWithParams(params, opts...)
}

func (a *Client) GetTeamGroupsAPIWithParams(params *GetTeamGroupsAPIParams, opts ...ClientOption) (*GetTeamGroupsAPIOK, error) {
	if params == nil {
		params = NewGetTeamGroupsAPIParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getTeamGroupsApi",
		Method:             "GET",
		PathPattern:        "/teams/{teamId}/groups",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetTeamGroupsAPIReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTeamGroupsAPIOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getTeamGroupsApi: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RemoveTeamGroupAPIQuery removes external group
*/

func (a *Client) RemoveTeamGroupAPIQuery(params *RemoveTeamGroupAPIQueryParams, opts ...ClientOption) (*RemoveTeamGroupAPIQueryOK, error) {
	if params == nil {
		params = NewRemoveTeamGroupAPIQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "removeTeamGroupApiQuery",
		Method:             "DELETE",
		PathPattern:        "/teams/{teamId}/groups",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RemoveTeamGroupAPIQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RemoveTeamGroupAPIQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for removeTeamGroupApiQuery: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
