// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SNSConfig SNS config
//
// swagger:model SNSConfig
type SNSConfig struct {

	// api url
	APIURL string `json:"api_url,omitempty"`

	// attributes
	Attributes map[string]string `json:"attributes,omitempty"`

	// http config
	HTTPConfig *HTTPClientConfig `json:"http_config,omitempty"`

	// message
	Message string `json:"message,omitempty"`

	// phone number
	PhoneNumber string `json:"phone_number,omitempty"`

	// send resolved
	SendResolved bool `json:"send_resolved,omitempty"`

	// sigv4
	Sigv4 *SigV4Config `json:"sigv4,omitempty"`

	// subject
	Subject string `json:"subject,omitempty"`

	// target arn
	TargetArn string `json:"target_arn,omitempty"`

	// topic arn
	TopicArn string `json:"topic_arn,omitempty"`
}

// Validate validates this SNS config
func (m *SNSConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHTTPConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSigv4(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SNSConfig) validateHTTPConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPConfig) { // not required
		return nil
	}

	if m.HTTPConfig != nil {
		if err := m.HTTPConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_config")
			}
			return err
		}
	}

	return nil
}

func (m *SNSConfig) validateSigv4(formats strfmt.Registry) error {
	if swag.IsZero(m.Sigv4) { // not required
		return nil
	}

	if m.Sigv4 != nil {
		if err := m.Sigv4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sigv4")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sigv4")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this SNS config based on the context it is used
func (m *SNSConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHTTPConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSigv4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SNSConfig) contextValidateHTTPConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.HTTPConfig != nil {

		if swag.IsZero(m.HTTPConfig) { // not required
			return nil
		}

		if err := m.HTTPConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_config")
			}
			return err
		}
	}

	return nil
}

func (m *SNSConfig) contextValidateSigv4(ctx context.Context, formats strfmt.Registry) error {

	if m.Sigv4 != nil {

		if swag.IsZero(m.Sigv4) { // not required
			return nil
		}

		if err := m.Sigv4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sigv4")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sigv4")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SNSConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SNSConfig) UnmarshalBinary(b []byte) error {
	var res SNSConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
