// Code generated by go-swagger; DO NOT EDIT.

package billing_account_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// NewBillingAccountServiceCreateParams creates a new BillingAccountServiceCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBillingAccountServiceCreateParams() *BillingAccountServiceCreateParams {
	return &BillingAccountServiceCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBillingAccountServiceCreateParamsWithTimeout creates a new BillingAccountServiceCreateParams object
// with the ability to set a timeout on a request.
func NewBillingAccountServiceCreateParamsWithTimeout(timeout time.Duration) *BillingAccountServiceCreateParams {
	return &BillingAccountServiceCreateParams{
		timeout: timeout,
	}
}

// NewBillingAccountServiceCreateParamsWithContext creates a new BillingAccountServiceCreateParams object
// with the ability to set a context for a request.
func NewBillingAccountServiceCreateParamsWithContext(ctx context.Context) *BillingAccountServiceCreateParams {
	return &BillingAccountServiceCreateParams{
		Context: ctx,
	}
}

// NewBillingAccountServiceCreateParamsWithHTTPClient creates a new BillingAccountServiceCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewBillingAccountServiceCreateParamsWithHTTPClient(client *http.Client) *BillingAccountServiceCreateParams {
	return &BillingAccountServiceCreateParams{
		HTTPClient: client,
	}
}

/*
BillingAccountServiceCreateParams contains all the parameters to send to the API endpoint

	for the billing account service create operation.

	Typically these are written to a http.Request.
*/
type BillingAccountServiceCreateParams struct {

	// Body.
	Body *models.BillingAccountServiceCreateBody

	/* OrganizationID.

	     organization_id is the ID of the organization to which the Billing Account
	belongs.
	*/
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the billing account service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceCreateParams) WithDefaults() *BillingAccountServiceCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the billing account service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the billing account service create params
func (o *BillingAccountServiceCreateParams) WithTimeout(timeout time.Duration) *BillingAccountServiceCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the billing account service create params
func (o *BillingAccountServiceCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the billing account service create params
func (o *BillingAccountServiceCreateParams) WithContext(ctx context.Context) *BillingAccountServiceCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the billing account service create params
func (o *BillingAccountServiceCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the billing account service create params
func (o *BillingAccountServiceCreateParams) WithHTTPClient(client *http.Client) *BillingAccountServiceCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the billing account service create params
func (o *BillingAccountServiceCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the billing account service create params
func (o *BillingAccountServiceCreateParams) WithBody(body *models.BillingAccountServiceCreateBody) *BillingAccountServiceCreateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the billing account service create params
func (o *BillingAccountServiceCreateParams) SetBody(body *models.BillingAccountServiceCreateBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the billing account service create params
func (o *BillingAccountServiceCreateParams) WithOrganizationID(organizationID string) *BillingAccountServiceCreateParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the billing account service create params
func (o *BillingAccountServiceCreateParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *BillingAccountServiceCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
