// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceMaintenanceWindowUpdateReader is a Reader for the BoundaryServiceMaintenanceWindowUpdate structure.
type BoundaryServiceMaintenanceWindowUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceMaintenanceWindowUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceMaintenanceWindowUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceMaintenanceWindowUpdateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceMaintenanceWindowUpdateOK creates a BoundaryServiceMaintenanceWindowUpdateOK with default headers values
func NewBoundaryServiceMaintenanceWindowUpdateOK() *BoundaryServiceMaintenanceWindowUpdateOK {
	return &BoundaryServiceMaintenanceWindowUpdateOK{}
}

/*
BoundaryServiceMaintenanceWindowUpdateOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceMaintenanceWindowUpdateOK struct {
	Payload models.HashicorpCloudBoundary20211221MaintenanceWindowUpdateResponse
}

// IsSuccess returns true when this boundary service maintenance window update o k response has a 2xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service maintenance window update o k response has a 3xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service maintenance window update o k response has a 4xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service maintenance window update o k response has a 5xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service maintenance window update o k response a status code equal to that given
func (o *BoundaryServiceMaintenanceWindowUpdateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service maintenance window update o k response
func (o *BoundaryServiceMaintenanceWindowUpdateOK) Code() int {
	return 200
}

func (o *BoundaryServiceMaintenanceWindowUpdateOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] boundaryServiceMaintenanceWindowUpdateOK %s", 200, payload)
}

func (o *BoundaryServiceMaintenanceWindowUpdateOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] boundaryServiceMaintenanceWindowUpdateOK %s", 200, payload)
}

func (o *BoundaryServiceMaintenanceWindowUpdateOK) GetPayload() models.HashicorpCloudBoundary20211221MaintenanceWindowUpdateResponse {
	return o.Payload
}

func (o *BoundaryServiceMaintenanceWindowUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceMaintenanceWindowUpdateDefault creates a BoundaryServiceMaintenanceWindowUpdateDefault with default headers values
func NewBoundaryServiceMaintenanceWindowUpdateDefault(code int) *BoundaryServiceMaintenanceWindowUpdateDefault {
	return &BoundaryServiceMaintenanceWindowUpdateDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceMaintenanceWindowUpdateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceMaintenanceWindowUpdateDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service maintenance window update default response has a 2xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service maintenance window update default response has a 3xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service maintenance window update default response has a 4xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service maintenance window update default response has a 5xx status code
func (o *BoundaryServiceMaintenanceWindowUpdateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service maintenance window update default response a status code equal to that given
func (o *BoundaryServiceMaintenanceWindowUpdateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service maintenance window update default response
func (o *BoundaryServiceMaintenanceWindowUpdateDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceMaintenanceWindowUpdateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] BoundaryService_MaintenanceWindowUpdate default %s", o._statusCode, payload)
}

func (o *BoundaryServiceMaintenanceWindowUpdateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] BoundaryService_MaintenanceWindowUpdate default %s", o._statusCode, payload)
}

func (o *BoundaryServiceMaintenanceWindowUpdateDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceMaintenanceWindowUpdateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
