// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest MaintenanceWindowUpdateRequest is the request to update the maintenance window for a cluster.
//
// swagger:model hashicorp.cloud.boundary_20211221.MaintenanceWindowUpdateRequest
type HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest struct {

	// cluster_id is the ID of the cluster to set the maintenance window for.
	ClusterID string `json:"cluster_id,omitempty"`

	// location is the location of the cluster.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`

	// maintenance_window contains time frame that we want to update the cluster.
	MaintenanceWindow *HashicorpCloudBoundary20211221MaintenanceWindow `json:"maintenance_window,omitempty"`

	// upgrade_type contains upgrade methods for the clusters
	UpgradeType *HashicorpCloudBoundary20211221UpgradeType `json:"upgrade_type,omitempty"`
}

// Validate validates this hashicorp cloud boundary 20211221 maintenance window update request
func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaintenanceWindow(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpgradeType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) validateMaintenanceWindow(formats strfmt.Registry) error {
	if swag.IsZero(m.MaintenanceWindow) { // not required
		return nil
	}

	if m.MaintenanceWindow != nil {
		if err := m.MaintenanceWindow.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maintenance_window")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("maintenance_window")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) validateUpgradeType(formats strfmt.Registry) error {
	if swag.IsZero(m.UpgradeType) { // not required
		return nil
	}

	if m.UpgradeType != nil {
		if err := m.UpgradeType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("upgrade_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("upgrade_type")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud boundary 20211221 maintenance window update request based on the context it is used
func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaintenanceWindow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpgradeType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) contextValidateMaintenanceWindow(ctx context.Context, formats strfmt.Registry) error {

	if m.MaintenanceWindow != nil {

		if swag.IsZero(m.MaintenanceWindow) { // not required
			return nil
		}

		if err := m.MaintenanceWindow.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maintenance_window")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("maintenance_window")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) contextValidateUpgradeType(ctx context.Context, formats strfmt.Registry) error {

	if m.UpgradeType != nil {

		if swag.IsZero(m.UpgradeType) { // not required
			return nil
		}

		if err := m.UpgradeType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("upgrade_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("upgrade_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudBoundary20211221MaintenanceWindowUpdateRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
