// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceDeleteProjectServicePrincipalKeyReader is a Reader for the ServicePrincipalsServiceDeleteProjectServicePrincipalKey structure.
type ServicePrincipalsServiceDeleteProjectServicePrincipalKeyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK creates a ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK with default headers values
func NewServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK() *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK {
	return &ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK{}
}

/*
ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK struct {
	Payload models.HashicorpCloudIamDeleteProjectServicePrincipalKeyResponse
}

// IsSuccess returns true when this service principals service delete project service principal key o k response has a 2xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service delete project service principal key o k response has a 3xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service delete project service principal key o k response has a 4xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service delete project service principal key o k response has a 5xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service delete project service principal key o k response a status code equal to that given
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service delete project service principal key o k response
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principal-keys/{client_id}][%d] servicePrincipalsServiceDeleteProjectServicePrincipalKeyOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principal-keys/{client_id}][%d] servicePrincipalsServiceDeleteProjectServicePrincipalKeyOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) GetPayload() models.HashicorpCloudIamDeleteProjectServicePrincipalKeyResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault creates a ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault with default headers values
func NewServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault(code int) *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault {
	return &ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service delete project service principal key default response has a 2xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service delete project service principal key default response has a 3xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service delete project service principal key default response has a 4xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service delete project service principal key default response has a 5xx status code
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service delete project service principal key default response a status code equal to that given
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service delete project service principal key default response
func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principal-keys/{client_id}][%d] ServicePrincipalsService_DeleteProjectServicePrincipalKey default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principal-keys/{client_id}][%d] ServicePrincipalsService_DeleteProjectServicePrincipalKey default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
