// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceDeleteWorkloadIdentityProviderReader is a Reader for the ServicePrincipalsServiceDeleteWorkloadIdentityProvider structure.
type ServicePrincipalsServiceDeleteWorkloadIdentityProviderReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceDeleteWorkloadIdentityProviderOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceDeleteWorkloadIdentityProviderOK creates a ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK with default headers values
func NewServicePrincipalsServiceDeleteWorkloadIdentityProviderOK() *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK {
	return &ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK{}
}

/*
ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK struct {
	Payload *models.HashicorpCloudIamDeleteWorkloadIdentityProviderResponse
}

// IsSuccess returns true when this service principals service delete workload identity provider o k response has a 2xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service delete workload identity provider o k response has a 3xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service delete workload identity provider o k response has a 4xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service delete workload identity provider o k response has a 5xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service delete workload identity provider o k response a status code equal to that given
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service delete workload identity provider o k response
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /2019-12-10/{resource_name_4}][%d] servicePrincipalsServiceDeleteWorkloadIdentityProviderOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /2019-12-10/{resource_name_4}][%d] servicePrincipalsServiceDeleteWorkloadIdentityProviderOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) GetPayload() *models.HashicorpCloudIamDeleteWorkloadIdentityProviderResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamDeleteWorkloadIdentityProviderResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault creates a ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault with default headers values
func NewServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault(code int) *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault {
	return &ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service delete workload identity provider default response has a 2xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service delete workload identity provider default response has a 3xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service delete workload identity provider default response has a 4xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service delete workload identity provider default response has a 5xx status code
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service delete workload identity provider default response a status code equal to that given
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service delete workload identity provider default response
func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /2019-12-10/{resource_name_4}][%d] ServicePrincipalsService_DeleteWorkloadIdentityProvider default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /2019-12-10/{resource_name_4}][%d] ServicePrincipalsService_DeleteWorkloadIdentityProvider default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
