// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// LogServiceStoreReader is a Reader for the LogServiceStore structure.
type LogServiceStoreReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LogServiceStoreReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLogServiceStoreOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLogServiceStoreDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLogServiceStoreOK creates a LogServiceStoreOK with default headers values
func NewLogServiceStoreOK() *LogServiceStoreOK {
	return &LogServiceStoreOK{}
}

/*
LogServiceStoreOK describes a response with status code 200, with default header values.

A successful response.
*/
type LogServiceStoreOK struct {
	Payload interface{}
}

// IsSuccess returns true when this log service store o k response has a 2xx status code
func (o *LogServiceStoreOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this log service store o k response has a 3xx status code
func (o *LogServiceStoreOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this log service store o k response has a 4xx status code
func (o *LogServiceStoreOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this log service store o k response has a 5xx status code
func (o *LogServiceStoreOK) IsServerError() bool {
	return false
}

// IsCode returns true when this log service store o k response a status code equal to that given
func (o *LogServiceStoreOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the log service store o k response
func (o *LogServiceStoreOK) Code() int {
	return 200
}

func (o *LogServiceStoreOK) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{stream.organization_id}/entries/store][%d] logServiceStoreOK  %+v", 200, o.Payload)
}

func (o *LogServiceStoreOK) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{stream.organization_id}/entries/store][%d] logServiceStoreOK  %+v", 200, o.Payload)
}

func (o *LogServiceStoreOK) GetPayload() interface{} {
	return o.Payload
}

func (o *LogServiceStoreOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLogServiceStoreDefault creates a LogServiceStoreDefault with default headers values
func NewLogServiceStoreDefault(code int) *LogServiceStoreDefault {
	return &LogServiceStoreDefault{
		_statusCode: code,
	}
}

/*
LogServiceStoreDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type LogServiceStoreDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this log service store default response has a 2xx status code
func (o *LogServiceStoreDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this log service store default response has a 3xx status code
func (o *LogServiceStoreDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this log service store default response has a 4xx status code
func (o *LogServiceStoreDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this log service store default response has a 5xx status code
func (o *LogServiceStoreDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this log service store default response a status code equal to that given
func (o *LogServiceStoreDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the log service store default response
func (o *LogServiceStoreDefault) Code() int {
	return o._statusCode
}

func (o *LogServiceStoreDefault) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{stream.organization_id}/entries/store][%d] LogService_Store default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceStoreDefault) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{stream.organization_id}/entries/store][%d] LogService_Store default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceStoreDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *LogServiceStoreDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
